/* newterm:  a program to switch between terminal agents, e.g. from sts to
 * vgts.  All pre-existing execs will be destroyed after the switch is
 * complete, but the new terminal agent, (if it really is one!) will create
 * a new one.  This program is armed to the teeth against exceptional
 * circumstances because it is so likely to leave the world crashed if it
 * fails.
 *
 * Kenneth Brooks, November 1983
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vtermagent.h>	/* for GetRawIO */
#include <Vteams.h>
#include <Vgroupids.h>

ProcessId execserver;
ProcessId inserver, outserver;
InstanceId infile, outfile;
ProcessId newpid;

Message msg;

char *progargv[2] = {"vgts", NULL};  /* the NULL terminates the argv list */

main(argc, argv)
  int argc;
  char *argv[];
  {
    register RawIOReply *rawio= (RawIOReply *) msg;
    SystemCode error;
    int count;

    /* set up progargv to run the desired terminal agent program */
    if (argc > 1) progargv[0] = argv[1];

    execserver = GetPid(EXEC_SERVER, LOCAL_PID);
    if (!execserver)
      { fprintf(stderr, "Can't find exec server!\n"); exit(1); }

    rawio->replycode /* request code, actually */ = GetRawIO;
    Send(rawio, execserver);
    if (rawio->replycode != OK)
      { 
	fprintf(stderr, "Can't get raw console, %s\n", 
		ErrorString(rawio->replycode) );
	exit(1);
      }
    inserver = rawio->inserver;
    infile = rawio->infile;
    outserver = rawio->outserver;
    outfile = rawio->outfile;
#ifdef DEBUG
    fprintf(stderr, "raw io: %x %d in, %x %d out\n", inserver, infile,
	outserver, outfile);
    Flush(stderr);
    Delay(2, 0);  /* time to read the stuff */
#endif DEBUG

    stdout = OpenFile(outserver, outfile, FAPPEND, &error);
    if (error)
      {	PrintError(error, "Can't open console for output"); exit(1); }

    stdin = OpenFile(inserver, infile, FREAD, &error);
    if (error)
      { PrintError(error, "Can't open console for input"); exit(1); }

    stderr = stdout;
    /* point of no return!  At least, no more messages in our exec window */

    /* Try to destroy all existing terminal servers by sending them
     * a message asking them to commit suicide.  This may be necessary if the
     * terminal server was running as SYSTEM_USER, so DestroyProcess cannot
     * be used.
     */

    for (count = 0, rawio->replycode = OK;
    	 count < 10 && rawio->replycode == OK;
	 count++)
      {
	rawio->replycode /* request code, actually */ = Die;
	Send(rawio, LTERMINAL_SERVER_GROUP);
      }

    if (rawio->replycode == OK)
      {
        fprintf(stderr, "Couldn't kill all servers!\n");
	exit(1);
      }

    /* real point of no return.  If we crash now, have to reboot. */
    newpid = ExecProgram(progargv, NULL, NULL, NULL, NULL, &error);
    if (error)
      {
	/* rather than destroy the world, we try to load the vgts */
	PrintError(error, "Program load failed");
	fprintf(stderr, "Loading [bin]vgts\n");
	progargv[0] = "[bin]vgts";
	newpid = ExecProgram(progargv, NULL, NULL, NULL, NULL, &error);
	if (error)
	  {
	    PrintError(error, "Can't load vgts, all is lost!");
	    exit(1);
	  }
      }
    ChangeTeamPriority(newpid, REAL_TIME4);

    /* new agent is in place, now CheckExecs to kill off old io-less execs.
     * that probably includes ours, so this is suicide.
     */
    CheckExecs(execserver);
  }
