/* some primitives of MetaFont84, for V. Per Bothner, April 1984.
 * There files contain V system and pc68-compiler dependent routines.
 * detect CTRL/C interrrupts for MetaFont
 * Get command line
 * a_stat, b_stat, w_stat: Test if file was opened sucessfully.
 */
#include <Vio.h>
static int *Interrupt;
static char *OK_to_interrupt;

static Message msg;
static Idle() { Receive(msg); }

static struct {char stack[300];} IdleStack;
static WaitForBreak()
  {
    ProcessId BreakProcess;
    for (;;)
      { 
	BreakProcess = Ready(CreateProcess(0xFF, Idle, &IdleStack+1), 0);
	SetBreakProcess(stdin, BreakProcess);
	ReceiveSpecific(msg, BreakProcess);
	/* looks like BreakProcess just died; can we interrupt ? */
	if (*OK_to_interrupt) *Interrupt = 1;
      }
  }
static ProcessId waitingPid = 0;
initinterrupt(interrupt, ok_to_interrupt)
    int *interrupt; char *ok_to_interrupt;
  {
    Interrupt = interrupt;
    OK_to_interrupt = ok_to_interrupt;
    if (waitingPid == 0)
	waitingPid = Ready(Create(0, WaitForBreak, 700), 0);
  }

extern int _args_[2]; /* pc68 saves argc and argv in these */
getcommandline(buf, first, max)
    char *buf;
  { register char *s = buf + first, *t, *lim = buf + max; int narg;
    char **cur = (char**)_args_[1];
    while (t = *++cur)
      {
	while (*t)
	  {
	    if (s >= lim) {*s++ = ' '; goto retrn;}
	    *s++ = *t++;
	  }
	*s++ = ' ';
      }
  retrn:
    return s - buf;
  }

lineedit(buffer, first, last)
    char *buffer;
  {
    fflush(stdout); fflush(stderr);
    EditLine(stdin, buffer+first, last-first);
  }

astat(fdb) /* is file 'fdb' opened successfully? */
    long *fdb; /* really a pointer to a Pascal file */
  { /* kludge! Assumes first long of *fdb is status */
    return *fdb > 0;
  }
/* duplication because of Pascal's restrictive typing */
bstat(fdb) { return astat(fdb); }
wstat(fdb) { return astat(fdb); }
