#ifndef lint
static char sccsid[] = "@(#)quit.c	2.7 (Berkeley) 8/11/83";
#endif

#include "rcv.h"
#include <sys/stat.h>

/*
 * Rcv -- receive mail rationally.
 *
 * Termination processing.
 */

/*
 * Save all of the undetermined messages at the end of "mbox"
 * Save all untouched or preserved messages back in the system mailbox.
 * Remove the system mailbox, if none saved there.
 */

quit()
{
	int mcount, p, modify, autohold, anystat, holdbit, nohold;
	FILE *ibuf, *obuf, *fbuf, *rbuf, *readstat;
	register struct message *mp;
	register int c;
	extern char tempQuit[], tempResid[];
	extern int newMailArrived;
	struct stat minfo;
	char *id;
	int nAttempts;

	/*
	 * If we are read only, we can't do anything,
	 * so just return quickly.
	 */

	if (readonly)
		return;
	/*
	 * See if there any messages to save in mbox.  If no, we
	 * can save copying mbox to /tmp and back.
	 *
	 * Check also to see if any files need to be preserved.
	 * Delete all untouched messages to keep them out of mbox.
	 * If all the messages are to be preserved, just exit with
	 * a message.
	 *
	 * If the luser has sent mail to himself, refuse to do
	 * anything with the mailbox, unless mail locking works.
	 */

	lock(mailname);
#ifndef CANLOCK
	if (selfsent) {
		printf("You have new mail.\n");
		unlock();
		return;
	}
#endif

	nAttempts = 0;
tryagain:
	++nAttempts;
	if (nAttempts > 5)
	  {
	    extern exitOnUpdate;
	    
	    exitOnUpdate = 0; /* to keep us in "mail". */
	    goto exitquit;
	  }

	rbuf = NULL;
	fbuf = fopen(mailname, "r");
	if (fsize(fbuf) > mailsize) 
	  {
	    /*
	     * New mail at the end of the system mailbox -- copy it over
	     * to our temp file.
	     */
		printf("New mail has arrived.\n");
		newMailArrived = 1;
		rbuf = fopen(tempResid, "w");
		if (rbuf == NULL || fbuf == NULL)
			goto newmail;
		fseek(fbuf, mailsize, 0);
		while ((c = getc(fbuf)) != EOF)
			putc(c, rbuf);
		fclose(rbuf);
		if ((rbuf = fopen(tempResid, "r")) == NULL)
			goto newmail;
#ifndef Vsystem
		remove(tempResid);
#endif Vsystem
	}
	fclose(fbuf);

	/*
	 * Adjust the message flags in each message.
	 */

	anystat = 0;
	autohold = DamnCompiler(value("hold") , NOSTR);
	holdbit = autohold ? MPRESERVE : MBOX;
	nohold = MBOX|MSAVED|MDELETED|MPRESERVE;
	if (value("keepsave") != NOSTR)
		nohold &= ~MSAVED;
	for (mp = &message[0]; mp < &message[msgCount]; mp++) {
		if (mp->m_flag & MNEW) {
			mp->m_flag &= ~MNEW;
			mp->m_flag |= MSTATUS;
		}
		if (mp->m_flag & MSTATUS)
			anystat++;
		if ((mp->m_flag & MTOUCH) == 0)
			mp->m_flag |= MPRESERVE;
		if ((mp->m_flag & nohold) == 0)
			mp->m_flag |= holdbit;
	}
	modify = 0;
	if (Tflag != NOSTR) {
		if ((readstat = fopen(Tflag, "w")) == NULL)
			Tflag = NOSTR;
	}
	for (c = 0, p = 0, mp = &message[0]; mp < &message[msgCount]; mp++) {
		if (mp->m_flag & MBOX)
			c++;
		if (mp->m_flag & MPRESERVE)
			p++;
		if (mp->m_flag & MODIFY)
			modify++;
		if (Tflag != NOSTR && (mp->m_flag & (MREAD|MDELETED)) != 0) {
			id = hfield("article-id", mp);
			if (id != NOSTR)
				fprintf(readstat, "%s\n", id);
		}
	}
	if (Tflag != NOSTR)
		fclose(readstat);
	if (p == msgCount && !modify && !anystat) {
		if (p == 1)
			printf("Held 1 message in %s\n", mailname);
		else
			printf("Held %2d messages in %s\n", p, mailname);
		goto exitquit;
	}
	if (c == 0) {
		if (p != 0) {
			if (writeback(rbuf) < 0)
			  {
			    printf("quit(): error 1, retrying...\n");
			    goto tryagain;
			  }
		goto exitquit;
		}
		goto cream;
	}

	/*
	 * Create another temporary file and copy user's mbox file
	 * darin.  If there is no mbox, copy nothing.
	 * If he has specified "append" don't copy his mailbox,
	 * just copy saveable entries at the end.
	 */

	mcount = c;
	if (value("append") == NOSTR) {
		if ((obuf = fopen(tempQuit, "w")) == NULL) {
			perror(tempQuit);
			goto exitquit;
		}
		if ((ibuf = fopen(tempQuit, "r")) == NULL) {
			perror(tempQuit);
			remove(tempQuit);
			fclose(obuf);
			goto exitquit;
		}
		remove(tempQuit);
		if ((fbuf = fopen(mbox, "r")) != NULL) {
			while ((c = getc(fbuf)) != EOF)
				putc(c, obuf);
			fclose(fbuf);
		}
		if (ferror(obuf)) {
			perror(tempQuit);
			fclose(ibuf);
			fclose(obuf);
			goto exitquit;
		}
		fclose(obuf);
		fclose(CreateFile(mbox, 0600));
		if ((obuf = fopen(mbox, "w")) == NULL) {
			perror(mbox);
			fclose(ibuf);
			goto exitquit;
		}
	}
	if (value("append") != NOSTR)
		if ((obuf = fopen(mbox, "a")) == NULL) {
			perror(mbox);
			goto exitquit;
		}
	for (mp = &message[0]; mp < &message[msgCount]; mp++)
		if (mp->m_flag & MBOX)
			if (send(mp, obuf, 0) < 0) {
				perror(mbox);
				fclose(ibuf);
				fclose(obuf);
				goto exitquit;
			}

	/*
	 * Copy the user's old mbox contents back
	 * to the end of the stuff we just saved.
	 * If we are appending, this is unnecessary.
	 */

	if (value("append") == NOSTR) {
		rewind(ibuf);
		c = getc(ibuf);
		while (c != EOF) {
			putc(c, obuf);
			if (ferror(obuf))
				break;
			c = getc(ibuf);
		}
		fclose(ibuf);
		fflush(obuf);
	}
# ifndef Vsystem
	trunc(obuf);
# endif Vsystem
	if (ferror(obuf)) {
		perror(mbox);
		fclose(obuf);
		goto exitquit;
	}
	fclose(obuf);
	if (mcount == 1)
		printf("Saved 1 message in mbox\n");
	else
		printf("Saved %d messages in mbox\n", mcount);

	/*
	 * Now we are ready to copy back preserved messages to
	 * the system mailbox, if any were requested.
	 */

	if (p != 0) {
		if (writeback(rbuf) < 0)
		  {
		    printf("quit(): error 2, retrying...\n");
		    goto tryagain;
		  }
		goto exitquit;
	}

	/*
	 * Finally, remove his /usr/mail file.
	 * If new mail has arrived, copy it back.
	 */

cream:
	if (rbuf != NULL) {
		fbuf = fopen(mailname, "r+");
		if (fbuf == NULL)
			goto newmail;
		while ((c = getc(rbuf)) != EOF)
			putc(c, fbuf);
		fclose(rbuf);
# ifndef Vsystem
		trunc(fbuf);
# endif Vsystem
		fclose(fbuf);
		alter(mailname);
		goto exitquit;
	}
	demail();
	goto exitquit;

newmail:
	printf("Thou hast new mail.\n");
	newMailArrived = 1;
	goto exitquit;

exitquit:
	if (rbuf != NULL)
	Close(rbuf);
	remove(tempResid);
	RemoveTempFiles();
	unlock();
        return;
}


RemoveTempFiles()
  {
#ifdef Vsystem
    extern FILE *itf;
    extern char tempMesg[];

    if (itf != NULL)
      {
	Close(itf);
	remove(tempMesg);
      }
#endif Vsystem
  }


/*
 * Preserve all the appropriate messages back in the system
 * mailbox, and print a nice message indicated how many were
 * saved.  On any error, just return -1.  Else return 0.
 * Incorporate the any new mail that we found.
 */
#define MAXQUITRETRY 5

writeback(res)
	register FILE *res;
{
	register struct message *mp;
	register int p, c;
	FILE *obuf, *verify;
	int retry;
	extern char tempEdit[];

#ifdef Vsystem
      {
	/* Don't touch the main mail file until we're sure that our temporary
	 * (new) mail file can be read OK.
         */
	extern FILE *itf;
	extern char tempMesg[];

	if (!validFile(itf))
	  {
	    printf("writeback() - temporary mail file (%s) is invalid!\n",
		   tempMesg);
	    if (freopen(tempMesg, "r", itf))
	      {
		printf("able to reopen %s\n", tempMesg);
	      }
	    else
	      {
		printf("unable to reopen %s - aborting writeback()\n",
		       tempMesg);
		return(-1);
	      }
	  }
      }
#endif Vsystem

    for (retry = 0; retry < MAXQUITRETRY; retry++)
      {
	p = 0;
	if ((obuf = fopen(mailname, "w")) == NULL) {
		printf("Unable to open %s for writing; retrying\n",mailname);
		continue;
	}
#ifndef APPEND
	if (res != NULL)
		while ((c = getc(res)) != EOF)
			putc(c, obuf);
#endif
	for (mp = &message[0]; mp < &message[msgCount]; mp++)
		if ((mp->m_flag&MPRESERVE)||(mp->m_flag&MTOUCH)==0) {
			p++;
			if (send(mp, obuf, 0) < 0) {
				printf("Error writing %s\n",mailname);
				fclose(obuf);
				goto tryagain;
			}
		}
#ifdef APPEND
	if (res != NULL)
		while ((c = getc(res)) != EOF)
			putc(c, obuf);
#endif
	fflush(obuf);
	rewind(obuf);
# ifndef Vsystem
	trunc(obuf);
# endif Vsystem
	if (ferror(obuf)) {
		printf("Error writing %s: %s\n",mailname,
			ErrorString(obuf->lastexception));
		fclose(obuf);
		goto tryagain;
	}
	alter(mailname);
	if (p == 1)
		printf("Held 1 message in %s\n", mailname);
	else
		printf("Held %d messages in %s\n", p, mailname);
	printf("Verifying...");
	if ((verify = fopen(tempEdit, "w")) == NULL) {
		printf("Unable to open %s\n",tempEdit);
		return(-1);
	}
	for (mp = &message[0]; mp < &message[msgCount]; mp++)
		if ((mp->m_flag&MPRESERVE)||(mp->m_flag&MTOUCH)==0) {
			p++;
			send(mp, verify, 0);
		}
	if (res != NULL)
	  {
	  	rewind(res);
		while ((c = getc(res)) != EOF)
			putc(c, verify);
	  }
	if (res != NULL)
		fclose(res);
	rewind(verify);
	while ((c = getc(verify)) != EOF)
	    if (c != getc(obuf))
	      {
	        printf("\007File %s differs from %s\007\n",mailname,tempEdit);
		fclose(obuf);
		fclose(verify);
		break;
	      }
	if (c != EOF) continue;
	fclose(obuf);
	fclose(verify);
	remove(tempEdit);
	printf("Done\n");
	return(0);
tryagain:
	printf("Retrying..\n");
    }
	if (retry == MAXQUITRETRY)
	    return(-1); /* failed too many times */
	else
	    return(0);
}


#ifdef Vsystem
#include <Vioprotocol.h>

int validFile(fad)
    FILE *fad;
    /* Determine whether "fad"s instance is valid.  (Code pinched from the 
     * ClearEof() library routine.)
     */
  {
    Message msg;
    register QueryInstanceRequest *req = (QueryInstanceRequest *) msg;
    register QueryInstanceReply *reply = (QueryInstanceReply *) msg;
    
    req->requestcode = QUERY_INSTANCE;
    req->fileid = fad->fileid;

    Send( req, fad->fileserver );
    return (reply->replycode == OK);
  }
#endif Vsystem
