#include <Vio.h>
#include <Venviron.h>

#define MAX_LOGICAL_PID 20

char *ServerNames[] =
  {
	"ACTIVE_PROCESS",
	"EXCEPTION_SERVER",
	"DEVICE_SERVER",
	"INTERNET_SERVER",
	"STORAGE_SERVER",
	"UNIX_SERVER",
	"TIME_SERVER",
	"PRINT_SERVER",
	"VGT_SERVER",
	"NAME_SERVER",
	"CONTEXT_SERVER",
	"TEAM_SERVER",
	"PIPE_SERVER",
	"KERNEL_PROCESS",
	"SERVICE_SERVER",
	"VSTORAGE_SERVER",
	"VMS_SERVER",
	"LINK_SERVER",
	"EXEC_SERVER",
	"XVSTORAGE_SERVER",
	"AUTH_SERVER"
  };

/* message formats etc*/
#define PIDREQUEST 0x2000
typedef struct
  {
    SystemCode	requestcode;	/* Will be set to PIDREQUEST. */
    short	unused[15];
  } PidRequest;

typedef struct
  {
    SystemCode	replycode;	/* Will be set to OK. */
    ProcessId	result;
    short	unused[13];
  } PidReply;

#define SUBPROCESS_PRIORITY 0
#define SUBPROCESS_STACK_SIZE 0x400

static subprocess(logicalpid, scope)
    unsigned scope, logicalpid;
  {
    ProcessId resultPid, fromPid;
    Message msg;
    PidReply *reply = (PidReply *)msg;

    resultPid = GetPid(logicalpid, scope);

    /* Receive a message from the main process, & reply with the found pid. */
    fromPid = Receive(msg);
    reply->replycode = OK;
    reply->result = resultPid;
    Reply(reply, fromPid);
  }

static ProcessId startSubprocess(logicalpid, scope)
    unsigned scope, logicalpid;
  {
    ProcessId newProcessPid;

    newProcessPid = Create(SUBPROCESS_PRIORITY, subprocess,
			   SUBPROCESS_STACK_SIZE);
    Ready(newProcessPid, 2, logicalpid, scope);
    return(newProcessPid);
  }

static ProcessId endSubprocess(subprocessPid)
    ProcessId subprocessPid;
  {
    Message msg;
    PidRequest *request = (PidRequest *)msg;
    PidReply *reply = (PidReply *)msg;

    /* Send a message to the subprocess, to get the result. */
    request->requestcode = PIDREQUEST;
    Send(request, subprocessPid);

    return(reply->result);
  }


main( argc, argv )
  int argc; char **argv;

  /*
   * Print the process identifiers of processes responding to the
   * standard services available thru GetPid.
   */
  {
    ProcessId subprocess[MAX_LOGICAL_PID+1];
    unsigned scope, logicalpid;

    if( argc > 2 )
      {
error:	printf( "Use: listservers [scope]\n" );
	exit( 1 );
      }
    scope = ANY_PID;
    if( argc == 2 )
      {
	if( Equal(argv[1], "local") ) scope = LOCAL_PID;
	else
	   if( Equal(argv[1], "any") ) scope = LOCAL_PID;
	else
	  {
	    printf("Bad scope: %s\n", argv[1] );
	    goto error;
	  }
      }

    /* Now find the servers */

    /* Start up a subprocess to find the actual pid for each logical pid. */
    for( logicalpid = 1; logicalpid <= MAX_LOGICAL_PID; ++logicalpid )
        subprocess[logicalpid] = startSubprocess(logicalpid, scope);

    /* Now get the subprocess results (in the same order). */
    for( logicalpid = 1; logicalpid <= MAX_LOGICAL_PID; ++logicalpid )
	printf( "%-16s = %8x\n",
		ServerNames[logicalpid],
		endSubprocess(subprocess[logicalpid]) );
  }
