/*
 * Prints out information about instances that are being maintained by the 
 * process (must be a Unix V session) that is providing your current context.
 */

#include <Vioprotocol.h>
#include <Vsession.h>

#define SEGMENT_SIZE 0x2000 /* 8K */

main(argc, argv)
    int argc;
    char *argv[];
  {
    Message msg;
    IoRequest *req = (IoRequest *) msg;
    IoReply *rep = (IoReply *) msg;
    static char segment[SEGMENT_SIZE];

    req->requestcode = GET_INSTANCE_INFO;
    req->bufferptr = segment;
    req->bytecount = sizeof(segment);
    
    Send(req, PerProcess->ctx.pid);
    if (rep->replycode != OK)
	PrintError(rep->replycode, "Session query failed");
    else
      {
	segment[sizeof(segment)-1] = '\0'; /* just in case */
	puts(segment);
      }
  }
