/*
 ***************************************************************************
 *                V-System Iconic User Interface Project                   *
 *									   *
 *  CS246                                       Advanced Operating Systems *
 *									   *
 *  Robert Neilon          Madhavan Srinivasan           Matthew Zekauskas *
 *   									   *
 *                            June 10, 1985   				   *
 ***************************************************************************
 *
 * screenmgr.c:   Contains the main program, the startup stub "main", and
 *	          the ending routine "Quit".
 *
 * Matthew J. Zekauskas , 05/19/85 - taken from "desktop.c"
 * 27May85 (mjz): Add call to FileHit, ClearIcon...
 */

#include <Venviron.h>                   /* null */
#include <Vgts.h>
#include <Vio.h>		/* File type, and stderr */
#include <Vtermagent.h>		/* for PageOutput bit */
#include "iconstants.h"		/* general include file */


/* global, used within this "module" */
short sdf,vgt = 0;			/* global for Quit */

/* exports */
int DebugFlag = 0;		/* set by main() */ /* print debug info */
int StatsFlag = 0;		/* likewise, prints timing statistics */
File *StatsFile = NULL;		/* to write stats to */
  /*---for pad stuff--*/
File *ReadPad, *WritePad;       /* pad instances - use for typed output */
int ScreenRefresh;		/* if set to zero we can avoid long refresh */

/* imports */
extern File *OpenPad();
extern File *OpenAndPositionPad();
extern int QueryPad();

/* "no item" item number: this one may be duplicated, and is not selectable */
#define NOITEM	0

/*
 ***************************************************************************
 *                                 Q u i t                                 *
 *-------------------------------------------------------------------------*
 *   This routine cleanly terminates things by releasing VGTS resources    *
 *   that have been used.  It is called internally, and by the stub        *
 *   routines in case of failure or at the end of "realmain" in case of    *
 *   normal return.							   *
 ***************************************************************************
 */
Quit()
  {
    if (vgt) DeleteVGT(vgt); /* delete only if created ! */
    DeleteSDF(sdf);
    ResetTTY();
    if (StatsFile != NULL) Close(StatsFile);
    exit();
  }

/*
 ***************************************************************************
 *                             r e a l m a i n                             *
 *-------------------------------------------------------------------------*
 *   The actual main process.  It sets up the screen the way we like it,   *
 *   and then enters a main loop looking for screen hits and then doing    *
 *   something about them. 						   *
 ***************************************************************************
 */
realmain()
 {
    short  item, invgt, mainSymbol, x, y, b;
    short sel;			/* selected item number */
    LISTTYPE *foundlist;	/* of selected items */
    int notdone;		/* main loop control */
    short i, j;			/* temps */

    char *currentFile = "";	/* the file name of the selected file */
    short currentIcon = 0;      /* the icon of the selected file */
    FileType currentType;       /* the type of the selected file  */

    int xMax, yMax;		/* screen size in device coords */
    int noInvert;		/* if set, we do not put text in*/
				/* rev video on screen (HACK) */
    int dx1,dx2,dy1,dy2;	/* directory bounding box */
    long GetTime();		/* for timing */
    SystemCode error;
    int padbits;		/* to turn on PagedOutput */
 


    printf("SCREENMGR starting up!\n");
    if (DebugFlag) printf(">>>> Debug Flag is set! <<<<\n");
    if (StatsFlag)
      {
	printf(">>>> Stats Flag is set! <<<<\n");
	StatsFile = Open("IconStats", FAPPEND, &error);
	if (error == NOT_FOUND)
	  StatsFile = Open("IconStats", FCREATE, &error);
	if (StatsFile == NULL)
	  {
	    printf("Open failed on IconStats: %s\n",ErrorString(error));
	    StatsFlag = 0;
	  }
      }

    /* get x and y maximums */
    GetSize(&xMax,&yMax,&noInvert);
    if (DebugFlag)
      {
	xMax -= 100;		/* give room to click mouse out of view */
	yMax -= 100;		/* and room to see things in Exec VGT */
      }
    printf("xMax = %d, yMax = %d\n",xMax,yMax);

    item = 1;
    GetTTY();
    if ((sdf = CreateSDF()) == -1)
      {
	printf("Couldn't create the SDF!\n\r\r");
	ResetTTY();
	exit();
      }
    printf("SDF number is %d\n\r\r",sdf);
    if  ((mainSymbol = DefineSymbol(sdf, item++, "main draw symbol"))
	    == 0)
      {
	printf("Couldn't define the main symbol.\n\r\r");
	Quit();
      }


/* adding in the menu bar */
    AddMenu(sdf, 0, yMax-40, xMax, yMax-20); /* add in menu items in box */
    AddItem(sdf,NOITEM,0,xMax, yMax-45, yMax-45, 0, 
		SDF_HORIZONTAL_LINE,0);		/* horiz line underneath */

/* add the icons on the right */
    AddIcon(sdf,xMax-100,xMax,0,yMax-45); /* add icons into bounded box */

    AddItem(sdf,NOITEM,xMax-100,xMax-100,0,yMax-45,0,
		SDF_VERTICAL_LINE,0);
    AddItem(sdf,NOITEM,xMax-102,xMax-102,0,yMax-45,0,
	        SDF_VERTICAL_LINE,0);


/* add in some files to look at */
                   /*xmin,xmax,    ymin                        ymax */
    /* original ymin (left bottom icon) = yMax-40-20-19-64-42-64-42-64 */
    /* now devote approx top half to icons... */
    /* noInvert flag is a hack! should be fixed & removed */
    /* (that is , the VGTS needs to be fixed, and then the hack removed) */
    dx1 = 0; dx2 = xMax-102;		/* xmin, xmax */
    dy1 = 500 /* was (yMax/2)*/; dy2 = yMax-45;	/* ymin, ymax */
    AddDirectory(sdf,dx1,dx2,dy1,dy2,noInvert,0,0);

    AddItem(sdf,NOITEM,0,xMax-100,dy1,dy1,0,
		SDF_HORIZONTAL_LINE,0);		/* line under files */

/* add in a box for which a pad may be placed */
    AddItem(sdf, NOITEM, 182, 840, 20, 490,/* values determined empirically */
		AllEdges, SDF_OUTLINE, 0);

    if (EndSymbol(sdf,mainSymbol,0) == 0)
	{printf("Couldn't end the initial symbol.\n\r\r"); Quit();}

    vgt = CreateVGT(sdf,GRAPHICS,mainSymbol,"V-System Iconiface");

    /* following creates a view w/o asking user where to place it. */
    /* call: (vgt, 			- vgt we are talking about
     *        xmin, ymin, xmax, ymax,	- bounding box on screen, in Device
     *					  coordinates (see GetSize())
     *        wxmin, wymin,		- what lower left corner is in world
     *					  coordinates (what user thinks in)
     *        zoom,			- zoom factor, power of two
     *        showGrid) 		- boolean, have grid on vgt?
     */
    CreateView(vgt,0,0,xMax,yMax,0,0,0,0); /* screen  950x800 */

/* Now give us a pad for programs to read from and write to */
/*  WritePad = OpenPad("V-Iconiface",28,80,&error);*/
/*
 * Let's try this with the new (January 1986) OpenAndPositionPad routine.
 * OAPP insists that 0,0 is the upper left hand part of the screen while
 * AddItem insists that 0,0 is the lower left.  So, we need to do a
 * transformation on the y values to get it right.  Also, the x,y value
 * given for OAPP appears to be the upper left corner of the pad.  Hrrumph.
 * The values used are the same as the AddItem above for SDF_OUTLINE for
 * the pad outline (so we still know it's there even if we cannot keep the
 * relative depth on the screen).
 */
    WritePad = OpenAndPositionPad("V-Iconiface",182,yMax-490,28,80,&error);
    if (WritePad == NULL)
      {
	fprintf(stderr, "Couldn't open pad for output (%s)\n\r",
						ErrorString(error));
	Quit();
      }
    ReadPad = OpenFile(FileServer(WritePad),FileId(WritePad), FREAD, &error);
    if (ReadPad == NULL)
      {
	fprintf(stderr, "Couldn't open pad for input (%s)\n\r",
						ErrorString(error));
	Quit();
      }
    fprintf(WritePad, "Welcome to the V-System Iconic User Interface!\n");
    fprintf(WritePad, ": ");		/* give reassuring prompt */
    Flush(WritePad);

/*
 * Main Loop
 */
    
    notdone = 1;
    while(notdone)
      {
	/* set the pad to do the translation we want */
	/* (this will also reset the count for paged ouput to start now) */
	ModifyPad(WritePad,CR_Input+LF_Output+LineBuffer+PageOutput+
				PageOutputEnable);

	if (StatsFlag)
	  fprintf(StatsFile,"%ld About to GetMouseClick\n",GetTime(0));
	invgt = GetMouseClick(&x,&y,&b);
	if (StatsFlag)
	  fprintf(StatsFile,"%ld ==> After GetMouseClick\n",GetTime(0));
	if (DebugFlag)
	  {
            printf("Mouse Click at (%d,%d); buttons: %d\n\r\r",x,y,b);
            printf("...in VGT %d\n\r\r",invgt);
	  }
	/* emergency bailout - press all three buttons */
        if (b == LeftButton+MiddleButton+RightButton) notdone = 0;   

	/* find item number of object that has been hit by the mouse */
	foundlist = (LISTTYPE *) FindSelectedObject(sdf,x,y,vgt,All);
        if (foundlist->NumOfElements !=0) /* then hit detected */ 
 	  {
	    sel = foundlist->Header->item; /* selected item number */
	    if ((sel >= MENU_LOWLIMIT) && (sel <= MENU_HIGHLIMIT))
	      /* hit on menu bar */
	      {
		ScreenRefresh = REFRESH_ON; 	/* assume we must */
		MenuHit(sel,currentFile,currentType);
		if (ScreenRefresh)	/* something may have changed */
		  RefreshDirectory(sdf,mainSymbol,vgt,
			dx1,dx2,dy1,dy2,noInvert);
		if (currentIcon)	/* need to forget about it */
		  {
		    if (!ScreenRefresh) /* refresh => clear */
		      ClearIcon(sdf,mainSymbol,vgt,currentIcon); 
		    currentIcon = 0;
		    currentFile = "";
		  }
	      }
	    else if ((sel >= ICON_LOWLIMIT) && (sel <= ICON_HIGHLIMIT))
	      {
		ScreenRefresh = REFRESH_ON;	/* asume we must */
		IconHit(sel,currentFile,currentType,sdf,mainSymbol,vgt);
		if (ScreenRefresh)	/* something may have changed */
		  RefreshDirectory(sdf,mainSymbol,vgt,
			dx1,dx2,dy1,dy2,noInvert);
		if (currentIcon)	/* need to forget about it */
		  {
		    if (!ScreenRefresh) /* clear if didn't refresh */
		      ClearIcon(sdf,mainSymbol,vgt,currentIcon);
		    currentIcon = 0;
		    currentFile = "";
		  }
	      }
	    else if (sel == BLANK_FILE_ICON)	/* possible future use */
	      /* do something */ ;
	    else if ((sel == FILE_SCROLLUP) || (sel == FILE_SCROLLDOWN))
	      /* scroll files on screen */
	      {
		ScrollHit(sdf, mainSymbol, vgt, dx1, dx2,
			dy1, dy2, noInvert, sel);
		if (currentIcon)	/* forget current icon */
		  {
		    currentIcon = 0;
		    currentFile = "";
		  }
	      }
	    else if ((sel >= FILE_LOWLIMIT) && (sel <= FILE_HIGHLIMIT))
	      /* file stuff */
	      {
		FileHit(sdf,mainSymbol,vgt,sel,
			&currentIcon,&currentFile,&currentType);
		printf("File selected: %s\n\r",currentFile);
	      }
	    /* otherwise do nothing... */
	    /* perhaps refresh directory here? */
	  } /* of hit detected */
      }  /* of while(1) */
    /* only fall through while if three button emergency stop pressed */
    Quit();
  }

/*
 ***************************************************************************
 *                              m a i n  				   *
 *-------------------------------------------------------------------------*
 *    the routine that initially executes.  It takes care of any flags     *
 *    on the command line, and then sets realmain() up with a large        *
 *    stack space, and runs it. 					   *
 ***************************************************************************
 */
main(argc, argv)
    int argc;
    char **argv;
  {
	/*
	 * (first process any command args... (flags + ?) )
	 * Allocate a larger stack, and start up the real main process 
	 */
    ProcessId pid;
    Message msg;
    char *myName;

    /*
     * Process command arguments.
     */

    myName = argv[0];		/* remember our name */
    argc--;			/* skip over program name */
    argv++;

    while (argc > 0 && **argv == '-')
      {
	while (*(++*argv)) /* until end of options on this - */
	  {
	    switch (**argv)
	      {
	      case 'd':
		DebugFlag++;	/* turn on debugging */
		break;

	      case 's':
		StatsFlag++;	/* enable statistics */
		break;

	      default:
		fprintf(stderr, "%s: Unknown switch %s\n",myName,argv[0]);
		exit(1);
		break;
	      }
	  }
	argc--;		/* skip over - */
	argv++;
      } /* outer while */

    /* 
     * Start off the main program
     */

    pid = Create(5, realmain, 0x4000);	/* create the sucker */
    Ready(pid,0);			/* start it off */

    ReceiveSpecific(msg, pid);		/* wait forever for completion */
    Quit();				/* quit nicely if we ever get here */
  }
