/****************************************/
/* Bob Neilon				*/		/* do_undefine.c */
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: undefine                    *************************************/
/* Routines to implement the dialog box for the 'undefine' V-System command.*/
/* The main procedure uses a pad as a menu to prompt the user for options.  */
/* It then prepares the command for execution.				    */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	*OpenPad();

/* Procedures to handle command options */
extern int	Execute(), Quit();
int		UndefineOk(), UndCancel();
int		ReadDName();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads		    */
extern int	ScreenRefresh;		/* Screen update flag		    */
static File	*editPad, *inputPad;	/* Pads implementing the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code 		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	NameName[FILE_NAME_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2];

/* Table for options on the editing menu */
Field	UndefineMenu[] =
   {{  1,  1, -1, NULL,          NULL,       "Command:  undefine"  },
    {  1, 20, -1, NULL, NULL, "( Remove definition of local context name )"},
    {  2,  1, -1, NULL,          NULL,       "------------------"  },
    {  3,  1, -1, NULL,          NULL,       "Argument:"           },
    {  4,  2, 14, VAL OnOff1,    ReadDName,    " [%s] Name:    "   },
    {  4, 16, -1, VAL NameName,  NULL,         " %s "              },
    {  7,  1, 12, VAL MarkNo,    UndCancel,    " [%s] Cancel "     },
    {  7, 18, 12, VAL MarkGo,	 UndefineOk,   " [%s] OK     "     },
    LASTFIELD };

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
UndefineOk(f)
   Field *f;
   {
      char *args[3];

      done = 1;

      /* Set up the argument array */
      args[0] = "undefine";
      args[1] = NameName;
      args[2] = '\0';
      if (( OnOff1[0] != 'X' ) || ( NameName[0] == '\0' ))
	  {
	  strcpy( NameName, "*** Error: No name specified ***" );
          done = 0;
	  }

      /* If no error, close the pad and execute the command */
      if ( done == 1 )
	{
	  cmdstatus = OKDOK;
	  MarkGo[0] = 'X';
	  DisplayFields( UndefineMenu, 999, editPad );
	  SelectPad( ReadPad );
	  Close( editPad );
          Execute( args );
	}
   }


/* Procedure to cancel the command on option 'Cancel' */
UndCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
   }


/* Procedure to prompt the user for the name to undefine.  */
ReadDName(f)
   Field *f;   
   {
      OnOff1[0] = 'X';
      DisplayFields( UndefineMenu, 999, editPad );
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &UndefineMenu[5], 0, editPad, inputPad );
      GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_Undefine                                           */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_Undefine()
{
    /* Initialization */
    done = 0;
    ScreenRefresh = REFRESH_OFF;
    MarkGo[0] = ' ';
    MarkNo[0] = ' ';
    OnOff1[0] = ' ';	/* OFF: Read name         */
    strcpy( NameName, BLANKFILE );

    /* Create the edit menu pad */
    editPad = OpenPad( "undefine Command Menu", XPADSIZE, YPADSIZE, &error );
    if ( editPad == NULL )
	{
	fprintf( stderr, "Error in opening the edit menu. System code = %d\n",
                                                                       error );
	Quit();
	}

    /* Select the edit menu pad, open it for input,  */
    /* and display the field information.            */
    SelectPad( editPad );
    inputPad = OpenFile( FileServer(editPad), FileId(editPad), FREAD, &error );
    if (inputPad == NULL)
       {
       fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                 error );
       Quit();
       }
    putc( 'L' & 31, editPad );    /* clear the pad */


    /* Select operations until "OK" or "CANCEL" is selected */
    while ( done != 1 )
	{

   	/* Display the current field information */
        DisplayFields( UndefineMenu, 999, editPad );
	Flush( editPad );

	/* Select an operation to perform */
	field = GetField( UndefineMenu, 999, 0, editPad );

	/* Call the procedure to perform the operation */
	if (field) (*(field->proc)) (field);

        }

}
