/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/***************************************************************************/
/* Miscellaneous V-System commands                                         */
/*     These routines implement various V-System commands which do not     */
/* require a dialog box for execution.  Each routine simply sets up the    */
/* command argument array, and invokes a routine to execute the command.   */
/***************************************************************************/

#include <Vgts.h>
#include <Vio.h>
#include <fields.h>

/* Iconic interface definitions */
#include "iconstants.h"
#include "dialogext.h"

/* External routines */
extern int	Execute(), Quit();

/* Variables for these routines */
extern int	ScreenRefresh;			/* Screen update flag  */
extern File	*ReadPad, *WritePad;		/* Command output pads */
static SystemCode  error;
static int	cmdstatus;
static char	*args[5];
static int	numargs;


/****************************
	*** HELP ***
 ****************************/
int Do_Help()
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_OFF;
	SelectPad( ReadPad );
	fprintf( WritePad, "Executing [ help ]\n\r" );
	Flush( WritePad );
	fprintf( WritePad, "To use the V-System Iconic user interface, just point and click.\n\r" );
	fprintf( WritePad, "You may have to click the desktop first, to get the black background\n\r" );
	fprintf( WritePad, "banner in the \"V-System Iconiface Graphics Vgt\" field.\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "The screen is divided into four major components.  There is the menu\n\r" );
	fprintf( WritePad, "bar at the top, files in the current context underneath it, function\n\r" );
	fprintf( WritePad, "icons on the right, and a pad for command output (and input where\n\r" );
	fprintf( WritePad, "necessary) at the bottom.\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "In general, choose a file that you want to do an operation on, then\n\r" );
	fprintf( WritePad, "choose a function (either a function icon on the right or the menu bar).\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "FILES\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "The files in the current context take up most of the top of the\n\r" ); 
	fprintf( WritePad, "screen. (If you see a left arrow, it is just an underscore; the\n\r" );
	fprintf( WritePad, "only font in the right size has a left arrow in this code point.)\n\r" );
	fprintf( WritePad, "There are four types of file icons: A file folder for directories,\n\r" );
	fprintf( WritePad, "a flowchart for (c) programs and include files, a stereotypical\n\r" );
	fprintf( WritePad, "computer/tape drive for executable files, and a document page\n\r" );
	fprintf( WritePad, "for everything else.\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "You can scroll up and down through the files if there are more\n\r" );
	fprintf( WritePad, "than fit on the screen by selecting the arrows that will appear\n\r" );
	fprintf( WritePad, "on the left.  It takes a while to update the directory, and\n\r" );
	fprintf( WritePad, "sometimes even to scroll, so a reassuring watch is placed at the\n\r" );
	fprintf( WritePad, "top right hand part of the output section to tell you that we are\n\r" );
	fprintf( WritePad, "waiting for data, not just dead.\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "FUNCTION ICONS\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "To use a function icon, just click it.  The icons are, in order,\n\r" );
	fprintf( WritePad, "help, listdir, edit, cc68, execute, boise, logout, trash, and punt.\n\r" );
	fprintf( WritePad, "Some commands require parameters.  They will bring up a dialog box\n\r" );
	fprintf( WritePad, "for you to enter the parameters.  Click OK and the command will execute.\n\r" );
	fprintf( WritePad, "\"Punt\" is used if you are unfortunate enough to have to leave this\n\r" );
	fprintf( WritePad, "iconic user interface.  You can execute any file that is compiled\n\r" );
	fprintf( WritePad, "and linked to run on the V-System.  If you execute a directory,\n\r" );
	fprintf( WritePad, "you \"cd\" to it.  This provides an easy method of traversing\n\r" );
	fprintf( WritePad, "the file system.\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "MENU BAR\n\r" );
	fprintf( WritePad, "\n\r" );
	fprintf( WritePad, "The menu bar is for selecting commands that are not among the function\n\r" );
	fprintf( WritePad, "icons on the right.  Selecting one of the groups will give you a pop-\n\r" );
	fprintf( WritePad, "up menu of functions within that group.  Select one of the items to\n\r" );
	fprintf( WritePad, "execute that command.  If parameters are required, a dialog box will\n\r" );
	fprintf( WritePad, "pop up and ask you to enter the parameters.  Choose OK, and the\n\r" );
	fprintf( WritePad, "command will be executed.\n\r" );
	fprintf( WritePad, "\n: End command.\n\r: " );
	Flush( WritePad );
   }


/****************************
	*** EDITOR ***
 ****************************/
int Do_Editor( FileName )
   char FileName[];
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_ON;
	args[0] = "ved";
	/* args[0] = "vemacs"; */
	numargs = 1;
	if ( FileName[0] != '\0' )  args[numargs++] = FileName;
	args[numargs] = '\0';
	Execute( args );
   }


/****************************
	*** EXECUTE ***
 ****************************/
int Do_Execute( FileName, FType )
   char FileName[];
   FileType FType;
   {
      cmdstatus = OKDOK;
      ScreenRefresh = REFRESH_ON;
      switch ( FType )
	{

	case FILETYPE_EXE:
	     {
		/* Execute the specified program */
		args[0] = FileName;
		args[1] = '\0';
		Execute( args );
		break;
	     }

	case FILETYPE_DIR:
	    {
		/* Execute a 'cd' to the specified directory */
		SelectPad( ReadPad );
		fprintf( WritePad, "Executing [ cd %s ]\n\r", FileName );
		Flush( WritePad );
		error = ChangeDirectory( FileName );
		if (error != OK)
		    fprintf(WritePad, "*** Error: Directory not found ***\n\r");
		fprintf( WritePad, "\n: End command.\n\r: " );
		Flush( WritePad );
		break;

	    }

	default:
	    {
	 	/* We only do this because file types are not definite -- */
		/* file types currently depend on naming conventions.     */
		/* Execute the specified program */
		args[0] = FileName;
		args[1] = '\0';
		Execute( args );
		break;
	    }

	}
   }


/****************************
	*** LOGOUT ***
 ****************************/
int  Do_Logout()
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_OFF;	/* added 23Aug85 - mjz */
#ifdef LOGOUT_ENABLED			/* added 23Aug85 - mjz */
	args[0] = "logout";
	args[1] = '\0';
	Execute( args );
	Quit();
#else LOGOUT_ENABLED			/* added 23Aug85 - mjz */
	SelectPad(ReadPad);		/* added 23Aug85 - mjz */
	fprintf(WritePad, "==> The logout command has been disabled <===\n\r");
	fprintf(WritePad, "(It doesn't make much sense running under a normal executive.)\n\r\n\r: ");
	Flush(WritePad);		/* added 23Aug85 - mjz */
#endif					/* added 23Aug85 - mjz */
   }


/************************
	*** RM ***
 ************************/
int  Do_Rm( FileName )
   char FileName[];
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_ON;
	args[0] = "rm";
	args[1] = FileName;
	args[2] = '\0';
	Execute( args );
   }


/**************************
	*** PUNT ***
 **************************/
int  Do_Punt()
   {
	printf( "\n\r    Goodbye!\n\r" );
	Quit();
   }


/***************************
	*** AMAZE ***
 ***************************/
int  Do_Amaze()
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_OFF;
	args[0] = "amaze";
	args[1] = '\0';
	Execute( args );
   }


/**************************
	*** BITS ***
 **************************/
int  Do_Bits()
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_ON;
	args[0] = "bits";
	args[1] = '\0';
	Execute( args );
   }


/******************************
	*** CHECKERS ***
 ******************************/
int  Do_Checkers()
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_OFF;
	args[0] = "checkers";
	args[1] = '\0';
	Execute( args );
   }


/**************************
	*** DALE ***
 **************************/
int  Do_Dale()
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_ON;
	args[0] = "dale";
	args[1] = '\0';
	Execute( args );
   }


/************************
	*** DATE ***
 ************************/
int  Do_Date()
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_OFF;
	args[0] = "date";
	args[1] = '\0';
	Execute( args );
   }


/**************************
	*** DRAW ***
 **************************/
int  Do_Draw()
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_ON;
	args[0] = "draw";
	args[1] = '\0';
	Execute( args );
   }



/************************
	*** TYPE ***
 ************************/
int  Do_Type( FileName )
   char FileName[];
   {
	cmdstatus = OKDOK;
	ScreenRefresh = REFRESH_OFF;
	args[0] = "type";
	args[1] = FileName;
	args[2] = '\0';
	Execute( args );
   }
