/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: listdir                     *************************************/
/* Routines to implement the dialog box for the 'listdir' V-System command. */
/* The main procedure uses a pad as a menu to prompt the user for options.  */
/* It then prepares the command for execution.				    */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	*OpenPad();

/* Procedures to handle command options */
extern int	Execute(), Quit();
int		ListdirOk(), LiCancel();
int		LongList(), CurrCont(), ReadCont();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads		    */
extern int	ScreenRefresh;		/* Screen update flag		    */
static File	*editPad, *inputPad;	/* Pads implementing the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	ContName[FILE_NAME_LENGTH];
static char 	MarkGo[2], MarkNo[2];
static char	OnOff1[2], OnOff2[2], OnOff3[2];

/* Table for options on the editing menu */
static Field	ListdirMenu[] =
   {{  1,  1, -1, NULL,          NULL,       "Command:  listdir"       },
    {  1, 20, -1, NULL, NULL, "( List names defined in a context )"    },
    {  2,  1, -1, NULL,          NULL,       "-----------------"       },
    {  3,  1, -1, NULL,          NULL,       "Options:"                },
    {  4,  2, 10, VAL OnOff1,    LongList,    " [%s] -l   "	       },
    {  4, 20, -1, NULL, NULL, "( Long listing )"		       },
    {  5,  2, 21, VAL OnOff2,    CurrCont,    " [%s] Current context " },
    {  6,  2, 21, VAL OnOff3,    ReadCont,    " [%s] Other       ==> " },
    {  6, 23, -1, VAL ContName,  NULL,        " %s "                   },
    {  9,  1, 12, VAL MarkNo,    LiCancel,    " [%s] Cancel "          },
    {  9, 18, 12, VAL MarkGo,	 ListdirOk,   " [%s] OK     "          },
    LASTFIELD};

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
ListdirOk(f)
   Field *f;
   {
      char *args[4];
      int  numargs;

      done = 1;
      cmdstatus = OKDOK;
      MarkGo[0] = 'X';
      DisplayFields( ListdirMenu, 999, editPad );

      /* Set up the argument array */
      args[0] = "listdir";
      numargs = 1;
      if ( OnOff1[0] == 'X' )  args[numargs++] = "-l";
      if ( OnOff3[0] == 'X' )  args[numargs++] = ContName;
      args[numargs] = '\0';

      /* Close the pad and execute the command */
      SelectPad( ReadPad );
      Close( editPad );
      Execute( args );
   }


/* Procedure to cancel the command on option 'Cancel' */
LiCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
   }


/* Procedure to set the "-l" option */
LongList(f)
   Field *f;
   {
	if ( OnOff1[0] == ' ' )   OnOff1[0] = 'X';
	else			  OnOff1[0] = ' ';
   }


/* Procedure to set the 'Current context' option */
CurrCont(f)
   Field *f;   
   {
      OnOff2[0] = 'X';
      OnOff3[0] = ' ';
      strcpy( ContName, BLANKFILE );
   }


/* Procedure to set the 'other context' option,          */
/* and to prompt the user for the name of the context.   */
ReadCont(f)
   Field *f;
   {
      OnOff2[0] = ' ';
      OnOff3[0] = 'X';
      DisplayFields( ListdirMenu, 999, editPad);
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &ListdirMenu[8], 0, editPad, inputPad );
      GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_Listdir                                          */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_Listdir( FileName )
char FileName[];
{
    /* Initialize */
    done = 0;
    ScreenRefresh = REFRESH_OFF;
    MarkGo[0] = ' ';
    MarkNo[0] = ' ';
    OnOff1[0] = ' ';		/* OFF: long listing    */
    if( FileName[0] != '\0' )
	{
	  OnOff2[0] = ' ';	/* OFF: current context */
	  OnOff3[0] = 'X';	/* ON:  other context   */
	  strcpy( ContName, FileName );
	}
    else
	{
	  OnOff2[0] = 'X';     /* ON:  current context */
	  OnOff3[0] = ' ';     /* OFF: read context    */
	  strcpy( ContName, BLANKFILE );
	}

    /* Create the edit menu pad */
    editPad = OpenPad( "listdir Command Menu", XPADSIZE, YPADSIZE, &error );
    if ( editPad == NULL )
	{
	fprintf( stderr, "Error in opening the edit menu. System code = %d\n",
                                                                    error );
	Quit();
	}

    /* Select the edit menu pad, open it for input,  */
    /* and display the field information.            */
    SelectPad( editPad );
    inputPad = OpenFile( FileServer(editPad), FileId(editPad), FREAD, &error );
    if (inputPad == NULL)
       {
       fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                 error );
       Quit();
       }
    putc( 'L' & 31, editPad );    /* clear the pad */


    /* Select operations until "OK" or "CANCEL" is selected */
    while ( done != 1 )
	{

   	/* Display the current field information */
        DisplayFields( ListdirMenu, 999, editPad );
	Flush( editPad );

	/* Select an operation to perform */
	field = GetField( ListdirMenu, 999, 0, editPad );

	/* Call the procedure to perform the operation */
	if (field) (*(field->proc)) (field);

        }

}
