/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: cd                          ************************************/
/* Routines to implement the dialog box for the 'cd' V-System command.     */
/* The main procedure uses a pad as a menu to prompt the user for options. */
/* It then executes the command.					   */
/***************************************************************************/
/* Known problems:
    (1)  if 'other directory' name is > FILE_NAME_LENGTH-2 chars,
         then 'home dir' box changes from '[ ]' to '[]'.
**************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	*OpenPad();

/* Procedures to handle the command options */
extern int	Execute(), Quit();
int		CdOk(), CdCancel();
int		HomeDir(), ReadDir();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads 		    */
extern int	ScreenRefresh;		/* Screen update flag		    */
static File	*editPad, *inputPad;	/* Pads implementing the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	ContName[FILE_NAME_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2], OnOff2[2];

/* Table for options on the editing menu */
static Field	CDMenu[] =
   {{  1,  1, -1, NULL,          NULL, "Command:  cd"		  },
    {  1, 20, -1, NULL, NULL, "( Change directory )"		  },
    {  2,  1, -1, NULL,          NULL, "------------"		  },
    {  3,  1, -1, NULL,          NULL, "Options:    " 		  },
    {  4,  2, 20, VAL OnOff1,    HomeDir, " [%s] Home directory " },
    {  5,  2, 20, VAL OnOff2,    ReadDir, " [%s] Other      ==> " },
    {  5, 22, -1, VAL ContName,  NULL,    " %s "		  },
    {  8,  1, 12, VAL MarkNo,    CdCancel," [%s] Cancel "	  },
    {  8, 18, 12, VAL MarkGo,	 CdOk,    " [%s] OK     "	  },
    LASTFIELD };

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
CdOk(f)
   Field *f;
   {
      done = 1;
      cmdstatus = OKDOK;
      MarkGo[0] = 'X';
      DisplayFields( CDMenu, 999, editPad );

      /* Close the pad and execute the command */
     	SelectPad( ReadPad );
	Close( editPad );
	if (( OnOff1[0] == 'X' ) || ( ContName[0] == '\0' ))
	   {
	    fprintf( WritePad, "Executing [ cd ]\n\r" );
	    Flush( WritePad );
	    error = ChangeDirectory( "[home]" );
	   }
	else
	   {
	    fprintf( WritePad, "Executing [ cd %s ]\n\r", ContName );
	    Flush( WritePad );
	    error = ChangeDirectory( ContName );
	   }

	/* Check for error -- directory not found */
	if ( error != OK )
	    fprintf( WritePad, "*** Error: Directory not found ***\n\r" );
	fprintf( WritePad, "\n: End command.\n\r: ");
	Flush( WritePad );
   }


/* Procedure to cancel the command on option 'Cancel' */
CdCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
	ScreenRefresh = REFRESH_OFF;
   }


/* Procedure to set the 'home directory' option */
HomeDir(f)
   Field *f;   
   {
      OnOff1[0] = 'X';
      OnOff2[0] = ' ';
      strcpy( ContName, BLANKFILE );
   }


/* Procedure to set the 'other directory' option,        */
/* and to prompt the user for the name of the directory  */
ReadDir(f)
   Field *f;
   {
      OnOff1[0] = ' ';
      OnOff2[0] = 'X';
      DisplayFields( CDMenu, 999, editPad);
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &CDMenu[6], 0, editPad, inputPad );
      GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_Cd                                               */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_Cd( FileName )
char FileName[];
{
    /* Initialization */
    done = 0;
    ScreenRefresh = REFRESH_ON;
    MarkGo[0] = ' ';
    MarkNo[0] = ' ';
    if( FileName[0] != '\0' )
	{
	  OnOff1[0] = ' ';		/* OFF: home directory  */
	  OnOff2[0] = 'X';		/* ON:  other directory */
	  strcpy( ContName, FileName );
	}
    else
	{
	  OnOff1[0] = 'X';    		/* ON:  home directory */
	  OnOff2[0] = ' '; 		/* OFF: read directory */
	  strcpy( ContName, BLANKFILE );
	}

    /* Create the edit menu pad */
    editPad = OpenPad( "cd Command Menu", XPADSIZE, YPADSIZE, &error );
    if ( editPad == NULL )
	{
	fprintf( stderr, "Error in opening the edit menu. System code = %d\n",
                                                                       error );
	Quit();
	}

    /* Select the edit menu pad, open it for input,  */
    /* and display the field information.            */
    SelectPad( editPad );
    inputPad = OpenFile( FileServer(editPad), FileId(editPad), FREAD, &error );
    if (inputPad == NULL)
       {
       fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                 error );
       Quit();
       }
    putc( 'L' & 31, editPad );    /* clear the pad */


    /* Select operations until "OK" or "CANCEL" is selected */
    while ( done != 1 )
	{

   	/* Display the current field information */
        DisplayFields( CDMenu, 999, editPad );
	Flush( editPad );

	/* Select an operation to perform */
	field = GetField( CDMenu, 999, 0, editPad );

	/* Call the procedure to perform the operation */
	if (field) (*(field->proc)) (field);

        }

}
