/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: boise                       *************************************/
/* Routines to implement the dialog box for the 'boise' V-System comand.    */
/* The main procedure uses a pad as a menu to prompt the user for options.  */
/* It then prepares the command for execution.                              */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	*OpenPad();

/* Procedures to handle command options */
extern	int	Execute(), Quit();
int     	BoiseOk(), BoCancel();
int		Rotate(), ReadLabel(), ReadBanner(), ReadHost();
int		Mode0(), Mode1(), Mode3(), Sail(), ReadPFile();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads		    */
extern int	ScreenRefresh;		/* Screen update flag		    */
static File	*editPad, *inputPad;	/* Pads implementing the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code 		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	PrintFile[FILE_NAME_LENGTH];
static char	Label[FILE_NAME_LENGTH];
static char	Banner[FILE_NAME_LENGTH];
static char 	Host[FILE_NAME_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2], OnOff2[2], OnOff3[2], OnOff4[2];
static char	OnOff5[2], OnOff6[2], OnOff7[2], OnOff8[2], OnOff9[2];;

/* Table for options on the editing menu */
static Field	BoiseMenu[] =
   {{  1,  1, -1, NULL,          NULL,   "Command:  boise" 		},
    {  1, 20, -1, NULL, NULL, "( Print a file on the Boise laser printer )" },
    {  2,  1, -1, NULL,          NULL,   "---------------" 		},
    {  3,  1, -1, NULL,          NULL,   "Options:"        		},
    {  4,  2,  8, VAL OnOff1,    Rotate,     " [%s] -r "   		},
    {  4, 12, -1, NULL, NULL, "( print rotated )"			},
    {  5,  2,  8, VAL OnOff2,    ReadLabel,  " [%s] -n   "		},
    {  5, 12, -1, VAL Label,	 NULL,       "<label>     ==> %s"	},
    {  6,  2,  8, VAL OnOff3,    ReadBanner, " [%s] -b   "		},
    {  6, 12, -1, VAL Banner,	 NULL,       "<banner>    ==> %s"	},
    {  7,  2,  8, VAL OnOff4,    ReadHost,   " [%s] -h   "		},
    {  7, 12, -1, VAL Host,	 NULL,       "<host name> ==> %s"	},
    {  8,  2, -1, NULL,		 NULL,	     " [X] -m   Print mode: "	},
    {  8, 27,  7, VAL OnOff5,    Mode0,      " [%s] 0 "			},
    {  8, 35, -1, NULL, NULL, "( Line printer )"			}, 
    {  9, 27,  7, VAL OnOff6,    Mode1,      " [%s] 1 "			},
    {  9, 35, -1, NULL, NULL, "( DVI. For printing TeX output )"	}, 
    { 10, 27,  7, VAL OnOff7,    Mode3,      " [%s] 3 "			},
    { 10, 35, -1, NULL, NULL, "( HP2680a )"				}, 
    { 11,  2,  8, VAL OnOff8,    Sail,       " [%s] -w "		},
    { 11, 20, -1, NULL, NULL, "( File in Sail ('WAITS') character set )" },
    { 13,  2, 15, VAL OnOff9,    ReadPFile,  " [%s] Filename: "		},
    { 13, 17, -1, VAL PrintFile, NULL,	     "%s"       		},
    { 15,  1, 12, VAL MarkNo,    BoCancel,   " [%s] Cancel "		},
    { 15, 18, 12, VAL MarkGo,	 BoiseOk,    " [%s] OK     "		},
    LASTFIELD };

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
BoiseOk(f)
   Field *f;
   {
      char *args[15];
      int  numargs;

      done = 1;

      /* Set up argument array */
      args[0] = "boise";
      numargs = 1;
      if ( OnOff1[0] == 'X' )   args[numargs++] = "-r";
      if (( OnOff2[0] == 'X' ) && ( Label[0] != '\0' ))
         {
	    args[numargs++] = "-n";
	    args[numargs++] = Label;
	 }
      if (( OnOff3[0] == 'X' ) && ( Banner[0] != '\0' ))
         {
	    args[numargs++] = "-b";
	    args[numargs++] = Banner;
  	 }
      if (( OnOff4[0] == 'X' ) && ( Host[0] != '\0' ))
	{
	    args[numargs++] = "-h";
     	    args[numargs++] = Host;
	}
      if ( OnOff6[0] == 'X' )
	{
	    args[numargs++] = "-m";
     	    args[numargs++] = "1";
	}
      if ( OnOff7[0] == 'X' )
	{
	    args[numargs++] = "-m";
     	    args[numargs++] = "3";
	}
      if ( OnOff8[0] == 'X' )    args[numargs++] = "-w";

      args[numargs++] = PrintFile;
      args[numargs] = '\0';

      /* Check for error -- no filename specified */
      if (( OnOff9[0] != 'X' ) || ( PrintFile[0] == '\0' ))
	{
	  done = 0;
	  OnOff9[0] = ' ';
	  strcpy( PrintFile, "***Error: No filename specified ***" );
	}

      /* If no error, close the pad and execute the command */
      if ( done == 1 )
	{
	   cmdstatus = OKDOK;
	   MarkGo[0] = 'X';
	   DisplayFields( BoiseMenu, 999, editPad );
	   SelectPad( ReadPad );
	   Close( editPad );
	   Execute( args );
	}
   }


/* Procedure to cancel the command on option 'Cancel' */
BoCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
   }


/* Procedure to set the '-r' option */
Rotate(f)
   Field *f;   
   {
      if ( OnOff1[0] == 'X' ) OnOff1[0] = ' ';
      else                    OnOff1[0] = 'X';
   }


/* Procedure to set the '-n' option, and read label name */
ReadLabel(f)
   Field *f;   
   {
      if ( OnOff2[0] == ' ')
	  {
	  OnOff2[0] = 'X';

          /* Read the name to label output */
          DisplayFields( BoiseMenu, 999, editPad);
          ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
          EditField( &BoiseMenu[7], 0, editPad, inputPad );
          GetTTY();
    	  }
      else
	{
          OnOff2[0] = ' ';
	  strcpy( Label, BLANKFILE );
	}
    }

/* Procedure to set the '-b' option, and read banner */
ReadBanner(f)
   Field *f;   
   {
      if ( OnOff3[0] == ' ')
	  {
	  OnOff3[0] = 'X';

          /* Read the banner to use in the "File:" field */
          DisplayFields( BoiseMenu, 999, editPad);
          ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
          EditField( &BoiseMenu[9], 0, editPad, inputPad );
          GetTTY();
    	  }
      else
	{
          OnOff3[0] = ' ';
	  strcpy( Banner, BLANKFILE );
	}
    }

/* Procedure to set the '-h' option, and read host name */
ReadHost(f)
   Field *f;   
   {
      if ( OnOff4[0] == ' ')
	  {
	  OnOff4[0] = 'X';

          /* Read the host name to use */
          DisplayFields( BoiseMenu, 999, editPad);
          ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
          EditField( &BoiseMenu[11], 0, editPad, inputPad );
          GetTTY();
    	  }
      else
	{
          OnOff4[0] = ' ';
	  strcpy( Host, BLANKFILE );
	}
    }

/* Procedures to set the print mode */
Mode0(f)
   Field *f;
   {
      if ( OnOff5[0] == ' ')
	{
	   OnOff5[0] = 'X';
	   OnOff6[0] = ' ';
	   OnOff7[0] = ' ';
	}
   }

Mode1(f)
   Field *f;
   {
      if ( OnOff6[0] == ' ')
	{
	   OnOff5[0] = ' ';
	   OnOff6[0] = 'X';
	   OnOff7[0] = ' ';
	}
   }

Mode3(f)
   Field *f;
   {
      if ( OnOff7[0] == ' ')
	{
	   OnOff5[0] = ' ';
	   OnOff6[0] = ' ';
	   OnOff7[0] = 'X';
	}
   }

/* Procedure to set the "-w" option */
Sail(f)
   Field *f;
   {
      if ( OnOff8[0] == ' ')  OnOff8[0] = 'X';      
      else		      OnOff8[0] = ' ';
   }


/* Procedure to prompt the user for the file to print */
ReadPFile(f)
   Field *f;
   {
	OnOff9[0] = 'X';
	DisplayFields( BoiseMenu, 999, editPad );
	ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
	EditField( &BoiseMenu[22], 0, editPad, inputPad );
	GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_Boise                                            */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_Boise( FileName )
    char FileName[];
    {
	/* Initialization */
	done = 0;
	ScreenRefresh = REFRESH_OFF;
	MarkGo[0] = ' ';
	MarkNo[0] = ' ';
	OnOff1[0] = ' ';	/* OFF: -r    option */
	OnOff2[0] = ' ';	/* OFF: -n    option */
	OnOff3[0] = ' ';	/* OFF: -b    option */
	OnOff4[0] = ' ';	/* OFF: -h    option */
	OnOff5[0] = 'X';	/* ON:  -m 0  option */
	OnOff6[0] = ' ';	/* OFF: -m 1  option */
	OnOff7[0] = ' ';	/* OFF: -m 3  option */
	OnOff8[0] = ' ';	/* OFF: -w    option */
	if ( FileName[0] != '\0' )
	    {
		OnOff9[0] = 'X';	/* ON:  Filename given */
		strcpy( PrintFile, FileName );
	    }
	else
	    {
		OnOff9[0] = ' ';	/* OFF: Read filename  */
		strcpy( PrintFile, BLANKFILE );
	    }
	strcpy( Label, BLANKFILE );
	strcpy( Banner, BLANKFILE );
	strcpy( Host, BLANKFILE );

        /* Create the edit menu pad */
        editPad = OpenPad( "boise Command Menu", XPADSIZE, YPADSIZE, &error );
        if ( editPad == NULL )
            {
            fprintf( stderr, "Error in opening edit menu. System code = %d\n",
                                                                       error );
            Quit();
            }

        /* Select the edit menu pad, open it for input,  */
        /* and display the field information.            */
        SelectPad( editPad );
        inputPad = OpenFile( FileServer(editPad),FileId(editPad),FREAD,&error);
        if ( inputPad == NULL )
           {
           fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                     error );
           Quit();
           }
        putc( 'L' & 31, editPad );    /* clear the pad */


        /* Select operations until "OK" or "CANCEL" is selected */
        while ( done != 1 )
            {

            /* Display the current field information */
            DisplayFields( BoiseMenu, 999, editPad );
	    Flush( editPad );

            /* Select an operation to perform */
            field = GetField( BoiseMenu, 999, 0, editPad );

            /* Call the procedure to perform the operation */
            if (field) (*(field->proc)) (field);

            }

    }
