/***************************************************************************
 *	CS 246 - Advanced Operating Systems				   *
 *	Robert Neilon							   *
 *	Madhavan Srinivasan						   *
 *	Matthew Zekauskas						   *
 **************************************************************************/
/*
 * AddMenu()
 * 	Throws up the menu bar on the screen within the box specified by
 *	the parameters min_x, min_y, max_x, max_y. 
 */

#include <Venviron.h>
#include <Vgts.h>
#include <Vio.h>
#include "iconstants.h"		/* Iconic interface global constants */

/* Menu bar */
static char *MenuBar[] =
		{
		"File            ",
		"Network         ",
		"Status          ",
		"System          ",
		"Utilities       ",
		"Games           ",
		"Other           "
		};

/* codes returned by items selected from menu bar */
static short MenuItems[] =
		{
		MENU_FILE,
		MENU_NETWORK,
		MENU_STATUS,
		MENU_SYSTEM,
		MENU_UTILITIES,
		MENU_GAMES,
		MENU_OTHER
		};


/* Addmenu() */
AddMenu(sdf, min_x, min_y, max_x, max_y)
short sdf, min_x, min_y, max_x, max_y;
{
	int i, x;
	int LeftOffset = 20;		/* x offset of 1st menu item */
	int NoOfItems = 7;		/* # of items in menu bar */
	int ItemWidth = 100;		/* width of each menu item */
	int TypeData = 0;		/* paramter for AddItem */

/* Add in all the menu items horizontally */

	for (i = 0, x = min_x + LeftOffset; i < NoOfItems; i++, x += ItemWidth)
	{
		if (AddItem(sdf, MenuItems[i], x, x+ItemWidth, min_y, max_y,
		    TypeData, SDF_SIMPLE_TEXT, MenuBar[i]) == 0)
		{
			fprintf(stderr,"Couldn't define the menu bar !\n\r");
			Quit();
		}
	}
}
