/*************************
@item{one-word name}
\-------------------------
@item{iconiface}
/*************************
@partof{if part of something larger, the name of that something}
\-------------------------
@partof{}
/*************************
@itemtype{command}
\-------------------------
@itemtype{command}
/*************************
@attrib{command-class=summary, external, grouped, or major

Summary commands are fully documented in the manual's command summary,
using description, invocation, arguments, and options.

External commands are documented outside the V system.  The summary-note
should indicate where to find out about them.

A major command has its own chapter in the manual;
grouped are found in some other section (e.g., login and logout under
'sessions'.
}
\-------------------------
@attrib{command-class=external}
/*************************
@keywords{for the index, comma-separated}
\-------------------------
@keywords{icon, iconic, interface, executive}
/*************************
@attrib{synopsis=one-line description}
\-------------------------
@attrib{synopsis=An iconic user interface for the V-System}
/*************************
@attrib{summary-note=e.g., same as in Unix 4.2bsd}
\-------------------------
@attrib{summary-note=Documented by help icon, and CS246 project writeup}
/*************************
@beginattrib{description}
Longer English description. (if needed)
\-------------------------
@beginattrib{description}
The @i{iconiface} is an iconic user interface for the V-System that is
implemented on top of the current executive.
/*************************
@beginattrib{longDescription}
Extra long English description. (if needed)
\-------------------------
@beginattrib{longDescription}
It is invoked as a command and takes control of the entire screen.  There
are four areas on the screen.
To use the V-System Iconic user interface, just point and click.
You may have to click the desktop first, to get the black background
banner in the "V-System Iconiface Graphics Vgt" field.

The screen is divided into four major components.  There is the menu
bar at the top, files in the current context underneath it, function
icons on the right, and a pad for command output (and input where
necessary) at the bottom.

In general, choose a file that you want to do an operation on, then
choose a function (either a function icon on the right or the menu bar).

FILES

The files in the current context take up most of the top of the 
screen. (If you see a left arrow, it is just an underscore; the
only font in the right size has a left arrow in this code point.)
There are four types of file icons: A file folder for directories,
a flowchart for (c) programs and include files, a stereotypical
computer/tape drive for executable files, and a document page
for everything else.

You can scroll up and down through the files if there are more
than fit on the screen by selecting the arrows that will appear
on the left.  It takes a while to update the directory, and
sometimes even to scroll, so a reassuring watch is placed at the
top right hand part of the output section to tell you that we are
waiting for data, not just dead.

FUNCTION ICONS

To use a function icon, just click it.  The icons are, in order,
help, listdir, edit, cc68, execute, boise, logout, trash, and punt.
@i{Logout really does work, it was intended for stand-alone use and
not for running under an executive, so it will "blow you out of the
water".}
Some commands require parameters.  They will bring up a dialog box
for you to enter the parameters.  Click OK and the command will execute.
"Punt" is used if you are unfortunate enough to have to leave this
iconic user interface.  You can execute any file that is compiled
and linked to run on the V-System.  If you execute a directory,
you "cd" to it.  This provides an easy method of traversing
the file system.

MENU BAR

The menu bar is for selecting commands that are not among the function
icons on the right.  Selecting one of the groups will give you a pop-
up menu of functions within that group.  Select one of the items to
execute that command.  If parameters are required, a dialog box will
pop up and ask you to enter the parameters.  Choose OK, and the
command will be executed.
/*************************
@beginattrib{invocation}
How to invoke the command.  Optional arguments in [], place holders in
italics. E.g.:
login [-x] @i{hostname} [@i{sessionname}]
\-------------------------
@beginattrib{invocation}
iconiface [-d] [-s]
/*************************
@beginattrib{arguments}
Describe the arguments in the invocation.
\-------------------------
@beginattrib{arguments}
/*************************
@beginattrib{options}
Describe the arguments that are options.
\-------------------------
@beginattrib{options}
/*************************
@beginattrib{defaults}
Describe default values for the arguments and options.

\-------------------------
@beginattrib{defaults}
/*************************
@beginattrib{examples}
Some examples of use.

\-------------------------
@beginattrib{examples}
/*************************
@beginattrib{commands}
Describe any commands within the command.

Any other strange attributes should also go right here.

\-------------------------
@beginattrib{commands}
/*************************
@beginattrib{files}
Files used.
\-------------------------
@beginattrib{files}
/*************************
@beginattrib{implementation}
Information on how the item is implemented.
\-------------------------
@beginattrib{implementation}
The current implementation was done as an Advanced Operating Systems
project.  It runs on top of the current (June 85) executive, using
the current VGTS, and as such has a few problems with selecting windows
for input.
/*************************
@beginattrib{terminology}
Special terms used in the item, with definitions.
\-------------------------
@beginattrib{terminology}
/*************************
@beginattrib{relateditems}
A list of related items.
\-------------------------
@beginattrib{relateditems}
/*************************
@beginattrib{bibliography}
References outside the infoBase system.

Also, if the command's documentation is still maintained separately
in /xV/doc give the file name here.

\-------------------------
@beginattrib{bibliography}
/*************************
@attrib{author=Joe Hacker}
\-------------------------
@attrib{author=Bob Nielon, Madhavan Srinivasan, Matt Zekauskas}
/*************************
@attrib{maintainer=Someone Else}
\-------------------------
@attrib{maintainer=Matt Zekauskas}
/*************************
@attrib{maintenance-address=
Electronic mail address (Watch that you double the @@)}
\-------------------------
@attrib{maintenance-address=matt@@gregorio.arpa}
/*************************
@attrib{source-location=directory relative to /xV}
\-------------------------
@attrib{source-location=~user/matt/I}
/*************************
@beginattrib{problems}
Known bugs and deficiencies.
\-------------------------
@beginattrib{problems}
In order to select an icon, the "desktop" must be selected first, 
sometimes leading to a double click.

The output pad gets buried below the desktop when the desktop is
selected for input.

Not all commands in the menu bar are implmented (and some even refer to
archaic commands), to use an unimplemented command, select the "other"
menu bar item.
