/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"

Write_block()
  {
    extern File  *Device;
    extern unsigned    Bytes_block;
    extern char  *Buffer;

    Write( Device, Buffer, Bytes_block );

    return( !Exception(Device) );
  }

Zerofile( argc, argv )
    unsigned argc; char **argv;
   /* Zero the specified blocks in the current nd. */
  {
    extern FsysConfigEntry FsysConfigTable[];
    extern unsigned	Global_fsys_index;
    extern unsigned Cfi;
    unsigned start, count, blksinfile, block, realblock, bcount,
	fsystart, fsysend;
    char c, crlf, *startptr, *countptr;

    if( Cfi == CND_UNDEFINED )
      {
	PutStr( "current nd undefined\n" );
	return;
      }
    if( argc != 3 )
      {
	Printf( "Error: too few arguments.\n" );
error:
	Printf( "z <startblock> <blocks>\n" );
	return;
      }
    start = Convert_num( argv[1], &startptr, 0 );
    count = Convert_num( argv[2], &countptr, 0 );
    if( (*startptr != '\0')  || (*countptr != '\0') )
      {
	Printf( "Error: bad number argunment %s\n",
			(*startptr != '\0') ? argv[1] : argv[2] );
	goto error;
      }
    blksinfile = Blks_in_fd( &(Cnd->fd) );
    if( blksinfile < Cnd->fd.FDeofblk )
      {
	Printf("Error: eof_blk %d < blocks in file %d\n",
	Cnd->fd.FDeofblk, blksinfile );
	PutStr(" Fix file descriptor and retry.\n" );
	return;
      }
    if( (start > blksinfile) || (start+count > blksinfile) )
      {
	Printf("Error: start block %d plus count %d beyond file size %d\n",
		start, count, blksinfile );
	return;
      }
    Printf("Confirm: zero blocks %d to %d in file FD number %d? (y/n)",
	start, start+count-1, Cnd->fd.FDnumber );
    Flush( stdout );
    c = getchar();
    crlf = getchar(); /* Get the carriage return, line feed. */
    if( c != 'y' && c != 'Y' )
      {
	Printf("Negative confirmation %c: operation aborted\n", c );
	return;
      }
    Zero( Buffer, Bytes_block );
    fsystart = FsysConfigTable[Global_fsys_index].start;
    fsysend = fsystart + FsysConfigTable[Global_fsys_index].length;

    for( block = start; block < start+count; ++block )
      {
	realblock = Convert_blk( block, &(Cnd->fd) );
	if( realblock == INVALID_BLOCK )
	  {
	    Printf("Error: invalid conversion of block %d in file\n",
			block );
	    Printf("Check current file descriptor and retry\n" );
	    return;
	  }
	if( (realblock < fsystart) || (realblock > fsysend) )
	  {
	    Printf( "Error: File block %d, disk block %d outside current",
		block, realblock );
	    Printf( " file system range: %d -> %d blocks\n", fsystart, fsysend );
	    return;
	  }
	SeekBlock( Device, realblock, FILE_BEGINNING );
	bcount = Write( Device, Buffer, Bytes_block );
	if( bcount != Bytes_block )
	  {
	    Printf("Error %s at block %d, disk block %d\nZero op aborted\n",
		ErrorString(FileException(Device)), block, realblock );
	    return;
	  }
       }
  }
