/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"


Set_current_fsys( argc, argv )
	unsigned argc; char **argv;
  {
    extern ND         *Cnd, *Follow_path();
    extern  unsigned  Cfi, Global_num_fsys;
    char              inarray[8], crlf;
    unsigned          num, i;
    ND                *nd;


    if( argc > 2 )
      {
       error:
        printf("Error: Too many args.\n");
        printf( "%s\n%s\n",
                    "use: s <number>",
                    "     s " );
        return;
      }

    if( argc == 2 )
      {
        if( !Conv_num( argv[1],&num ) )
          goto error;
      }

    else
      {
        printf("Specify file system:\n");
        for( i = 0; i < Global_num_fsys; i++ )
          printf("\t%d - %s\n", i, FsysConfigTable[i].name );

        printf(">");
        scanf("%s", inarray );
        crlf = getchar();          
        if( !Conv_num( inarray, &num ) )
          goto error;
      }

    if( num >= Global_num_fsys || num < 0 )
      {
        if( Global_num_fsys == 0 )
          printf("Error:  Must first initialize the file systems\n");
        else
          printf("Invalid arg.  File system number range:  0 - %d\n",
            Global_num_fsys - 1 );
        return;
      }
    else if( FsysConfigTable[num].name[0] == '\0' )
      {
        printf("File system %d not valid.\n", num );
        return;
      }
    else if( !Set_fsys( num ) )
      {
        printf("Set_current_fsys: error returned from Set_fsys\n");
        return;
       }

  }

