/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"

main( argc, argv ) 
  int argc;
  char **argv;

  {
    extern char Line[];

    Initialize( argc, argv );

    while(1)
      {
        putchar( ':' );
        Flush(stdout);
        if( !GetStr(Line,80) ) break;

        Execute_command( Line );
      }
  }

Initialize( argc, argv ) 
  int argc; 
  char **argv;

  {
    extern FileDesc  *Nd_file_fd;
    extern unsigned  Blocks_device, Start_root_file, Bytes_block;
    extern char      *Buffer, *Device_Buffer[];
    extern File      *Device, *disk_dev[];

    SystemCode            error;
    CreateInstanceRequest req;
    char	          device_name[80], c, crlf;

    if( argc > 2 )
      {
	printf( "Use: fscheck [device]\n" );
	exit( 1 );
      }
    if( argc == 2 ) /* File/device name is specified. */
      {
       deviceprompt:
        printf("Is  %s  a device or a file?  Type 'd' or 'f'.  ",argv[1]);
        c = getchar();
        crlf = getchar();  /* get the carriage return, line feed */
        if( c != 'd' && c != 'f' )
          {
            printf("Invalid answer.  Try again.\n");
            goto deviceprompt;
          }
        if( c == 'd' )
          {
	    Concat( device_name, "[device]", argv[1], 0 );
	    disk_dev[0] = Open( device_name, FBLOCK_MODE|FCREATE, &error );
            if( error )
              {
	        printf( "Error: %s on Open\n", ErrorString(error) );
	        exit( 1 );
              }
            else
              Device_Buffer[0] = (char *) malloc( (disk_dev[0])->blocksize );
          }
        else
          {
	    Concat( device_name, argv[1], 0, 0 );
	    disk_dev[0] = Open( device_name, FBLOCK_MODE|FMODIFY, &error );
            if( error )
              {
	        printf( "Error: %s on Open\n", ErrorString(error) );
	        exit( 1 );
              }
            else
              Device_Buffer[0] = (char *) malloc( (disk_dev[0])->blocksize );
          }
      }
    else
      {
        disk_dev[0] = Open( "[device]disk0", FBLOCK_MODE|FCREATE, &error );
        if( error )
          {
            printf( "Error: %s on Open of root device\n", ErrorString(error) );
            exit( 1 );
          }
        else
          Device_Buffer[0] = (char *) malloc( (disk_dev[0])->blocksize );

        disk_dev[1] = Open( "[device]disk1", FBLOCK_MODE|FCREATE, &error );
        if( error )
          {
            printf("Warning: %s on Open of second device\n",ErrorString(error));
          }
        else
          Device_Buffer[1] = (char *) malloc( (disk_dev[1])->blocksize );
      }

    Cnd = &Cndspace;
    Cfi = CND_UNDEFINED;
    Nd_file_fd = &Nd_file_fd_space;
    Start_root_file = 0;  /* the start of the file descriptor file  
                           *   relative to the beginning of a file system.
                           *   The manifest START_FD_FILE is the start of the
                           *   file descriptor file (of the root file sysem)
                           *   relative to the beginning of the disk 
                           *   and is used only during boot.
                           */
 
    Open_all_fsys();      /* configure FsysConfigTable[] */

    Set_fsys( ROOT_FSYS_INDEX );  /* eventually want to prompt the user to
                                   *   set the "current" file system.
                                   */
  }

