/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include <Vio.h> 
#include "../../../servers/storage/storagedefs.h" 

#ifndef FSCHECK
#define FSCHECK

typedef struct
  {
    FDLink	fdlink;
    FileDesc	fd;
  } ND;

#define BITS_PER_BYTE	       8
#define NDS_PER_BLOCK          (Bytes_block/sizeof(ND))

#define BYTES_NAME             32
#define BYTES_DEVICE_NAME      (FD_EXTENTS*2*BYTES_PER_WORD-1)

                                           /* Field indices which are */
#define NAME                   1           /* required explicitly. */
#define CONTEXT                6           /* CONTEXT is the contextid field. */
#define PERMS                  7           /* DEVICE is the "ptr0" field */
#define TIME                   8           /* while FIELD_AFTER_DEVICE */
#define DEVICE                 15          /* is the field after the */
#define FIELD_AFTER_DEVICE     33          /* "lastextent". Note that */
#define CHECKSUM               33          /* indices of 0, and greater */
#define LAST_FIELD             33          /* than LAST_FIELD are out of */
#define CND_UNDEFINED          MAXUNSIGNED /* range. */

#define DEVICE_FIELD_NAME      "fsys"    /* field name for the DEVICE field */

#define ND_ALLOCATED              0        /*   These values are returned by */
#define ND_FREE                   1        /* Get_nd to indicate the status */
#define ND_ERR                    2        /* of the nd just read. */
#define ND_EOF                    3
#define ND_OK                     4

/*
 * Global variables.
 */

File       *disk_dev[MAX_NUM_DRIVES];
char       *Device_Buffer[MAX_NUM_DRIVES];
File       *Device;           /* "current" device */
char       *Buffer;           /* pointer to buffer of "current" device */
unsigned   Blocks_device;     /* Blocks on the device */
unsigned   Start_root_file;   /* Start block number for root file */
unsigned   Bytes_block;	      /* Bytes per block */
unsigned   Global_fsys_index; /* index of the current file system in the
                               *   FsysConfigTable[].
                               */
unsigned   Global_num_fsys;   /* current total number of file systems */

FsysConfigEntry FsysConfigTable[MAX_NUM_FSYS];

ND         Cndspace;	      /* Space for current Node Descriptor */
ND         *Cnd;
unsigned   Cfi;

FileDesc   Nd_file_fd_space;  /* a fd for mapping nds to disc blocks */
FileDesc   *Nd_file_fd;

char       Line[80];	      /* Input line buffer */


#define Printf printf
#define Exit exit
#define PutChar putchar
#define PutStr( str ) fputs( str, stdout )
#define Put( c ) fputc( c, stdout )


#endif FSCHECK
