/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"


Check_allocation( argc, argv )
	unsigned argc; char **argv;
  /* Check the consistency of the allocation of blocks */
  /* in the file system */
  /* Use: a [+s] [+r] */
  /* +s: suppress messages relating to blocks marked but unallocated */
  /* +r: reconstruct the bitmap */
  {
    extern File  *Device, *Open_bitmap();
    extern unsigned   Blocks_device, Start_root_file;
    unsigned    suppress, rebuild;
    unsigned char	*bitmap;
    register File     *bitmap_file;
    register int  j;

    if( argc > 3 )
      {
error:  PutStr( "use: a [+r] [+s]\n" );
        return;
      }

    suppress = rebuild = FALSE;

    while( argc > 1 )
      {
	--argc;
	if( Equal(argv[argc], "+s") )  suppress = TRUE;
        else if( Equal(argv[argc], "+r" ) ) rebuild = TRUE;
        else goto error;
      }

    bitmap = (unsigned char *) malloc( Blocks_device/8+1 ); 
    for( j = 0; j < (Blocks_device/8+1); ++j)  /* last byte often bogus, */
      bitmap[j] = 0;                           /*   hence, the +1 */
    
    Set_bits( 0, Start_root_file, bitmap, 0 );
    Build_bitmap( bitmap );

    if( bitmap_file=Open_bitmap() )
      {
        Compare_bitmaps( bitmap, bitmap_file, suppress );

        if( rebuild ) Rebuild_bitmap( bitmap, bitmap_file );

        Close( bitmap_file );
        SeekBlock( Device, INVALID_BLOCK, FILE_BEGINNING );
      }
    free( bitmap ); 
  }
