/* startexec.c: test the exec server */

#include <Venviron.h>
#include <Vio.h>
#include <Vteams.h>
#include <Vexec.h>

extern File *OpenPad(), *OpenFile();
Message msg;

main()
  {
    int execid;
    ProcessId execserver, execpid;
    SystemCode error, paderr;
    File *pad;

    execserver = GetPid(EXEC_SERVER, LOCAL_PID);
    if (execserver == 0)
      {
	fprintf(stderr,"No exec server!\n");
	return;
      }
    pad = OpenPad("new exec", 28, 80, &paderr);
    if (pad == NULL || paderr != OK) {printf("aborted!"); return;}
    pad->type &= ~FRELEASE_ON_CLOSE;

    execid = CreateExec(execserver, pad->fileserver, pad->fileid,
		pad->fileserver, pad->fileid, 
		pad->fileserver, pad->fileid,
		PerProcess->ctx.pid, PerProcess->ctx.cid, 
		RELEASE_OUTPUT, &execpid, &error);
    if (error) {PrintError(error, "create exec ");  return;}
    else fprintf(stderr, "created exec %d, pid %x\n", execid, execpid);
    Flush(stderr);

    SelectPad(pad);
  }
