/* do: Command to start an exec redirected from a specified file.
 *
 * Kenneth Brooks, November 1983
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vexec.h>

extern File *Open();
Message msg;

main(argc, argv)
  int argc;
  char *argv[];
  {
    int execid;
    ProcessId execserver, execpid;
    SystemCode error;
    File *infile;
    short flags;

    flags = EXEC_NOPROMPT;
getargs:
    if (argc < 2) {printf("usage: do [-v] <command file>"); return;}
    if (argv [1][0] == '-')
      {
	switch (argv[1][1])
	  {
	  case 'v': flags = EXEC_ECHO;  break;
	  default:  printf("unknown flag %s\n", argv[1]); return;
	  }
	argv++;
	argc--;
	goto getargs;
      }

    execserver = GetPid(EXEC_SERVER, LOCAL_PID);
    if (execserver == 0)
      {
	fprintf(stderr,"No exec server!\n");
	return;
      }
    infile = Open(argv[1], FREAD, &error);
    if (error)
      {
	fprintf(stderr, "Can't read %s: %s\n", argv[1], ErrorString(error) );
	return;
      }

    execid = CreateExec(execserver, infile->fileserver, infile->fileid,
		stdout->fileserver, stdout->fileid, 
		stderr->fileserver, stderr->fileid,
		PerProcess->ctx.pid, PerProcess->ctx.cid, 
		flags, &execpid, &error);
    if (error) {PrintError(error, "create exec ");  return;}

    ReceiveSpecific(msg, execpid);

    Resynch(stdout);
    Seek(stdout, 0, FILE_END);
    Resynch(stderr);
    Seek(stderr, 0, FILE_END);

    Close(infile);

    if (flags == EXEC_ECHO) 
	printf("\n\n");	/* make it easier to tell when it's done */
  }
