/*
 *  Symbols.c
 *
 *  These routines communicate directly with the VGTS. They are the lowest
 *  level routines in Draw and are designed to deal with the un-nicities of the
 *  VGTS, or rather, the things that it should do but that it doesn't do and
 *  that we have to kluge around, such as deeply nested symnbol definitions
 *  not appearing in the right place when defined, not having nested open
 *  symbols, etc. etc. argh!
 *
 */

/* Includes */
#ifdef UNIX
#include "stdio.h"
#else
#include "Vio.h"
#endif
#include "Vgts.h"
#include "splines.h"
#include "draw.h"
 

/*
 *  This routine opens a symbol if not already open. This is used
 *  to avoid redundant refreshes of the screen. 
 *  OpenSymbol(0) doesn't open any symbols. It simply makes sure that any open
 *  symbols are closed.
 */
OpenSymbol(symbol)
    short symbol;
  {
    if (symbol == WhichSymbol) return;
    if (WhichSymbol != 0 ) 
	EndSymbol(sdf,WhichSymbol,VGTChange==minor ? mainVgt : 0);
    WhichSymbol = symbol;
    if (symbol != 0 ) {
	EditSymbol( sdf, WhichSymbol);
        if (Debug&DebugSymbols)
	    printf("Open Symbol: symbol = %d\n\r",WhichSymbol);
    }
    if (VGTChange==minor)
	VGTChange=nochange;
  }

/*
 * This routine closes any open symbol
 */
CloseAllSymbols()
{
    if (Debug&DebugSymbols)
	printf("CloseAllSymbols. ");
    OpenSymbol(0);
}

/*
 * This routine will mark the currently open symbol as having been closed.
 * The refresh parameter specifies, if TRUE, that closing this symbol should
 * change the screen in some way. The actual close will be deferred until
 * the next OpenSymbol(with a different symbol) or the next UpdateDisplay.
 *
 * CloseSymbol(FALSE) reaqlly doesn't do anything, but is provided if the
 * semantics ever change (as they already have) and for symetry considerations.
 */
CloseSymbol(refresh)
    BOOLEAN refresh;

  {
    if (refresh && WhichSymbol != 0 && VGTChange==nochange)
	    VGTChange=minor;
    if (Debug&DebugSymbols)
	printf("CloseSymbol: refresh = %s; VGTChange = %s\n\r",
	    refresh?"TRUE":"FALSE",
	    VGTChange==major?"major":VGTChange==minor?"minor":"nochange");
  }
	
/*
 * Somewhere, Draw has deemed it necessary to redraw the entire screen rather
 * than change individual parts. This will always happen after an undo, and
 * sometimes with some group operations because the VGTS does not handle this
 * correctly. This routine sets a flag which will cause all further updates to
 * be deferred until an UpdateDisplay call is issued
 */
MajorChange()
   {
    if (Debug&DebugSymbols)
	printf("MajorChange: WhichSymbol =%d\n\r",WhichSymbol);
	VGTChange=major;
   }

/*
 * This routine should ideally be called only once just before each input
 * event. It forces whatever pending screen updates there may be to take
 * place. This may be nothing, a minor change (single item) or a major change
 * (redraw screen).
 */
UpdateDisplay()
  {
    if (Debug&DebugSymbols)
	printf("UpdateDisplay: VGTChange = %s\n\r",
	    VGTChange==major?"major":VGTChange==minor?"minor":"nochange");
    CloseAllSymbols();
    if (VGTChange==major)
	DisplayItem(sdf,mainSymbol,mainVgt);
    VGTChange=nochange;
  }

/*
 *  This routine will add a single object to the display.
 */
DisplayObjectSymbol( ob, inum, symbol, refresh)
	OBJECT *ob;
	short inum;
	short symbol;
  {
    if (Debug&DebugSymbols)
	printf("DisplayObjectSymbol: object=%x; inum=%d; symbol=%d; refresh=%s\n\r",
	    ob,inum,symbol,refresh?"TRUE":"FALSE");
    if (symbol == ob->part->symbol) {
	OBJECT crowbar, *crow2;
	printf("DisplayObjectSymbol: Infinite recusrion. Symbol = %d\n\r",symbol);
	crow2 = (OBJECT *) 0xdead0077;
	crowbar = *crow2;
    }
    /* Add the item to the current display list. */
    OpenSymbol(symbol);
    if (inum <=0)
	inum = GetINum();
    ob->call = AddCall( sdf, inum, ob->dx, ob->dy, ob->part->symbol );
#if 0
    if (symbol != activelist->symbol)
	MajorChange(); /* Shouldn't have to do this */
#endif 0
    CloseSymbol(refresh);
  }

/*
 *  This internal routine will replace an object in the display with an updated
 *  version without raising it.
 */
ReplaceObjectSymbol( ob, refresh)
	OBJECT *ob;
	BOOLEAN refresh;
  {
    if (Debug&DebugSymbols)
	printf("ReplaceObjectSymbol: object = %x; refresh = %s\n\r",
	    ob,refresh?"TRUE":"FALSE");
    /* Add the item to the current display list. */
    OpenSymbol(ob->parent->symbol);
#if 0
    ChangeCall( sdf, ob->call, ob->dx, ob->dy, ob->part->symbol );
#else
    /* ChangeCall does not exist. This is equivalent if we assume that 
       RaiseObject has already been called */
    DeleteItem( sdf, ob->call);
    AddCall( sdf, ob->call, ob->dx, ob->dy, ob->part->symbol );
#endif
    if ((ob->part->type == GroupObj || 
	 ob->parent->symbol != activelist->symbol) && 
	refresh)
	MajorChange();	/* Shouldn't have to do this */
    CloseSymbol(refresh);
  }
/*
 *  This internal routine will replace an object in the display with an updated
 *  version and also raise it to the top.
 */
ReplaceAndRaiseObjectSymbol( ob, refresh)
	OBJECT *ob;
	BOOLEAN refresh;
  {
    /* Add the item to the current display list. */
    if (Debug&DebugSymbols)
	printf("ReplaceAndRaiseObjectSymbol: object = %x; refresh = %s\n\r",
	    ob,refresh?"TRUE":"FALSE");
    OpenSymbol(ob->parent->symbol);
    DeleteItem(sdf,ob->call);
    ob->call = AddCall( sdf, ob->call, ob->dx, ob->dy, ob->part->symbol );
    if ((ob->part->type == GroupObj || 
	 ob->parent->symbol != activelist->symbol) && 
	refresh)
	MajorChange();	/* Shouldn't have to do this */
    CloseSymbol(refresh);
  }

/*
 *  This internal routine will switch a call to a part from one symbol to 
 *  another.
 */
SwitchObjectSymbol( ob, refresh, oldsymbol, newsymbol)
	OBJECT *ob;
	BOOLEAN refresh;
	short oldsymbol,newsymbol;
  {
    /* Add the item to the current display list. */
    if (Debug&DebugSymbols)
	printf("SwitchObjectSymbol: object = %x; refresh = %s; oldsymbol = %d; newsymbol = %d\n\r",
	    ob,refresh?"TRUE":"FALSE",oldsymbol,newsymbol);
    OpenSymbol(oldsymbol);
    DeleteItem(sdf,ob->call);
    CloseSymbol(refresh);
    OpenSymbol(newsymbol);
    ob->call = AddCall( sdf, ob->call, ob->dx, ob->dy, ob->part->symbol );
    CloseSymbol(refresh);
  }
