/*
 *  save.c
 *
 *  This file contains the code the deal with saving a file to disk.
 *
 */
 
 
/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern Quit();
extern DebugObjectList();
extern GetMisc();
extern char *GetString();
extern RedrawActivelist();
extern EraseObject();
 
/* Exports */
extern WriteFile();
 
/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)
# define SILHEADER	034562	/* SIL format header (password) */


/*
 *  This internal routine is a helper process for WriteFile().  This
 *  routine will scan the activelist, and print the description of
 *  each object the first time it is encountered.
 */
 
ScanWrite( fp, id, cnt )
	FILE *fp;
	PART *id;
	short *cnt;
  {
    short i;
    OBJECT *ob;
    SPLINE *sptr;
    POINT *pptr;
    
    /* Stop when we run out of data. */
    if (id == NULL)
	return;
    
    if (id->filnum == 0)
      {	
	/* Print new items, numbering them as we go. */
	id->filnum = ++(*cnt);
	fprintf( fp, "%d\n", id->filnum );
	fprintf( fp, "%d %d %d %d %d %d %d %d\n",
		id->type, id->subtype, id->typedata,
		id->xmin, id->xmax, id->ymin, id->ymax, id->base );
	switch (id->type)
	  {
	    case TextObj:
	        /* Text.  Print the text string. */
		fprintf(fp,"%d %s\n",strlen(id->data),id->data);
		break;
	    
	    case GroupObj:
	        /* Groups.  Print the group name, and its items. */
		fprintf( fp, "<Group>\n" );
		ob = ((OBJECT_HEADER*)id->data)->first;
		while (ob)
		  {
		    fprintf( fp, "%d %d ", ob->dx, ob->dy );
		    ScanWrite( fp, ob->part, cnt );
		    ob = ob->next;
		  }
		fprintf( fp, "-1 -1 -1\n" );
		break;
	    
	    default:
	        /* Splines.  Print the spline data. */
		sptr = (SPLINE *) id->data;
		fprintf( fp, "%d %d %d %d %d %d %d %d\n",
			sptr->order, sptr->numvert, sptr->nib, sptr->border,
			sptr->closed, sptr->filled, sptr->opaque, sptr->pat );
		pptr = &(sptr->head);
		for (i = 0; i < sptr->numvert; i++)
		    fprintf( fp, "    %d %d\n", pptr[i].x, pptr[i].y );
		break;
	  }
      }
      else
	fprintf( fp, "%d\n", id->filnum ); 
  }

/*
 *  This internal routine will write the activelist into a file.
 */
 
WriteFile()
  {
    short count;		/* Reachable item count */
    char *fname;
    FILE *fp, *fopen();
    PART *id;
    OBJECT *ob;
    
    /* Discard ridiculous cases */
    if ((activelist->first == NULL) || (FirstPart == NULL))
      {
	mprintf(2,"There is no point to writing an empty file.\n\r");
	return;
      }
    
    /* Get the file */
    mprintf(1,"Output file name?  ");
    if ((fname = GetString()) == NULL)
      {
	mprintf(2,"Write File Aborted.");
	return;
      }
    if ((fp = fopen( fname, "w" )) == NULL)
      {
	mprintf(2,"Error:  Couldn't open file '%s'.", fname);
	free( fname );
	return;
      }
    mprintf(1,"Writing file '%s', please wait ...", fname );
    fputs( FILEHEADER, fp );
    
    /* We have a file to write.  Reset all of the file numbers. */
    if (Debug&DebugIO)
	printf("Resetting file numbers in itemlist.\n\r");
    id = FirstPart;
    while (id)
      {
	id->filnum = 0;
	id = id->next;
      }
    DupCheck = 1;

    /* Scan and print all of the items referenced by the activelist. */
    if (Debug&DebugIO)
	printf("Doing real work.\n\r");
    count = 0;
    for ( ob = activelist->first; ob; ob = ob->next )
      {
	fprintf( fp, "%d %d ", ob->dx, ob->dy );
	ScanWrite( fp, ob->part, &count );
      }
    fprintf( fp, "-1 -1 -1\n" );
    
    /* Close the file and finish up. */
    fclose( fp );
    free( fname );
    mprintf(2,"done.");
    modified = 0;
  }
