# define MAXCLICK	   10	/* Max. number of UnGetInput's allowed. */
# define NUMBACKUP	   10	/* Number of undo backup lists to maintain */
# define MAXLEN		  120	/* Maximum string length */
# define MAXDIST	10000	/* Max. distance from an item */
# define MAXNIB		   16	/* Number of nibs */
# define MAXPAT		   28   /* Number of patterns */
# define FILEHEADER	"(* V Draw program data file version 2.0*)\n"
# define JOURNALHEADER  "(* V Draw program journal file version 2.0*)\n"
# define OLDFILEHEADER  "(* SUN Draw program data file version 2.0*)\n"
# define JOURNALNAME    "Draw.journal"

/*text centering*/

# define PositionRight	    0	/* Position Text by lower right corner. */
# define PositionCenter	    1	/* Position Text by center of bottom edge. */
# define PositionLeft	    2	/* Position Text by lower left corner. */

/*psm file destinations*/

#define PRINTER_DEST	    0	/* For printing directly */
#define DOCUMENT_DEST	    1	/* For inclusion inside a text document */
#define SAVE_DEST	    2   /* For readiing back directly into Draw */

/* The following cannot change else draw files will be incompatible. */

enum ObjTypes
  {
    TextObj,			/* Text of an arbitrary font. */
    OpenSplineObj,		/* Open spline (curve). */
    ClosedSplineObj,		/* Closed spline. */
    OpenPolygonObj,		/* Open polygon (spline of order 2) */
    ClosedPolygonObj,		/* Closed polygon. */
    GroupObj,			/* Collection of other objects. */
    TemplateObj,		/* Standard shape. */
    SILObj,			/* Special SIL rectangle */
  };
   
enum TemplateTypes
  {
    NarArrowO,			/* Narrow Open Arrowhead. */
    NarArrowC,			/* Narrow Closed Arrowhead. */
    WideArrowO,			/* Wide Open Arrowhead. */
    WideArrowC,			/* Wide Closed Arrowhead. */
    Oval,			/* An oval. */
    Circle,			/* A circle */
    Rectangle,			/* A rectangle */
    NullTemplate,		/* Nothing. */
  };

/* These are the states of the global Journal flag */
enum JournalMode
  {
    JournalOff,			/* No journaling is taking place */
    JournalRecord,		/* Record mode. (events being writen to file)*/
    JournalPlay,		/* Playback mode. (events being read back in)*/
  };

typedef struct
  {
    char	*fontname;	/* Font name (eg, TimesRoman12B) */
    short	refnumber;	/* Vgts font identification number */
    short	loaded;		/* Font has been defined? */
    short	psmfont;	/* PSM font number (0 if none) */
    short	psmsize;	/* PSM point size */
  } FONTDATA;

/* The following control redrawing when opening and closing VGTS symbols */

enum RedrawNeeded
  {
    nochange,		/* No changes necessary */
    minor,		/* Single item changes needed */
    major,		/* Whole screen needs to be re-drawn */
  };

/*
 * All parts are kept in a central list.
 * Parts are stored in the format below.  The data
 * field points to an object lies for groups, which defines
 * the members of the group and gives their relative displacements.
 * For text data is the actual character string.
 * For splines, this is a spline descriptor.
 */
typedef struct PartBlock
  {
    char			*data;		/* Generic data pointer */
    enum ObjTypes		type;		/* Object type */
    short			subtype;	/* Template type, font num */
    short			typedata;	/* Centering style, copy # */
    short			number;		/* Vgts item number */
    short			symbol;		/* Vgts symbol number. */
    short			refs;		/* Reference count. */
    short			xmin, xmax, ymin, ymax;	/* Bounding box */
    short			base;		/* Text baseline. */
    short			filnum;		/* Misc. for file i/o */
    struct PartBlock		*prev,*next;	/* prev and next pointers */
  }  PART;

/*
 * All of the objects currently being displayed are pointed to by
 * an entry in the activelist.  Each entry has the format below.  The
 * undo logs consist of old copies of the activelist. 
 */
typedef struct ObjectBlock
  {
    PART			*part;		/* itemlist entry */
    short			dx, dy;		/* relative offset */
    short			frame;		/* frame item # */
    short			call;		/* number of symbol call */
	/* next -> item just ABOVE current item.
		   (next was raised, or entered more recently) */
	/* prev -> item just BELOW current item.
		   (prev was lowered, or entered earlier) */
    struct ObjectBlock		*prev, *next;
    struct ObjectHeader		*parent;	/* object list this is in */
  }  OBJECT;

/*
 * Each object list has a header which points to the first and last entried
 * in the doubly linked object list. Groups are object lists where the
 * data field of the parent part points to the group header.
 */
typedef struct ObjectHeader
  {
    short symbol;	/* The symbol these objects are in - replicated from
			   part descriptor if not the active list */
	/* first -> item drawn first (at the bottom of the pile) */
	/* last  -> item drawn last  (at the top of the pile) */
    struct ObjectBlock		*first, *last;
  }  OBJECT_HEADER;

/*
 * The DefPoint() routine can prompt the user for a variable number
 * of data points.  The storage for these points, along with the specific
 * prompt for each point, is kept in arrays with each entry of the type
 * described below.
 */
typedef struct
  {
    char 	*prompt;
    short	x, y;
    short	flag;
  }  POINT_DATA;

/*
 * The commands menu data structures are of the type below.
 */

typedef struct
  {
    char	*string;
    short	itemno;
    short	state;
  }  MenuData;
    

typedef int (*PFI)();   /* pointer to function returning integer */

/*
 * dispatchtype deals with how a particular command affects the current machine
 * state as specified in the CurrentCommand variable
 */
enum dispatchtype {
    none,		/* command neither sets nor breaks a state */
    brk,		/* command breaks a state but does not set its own */
    set,		/* command sets its own state */
    dbl,		/* double click command */
};

typedef struct dispatch {
    PFI routine;	/* the function pointer of the routine to call*/
    enum dispatchtype type; /* how it affects CurrentCommand */
} DISPATCH;

enum MenuOptions
  {
    CNull,		/* Bad command.  User missed everything. */
#define C_NOUNS ((int) COpenPolygon)
    COpenPolygon,	/* Selections from the Nouns menu */
    COpenCurve,         /* sync with icons.c, icons.h */
    CWideOpenArrow,
    CWideClosedArrow,
    CNarrowOpenArrow,
    CNarrowClosedArrow,
    CClosedPolygon,
    CClosedCurve,
    CClosedCircle,
    CClosedElipse,
    CClosedRectangle,
    CPressEditSymbol,
    CFilledPolygon,
    CFilledCurve,
    CFilledCircle,
    CFilledElipse,
    CFilledRectangle,
    CText,
#define C_VERBS ((int) CMove)
    CMove,		/* Selections from the Verbs Menu */
    CCopy,		/* sync with icons.c, icons.h */
    CErase,
    CAlter,
    CRotate,
    CScale,
    CStretch,
    CGroup,
    CRaise,
    CLower,
    COpaque,
#define C_COMMANDS ((int) CDone)
    CDone,		/* Selections from the Commands menu */
    CUndo,		/* sync with init.c */
    CAbort,
    CLoad,
    CSave,
    CPrint,
    CRange,
    CClear,
    CQuit,
    CFont1,
    CFont2,
    CHelp,
    CNib,		/* Any  nib selection */
    CPattern,		/* Any pattern selection */
    CDataPoint,		/* Commands entered through the mouse keys. */
    CCenter,		/* Default centering command */
    CAgain,		/* Done, followed by redu current state. */
    CToggleSelect,	/* Add/delete to selection for group inclusion. */
    CDebug,		/* Debug functions */
  };

extern DISPATCH Dispatch[];
extern int NumCommands;		/* Number of entries in the Commands menu */
extern MenuData Commands[];	/* Commands menu data. */
extern FONTDATA FontData[];     /* Font directory */

/* 
 * remove splines.h dependencies on modules that don't need them
 */
#ifdef _SPLINES_H
enum Nib DefaultNib;		/* default nib*/
enum Pattern DefaultPat;	/* default fill pattern */
SPLINE 	*CurrentSpline;		/* spline currently being built */
#endif _SPLINES_H

short 	Debug;			/* debugging flags. See draw.h */
short 	sdf;			/* sdf that all of draw is running on */
short 	mainSymbol;		/* top level symbol for the main vgt */
short 	menuSymbol;		/* top level symbol for the menu vgt */
short 	mainVgt;		/* main vgt number*/
short 	menuVgt;		/* menu vgt number*/
short 	modified;		/* dirty bit*/
short 	DefaultNibItem;		/* VGTS item number for the default nib */
short 	DefaultPatItem;		/* VGTS item number for default pattern */
short 	DefaultCentering;	/* Default font justification */
short 	DefaultFont;		/* Default font number */
enum MenuOptions CurrentCommand,PrevCommand;  /* Used in main state machine */
short 	PointState;		/* current state during a defpoint sequence */
OBJECT 	*CurrentObject;		/* the currently highlighted object */
OBJECT_HEADER *activelist;	/* The main object list */
OBJECT_HEADER *backuplists[NUMBACKUP]; /* Backup object lists for undo */
OBJECT 	*backcobject[NUMBACKUP]; /* Backup current object for undo */
BOOLEAN backfake[NUMBACKUP];    /* Backup FakeGroup flags */
short 	NumBackup, CurrentBackup; /* pointers to the UNDO stack */
PART 	*FirstPart,*LastPart;	/* The front and back ends of the part list */
short 	WhichSymbol;		/* The currently open symbol */
enum RedrawNeeded VGTChange;	/* Current VGT changed state */
short 	Patterns[MAXPAT]; 	/* Itemnums for fill patterns*/
short 	Nibs[MAXNIB];		/* 4 sizes x 4 shapes */ 
short 	FontItem;		/* sdf item for current font symbol */
short 	MesgItem;		/* sdf item for current message symbol */
short 	MesgAge; 		/* Age of message for automatic erase */
short 	MesgLines;		/* Number of message lines */
BOOLEAN	DrawSetup;		/* Initialization in progress */
short 	Monkey,MonkeySteps;	/* The monkey variables */
BOOLEAN	DoneFlag;		/* Flag to favor Done button for Monkey */
enum JournalMode Journal,OldJournal; /* Current and prev. journaling mode */
FILE    *JournalFIn,*JournalFOut;	/* Journaling I/O files */
int	JournalSteps,OldJournalSteps; /*Number of steps in journal file */
BOOLEAN SaveJournal;		/* Delete Journal on Quit if FALSE */
FILE *JournFIn,*JournFOut;	/* Journaling I/O files */
BOOLEAN PrintersSearched;	/* TRUE if printer names have been searched */
short	DupCheck;		/* Don't update parts more than once */
BOOLEAN FakeGroup;              /* Current object is group for multiple sel.*/


/* Debug flags */

#define DebugObjects 	1
#define DebugParts	2
#define DebugSymbols    4
#define DebugCheckpoint 8
#define DebugGroups     16
#define DebugFonts      32
#define DebugFind	64
#define DebugInput	128
#define DebugEvents	256
#define Debug_INum	512
#define DebugIO		1024
#define DebugPoint	2048
#define DebugMessages	4096
#define DebugSelect	8192

#define DEBUG_ITEMS	14
