#include <Venviron.h>
#include <Vio.h>
#include <Vteams.h>

typedef unsigned char Boolean;
#define FALSE 0
#define TRUE 1

#define ARB_HOST_STRING "any"

/* Main routine for "dopar" - a parallel version of "doseq". */
/* Ross Finlayson - September 1984. */

/* Usage: dopar "dir1 dir2 ..." "cmd"
 * Changes to the specified directories and executes cmd in each.
 * "dopar" attempts to schedule each command execution on a (different) remote
 * machine.
 */

/* The name of this command. */
#define CmdName "dopar"

/* A global counter indicating how many processes are currently active.
 * (we assume that increments and decrements of this counter are atomic.
 */
    int numCmds;

/* Possible delimiters of directory names in a string. */
char Delimiters[] = " \t\n\r";

main(argc, argv)
    int argc;
    char *argv[];
  {
    char dirList[500], *dirPtr, *dirEndPtr;
    char c;

    if (argc != 3)
      {
        printf("usage: %s \"dir1 dir2 ...\" \"cmd\"\n", CmdName);
	fflush(stdout);
	return 1;
      }

    strcpy(dirList, argv[1]);
    dirEndPtr = argv[1];

    /* skip over leading delimiters. */
    while ( (*dirEndPtr != NULL) && (index(Delimiters, *dirEndPtr) != 0) )
	    ++dirEndPtr;

    numCmds = 0;
    while (1)
      {
	/* find the directory name, if any. */
	dirPtr = dirEndPtr;
        while ( (*dirEndPtr != NULL) && (index(Delimiters, *dirEndPtr) == 0) )
	        ++dirEndPtr;
	if (*dirEndPtr != NULL)
	    *dirEndPtr++ = NULL;
	     
	/* (In parallel) execute the command in the specified context. */
	++numCmds;
	parExecute(dirPtr, argv[2]);

	/* skip over trailing delimiters. */
	while ( (*dirEndPtr != NULL) && (index(Delimiters, *dirEndPtr) != 0) )
		++dirEndPtr;
	if (*dirEndPtr == NULL)
	  {
	    /* Once we know that each subprocess has ended, we can exit. */
	    while (numCmds > 0)
	        Delay(1,0);
	    printf("all commands have finished executing.  Type 'y' to exit: ");
	    fflush(stdout);
	    while ( (getchar()|' ') != 'y' )
		;
	    return 0;
	  }
      }
  }


cmdMonitorProcess(newStdin, newStdout, teamServerPid, dirStr, comStr)
    File *newStdin, *newStdout;
    ProcessId teamServerPid;
    char *dirStr, *comStr;
  {
    SelectionRec hostSpec;

    stdin = newStdin; stdout = stderr = newStdout;
    DefaultSelectionRec(&hostSpec);
    hostSpec.teamServerPid = teamServerPid;

    if (do_cd(dirStr) != -1)
	if (index(comStr, '*'))
	    do_remoteshell(comStr, &hostSpec); /* kludge! */
	else
	    do_exec(comStr, &hostSpec);

    --numCmds;
    printf("Type 'y' to delete VGT: ");
    fflush(stdout);
    while ( (getchar()|' ') != 'y' )
	;
    Close(stdout); Close(stdin);
  }


#define PAD_HEIGHT 15
#define PAD_WIDTH 60 /* so two can fit side by side on the screen. */

#define PAD_DELAY 10
#define HOST_DELAY 10

#define MONITOR_PROCESS_STACKSIZE 5000
#define MONITOR_PROCESS_PRIORITY 10

parExecute(dirStr, comStr)
    char *dirStr, *comStr;
  {
    extern File *OpenPad();

    File *newStdin, *newStdout;
    SystemCode error;
    Boolean firstPadFailure;
    ProcessId newPid, teamServerPid;
    char *printDirStr, hostName[30];

    printDirStr = (*dirStr == NULL) ? "[home]" : dirStr;

    /* First, find a remote host on which to execute the command.
     * Then, create a new text VGT (which the command will use for stdio).
     * If we fail on either of these, then we keep trying until we succeed.
     */
    while (1)
      {
	printf("Enter name of host for context \"%s\": ", printDirStr);
	fflush(stdout);
	scanf("%s", hostName);
	if (Equal(hostName, ARB_HOST_STRING))
	  {
	    /* try to select any available remote host. */
	    teamServerPid = 0;
	    break;
	  }
	else if ( (hostName[0] == '0') && ((hostName[1] | ' ') == 'x') )
	    /* hexadecimal teamserver pid given. */
	    if (sscanf(hostName+2, "%x", &teamServerPid) == 1)
	        break;
	    else
		printf("Error: invalid process id: %s.\n", hostName);
	else if (Equal(hostName, "0"))
	  {
	    /* execute on the local host */
	    teamServerPid = GetPid(TEAM_SERVER, LOCAL_PID);
	    break;
	  }
	else	
	    /* host specified by name. */
	    if ((teamServerPid = MapRemoteHost(hostName)) != 0)
		break;
	    else
		printf("Error: host %s unknown or unavailable.\n", hostName);
      }

    fflush(stdout);

    firstPadFailure = TRUE;
    while (1)
      {
	newStdout = OpenPad(printDirStr, PAD_HEIGHT, PAD_WIDTH, &error);
	if (!error)
	    break;
	if (firstPadFailure)
	  {
	    printf("Failed to create a VGT for context \"%s\": %s.\n",
	    	   printDirStr, ErrorString(error));
	    printf("retrying...\n");
	    fflush(stdout);
	    firstPadFailure = FALSE;
	  }
	Delay(PAD_DELAY, 0);
      }
    newStdin = OpenFile(newStdout->fileserver, newStdout->fileid,
    			FREAD, &error);
    if (error)
	PrintError(error, "Cannot open VGT for input");

    /* Create a new process to monitor the execution of the command: */
    newPid = Create(MONITOR_PROCESS_PRIORITY, cmdMonitorProcess,
		    MONITOR_PROCESS_STACKSIZE);
    Ready(newPid, 5, newStdin, newStdout, teamServerPid, dirStr, comStr);
    return;
  }
