#include <Venviron.h>
#include <Vio.h>
#include <Vteams.h>

/* Utility routines used by both "doseq" and "dopar". */


int do_cd(dirStr)
    char *dirStr;
    /* Changes to the directory given in "dirStr", or to your home directory if
     * "dirStr" is NULL.
     */
  {
    SystemCode error;
    
    if (*dirStr == NULL)
      {
	printf("cd\n");
	error = ChangeDirectory("[home]");
      }
    else
      {
	printf("cd %s\n", dirStr);
	error = ChangeDirectory(dirStr);
      }
    fflush(stdout);

    if (error)
      {
        fprintf(stderr, "Error: %s\n",
		ErrorString(error));
	fflush(stderr);
	return(-1);
      }
    return (1);
  }


#define MAX_ARGS 100

int do_exec(comStr, hostSpec)
    char *comStr;
    SelectionRec *hostSpec;
    /* (attempts to) execute the command given by "comStr" on the specified 
     * host.
     */
  {
    char *args[MAX_ARGS], localComStr[200];
    ProcessId pid;
    SystemCode error;
    int status;
    RootMessage rtMsg;
    
    strcpy(localComStr, comStr); /* Since ParseLine() munges its argument. */
    printf("%s\n", localComStr);
    fflush(stdout);
    ParseLine(localComStr, args, MAX_ARGS);

    DefaultRootMessage(&rtMsg);
    pid = LoadProgram(args, hostSpec, &rtMsg, NULL, 0, &error);
    if (error || (pid == 0))
      {
        fprintf(stderr, "Error trying to execute %s: %s\n",
		args[0], ErrorString(error));
	fflush(stderr);
	return (-1);
      }
    Reply(&rtMsg, pid);
    if (hostSpec != NULL)
      {
	/* find the name of the host, and print it out. */
	int hostNameFound;
	static char hostName[128];
	
	hostNameFound = GetHostName(hostSpec->teamServerPid, hostName);
	printf("Executing at %s.\n\n", (hostNameFound ? hostName : "???"));
	Flush(stdout);
      }
    Wait(pid, &status);

    Resynch(stdin);
    Resynch(stdout);
    Seek(stdout, 0, FILE_END);
    Resynch(stderr);
    Seek(stderr, 0, FILE_END);

    return(status);
  }


static char *remoteArgs[] = {"fexecute",
		      "csh",
		      "-c",
		      NULL, /* the command string will go here */
		      NULL};

int do_remoteshell(comStr, hostSpec)
    char *comStr;
    SelectionRec *hostSpec;
    /* Like "do_exec", except that the command actually executed is
     * fexecute csh -c comStr.
     */
  {
    SystemCode error;
    int status;
    ProcessId pid;
    RootMessage rtMsg;

    printf("fexecute csh -c %s\n", comStr);
    fflush(stdout);
    remoteArgs[3] = comStr;


    DefaultRootMessage(&rtMsg);
    pid = LoadProgram(remoteArgs, hostSpec, NULL, NULL, 0, &error);
    if (error || (pid == 0))
      {
        fprintf(stderr, "Error trying to execute fexecute csh -c %s: %s\n",
		comStr, ErrorString(error));
	fflush(stderr);
	return (-1);
      }
    Reply(&rtMsg, pid);
    if (hostSpec != NULL)
      {
	/* find the name of the host, and print it out. */
	int hostNameFound;
	static char hostName[128];
	
	hostNameFound = GetHostName(hostSpec->teamServerPid, hostName);
	printf("Executing at %s.\n\n", (hostNameFound ? hostName : "???"));
	Flush(stdout);
      }
    Wait(pid, &status);

    Resynch(stdin);
    Resynch(stdout);
    Seek(stdout, 0, FILE_END);
    Resynch(stderr);
    Seek(stderr, 0, FILE_END);

    return(status);
  }
