/*
 * asciifile(f) - returns 1 if f appears to be a file of ASCII characters,
 *		  0 otherwise.
 * Checks - if the file looks like an object/executable (i.e. has a valid
 *	    magic number) then it's not ASCII
 *	  - it's also not ASCII if any of the first BUFSIZE bytes has the
 *	    most significant bit set.
 *
 * The object/executable files we see may be 68000 binaries (b.out format)
 * or VAX binaries (a.out, but in the V system we call it b.out too) and they
 * may appear to us to be in the correct order or byte-reversed.  Here, we
 * test for 68000 b.out in either order; the code for VAX b.out is in a
 * separate file (aoutfile.c) to avoid name clashes.  A 68000 b.out file may
 * or may not have been pushed through rev68, so we always try both orders;
 * in the VAX case, we only need to try one.
 */

#include "diff.h"
#include "../m68k/b.out.h"	/* Always get m68k, not vax, version from */
				/*   V include-directories		  */

/*
 * Macros which take exec structures as arguments and tell whether
 * the file has a reasonable magic number or offsets to text|symbols|strings.
 */

asciifile(f)
	FILE *f;
{
	char buf[BUFSIZ];
	register int cnt;
	register char *cp;

	fseek(f, (long)0, 0);
	cnt = fread(buf, 1, BUFSIZ, f);
	if (cnt >= sizeof (struct bhdr)) {
		/* Why do we bother copying it?  The only thing we win is */
		/*   that we don't have to re-reverse the header.	  */
		struct bhdr hdr;
		hdr = *(struct bhdr *)buf;
		if (!N_BADMAG(hdr))
#ifdef DEBUG
		    {
			puts("--- 68000 magic # (didn't byte-reverse) ---");
#endif
			return (0);
#ifdef DEBUG
		    }
#endif
		ByteSwapLongInPlace((char *)&hdr, sizeof hdr);
			/* Really only have to swap fmagic (first longword) */
		if (!N_BADMAG(hdr))
#ifdef DEBUG
		    {
			puts("--- 68000 magic # (did byte-reversal) ---");
#endif
			return (0);
#ifdef DEBUG
		    }
#endif
	}
	if (aoutfile(buf, cnt))
		return 0;
	cp = buf;
	while (--cnt >= 0)
		if (*cp++ & 0200)
			return (0);
	return (1);
}
