/*
 * photo.c - display raster files on the VGTS
 * Bill Nowicki April 1983
 */

# include <Vgts.h>
# include "bitmaps.h"

# include <stdio.h>

# define DefaultPlace "/usr/sun/src/graphics/pix"
# define Magic1 157
# define Magic2 3		/* first two bytes of a .sun file */

short sdf, vgt;

Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
     DeleteVGT(vgt,1);
     printf("Deleted vgt\r\n");
     DeleteSDF(sdf);
     printf("Deleted sdf\r\n");
     ResetTTY();
     exit();
  }

main(argc, argv)
 char **argv;
 {
    int height, width;    
    int i,got,start,end;
    short item;
    FILE *f;
    char name[256];
    char vgtName[256];
    MemRaster r;
    
     if ( argc > 1 ) f=fopen( argv[1], "r" );
     else 
      {
        printf("usage: photo file\r\n");
	exit();
      }
     strcpy(name,argv[1]);
     if (f==NULL)
         {
	   sprintf(name,"%s/%s.sun",DefaultPlace,argv[1]);
	   f = fopen(name,"r");
	   if (f==NULL)
	     {
               printf( "Cannot open %s\r\n", argv[1] );
	       exit(1);
	     }
         }
     if (getc(f) != Magic1 || getc(f) != Magic2 )
  	     {
               printf( "%s is not a raster file\r\n", name );
	       exit(1);
	     }
   
     getc(f);
     getc(f);
     height = getc (f);
     height = (height << 8) + getc (f);
     width = getc (f);
     width = (width << 8) + getc (f);

# ifdef VAX  
     printf("Remote VGTS raster test\n");
# else VAX
     printf("VGTS raster test\n");
# endif VAX
     GetTTY();
     strcpy(vgtName,"Photo ");
     strcpy(vgtName,argv[1]);
     sdf = CreateSDF();
     DefineSymbol( sdf, 1, name );
     vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, vgtName );
     DefaultView(vgt, width+32, height+32, -16, -16, 0, 0, NULL, NULL);
     r.height = height;
     r.stride = r.height;
     r.bitOffset = 0;
     r.where = HeadRaster+LinkedRaster+MemoryRaster;
     r.next = &r;
     r.width = width;
     i = r.height * ((r.width + 15) >> 4) << 1;
     printf("height:%d, width:%d, bytes:%d.\r\n",
     	r.height,r.width,i); fflush(stdout);
     r.start = (u_short*)(malloc(i));
     if (r.start==NULL)
       {
         printf("Not enough memory!\r\n");
	 Quit();
       }
     if ( (got=fread(r.start, 1, i, f)) != i)
       {
         printf("Error on file read: got=%d, expected=%d\r\n", got, i);
	 Quit();
       }
     time(&start);
     EditSymbol(sdf,1);
     AddItem( sdf, 0, 0, width-1, 0, height-1, InverseRaster, 
	    	SDF_RASTER, r.start); 
     EndSymbol( sdf, 1, vgt );
     time(&end);
     if (end==start) end = start+1;
     printf("%d bytes, %d bits in %d seconds, or %d bits/second\r\n",
     	i, i*8, end-start, 8*i/(end-start));
     printf("hit return to erase:\r\n"); fflush(stdout); getchar();
     Quit();
  }
