/*
 * datsun.c - display vector files on the VGTS
 * Bill Nowicki September 1982
 */

# include <stdio.h>
# include <Vgts.h>

# ifdef VAX
# define File FILE
# endif

short sdf, vgt;

Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
     DeleteVGT(vgt,1);
     printf("Deleted vgt\r\n");
     DeleteSDF(sdf);
     printf("Deleted sdf\r\n");
     ResetTTY();
     exit();
  }

main(argc, argv)
 char **argv;
 {

    float x,y;
    int	screenx, screeny, lastx, lasty, ipen;
    int i,vecs,start,end;
    short item = 37;
    File *f;

     if ( argc > 1 ) f=fopen( argv[1], "r" );
     else 
      {
        printf("usage: datsun file\n");
	exit();
      }
     if (f==NULL)
         {
           printf( "Cannot open %s\n", argv[1] );
	   exit(1);
         }

# ifdef VAX  
     printf("Remote VGTS vector test\n");
# else VAX
     printf("VGTS vector test\n");
# endif VAX
     GetTTY();
     sdf = CreateSDF();
     DefineSymbol( sdf, 1, "test" );
     vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, "datsun" );
     DefaultView(vgt, 500, 340, 0, 50, -2, 0, 0, 0);
     printf("sdf=%d, vgt=%d\r\n", sdf, vgt);
     lastx = lasty = 0;
     i = 0;
     vecs = 0;
     time(&start);
     while (feof(f)==0 ) 
      {
	fscanf(f,"%f%f%d", &x, &y, &ipen);
	screenx = x * 1500;
	screeny = y * 1500;
	if (ipen==1) 
	 {
	    short xmin, xmax, ymin, ymax;

	    if (lastx > 1500 || lasty   > 1500 || 
	      screenx > 1500 || screeny > 1500)
	        {
		  printf("Got weird values: lastx=%d screenx=%d y=%d y=%d\r\n",
		      lastx, screenx, lasty, screeny);
		}
	    AddItem( sdf, ++item, lastx, screenx, lasty, screeny, 0, 
	    	SDF_GENERAL_LINE, 0);
	    InquireItem(sdf, item, 
	    	&xmin, &xmax, &ymin, &ymax, NULL, NULL, NULL);
	    vecs++;
	    if (xmin!=lastx || xmax!=screenx || 
	        ymin!=lasty || ymax!=screeny)
		{
		   if (xmin==screenx && xmax==lastx && 
		       ymax==screeny && ymin==lasty)
		       	continue;

		   if (xmin==screenx && xmax==lastx && 
		       ymin==screeny && ymax==lasty)
		       	continue;

  printf("Got weird values: lastx=%d screenx=%d lasty=%d screeny=%d\r\n",
		      lastx, screenx, lasty, screeny);
	  printf(" weird values: xmin=%d xmax=%d ymin=%d ymax=%d\r\n",
		      xmin, xmax, ymin, ymax);
	  fflush(stdout);
		      getchar();
		}
	 }
	lastx = screenx;
	lasty = screeny;
       }
     EndSymbol( sdf, 1, vgt );
     time(&end);
     printf("%d vectors in %d seconds, or %d vectors/second\r\n",
     	vecs, end-start, vecs/(end-start));
     printf("hit return to erase:\r\n"); fflush(stdout); getchar();
     Quit();
  }

Random( first, last )
  {
  	/*
	 * generates a random number between "first" and "last" inclusive.
	 */
    int value = rand()/2;
    value %= (last - first + 1);
    value += first;
    return(value);
  }
