/* 
 *condense.c - condense the world map database
 *
 * Bill Nowicki April 1983
 * with some hacks from Dave Kaelbling
 */

# include <stdio.h>


# define SCALE 2763
# define DefaultLimit	3	/* clip vectors smaller than this */

int Limit;
int Eastern = 0;		/* do the eastern hemisphere */
int OnlyHalf = 0;		/* do depth clipping */

main(argc, argv)
 char **argv;
 {

    float x,y,z;
    int	screenx, screeny, lastx, lasty, ipen, lastipen = 0, needmove = 0;
    int i,vecs,start,end;
    short item;
    FILE *f, *b, *out;

     if ( argc < 3) 
      {
        printf("usage: %s file.dat file.bin [limit]\n", argv[0]);
	exit();
      }
     f=fopen( argv[1], "r" );
     if (f==NULL)
         {
           printf( "Cannot open %s for input\n", argv[1] );
	   exit(1);
         }
     
     out=fopen( argv[2], "w" );
     if (out==NULL)
         {
           printf( "Cannot open %s for output\n", argv[2] );
	   exit(1);
         }
     
     if (argc>3 && argv[3][0]=='e')
       {
         argc--;
	 argv++;
	 Eastern++;
	 OnlyHalf++;
       }

     if (argc>3 && argv[3][0]=='w')
       {
         argc--;
	 argv++;
	 OnlyHalf++;
       }

     if (argc>3 && argv[3][0]=='b')
       {
         argc--;
	 argv++;
         b = fopen( "border.dat", "r" );
         while (feof(b)==0) 
           {
	    fscanf(b, "%f%f%d", &x, &y, &ipen);
	    screenx = x * SCALE;
	    screeny = y * SCALE;
            WriteVector(out, screenx, screeny, ipen);
           }
           printf("Border done.\n\r");
      }

     if (argc>3)
       {
         Limit = atoi(argv[3]);
       }
     if (argc<4 || Limit<1)
       {
         printf("Default limit of %d used\n", DefaultLimit);
	 Limit = DefaultLimit;
       }

     printf("Map condense program\n");
     lastx = lasty = 0;
     i = 0;
     vecs = 0;
     time(&start);

     while (feof(f)==0 ) 
      {
	fscanf(f, "%f%f%f%d", &x, &y, &z, &ipen);
	if (Eastern)
	  {
	   y = -y;
	   x = -x;
	  }
	screenx = x * SCALE;
	screeny = z * SCALE;
	if ((OnlyHalf==0 || y < 0)
	          && (abs(lastx-screenx)+ 
		      abs(lasty-screeny) > Limit) )
	 {
	    if (needmove && ipen)
	        WriteVector(out, lastx, lasty, 0);
	    needmove = 0;
	   	/*
		 * the following line is to close off islands
		 * and lakes that finish with small vectors.
		 * but for some reason it does not work!
		 */
	    if (lastipen && ipen==0)
	      {
	        WriteVector(out, lastx, lasty, 1);
		vecs++;
	       }
	    WriteVector(out, screenx, screeny, ipen);
	    lastipen = ipen;
	    if (!(vecs++ % 1000))
	      {
	        printf(".");
	      }
	 }
	 else
	   {
	     if (ipen==0) needmove++;
	     lastipen = ipen && (OnlyHalf==0 || y<0);
	   }
       	lastx = screenx;
	lasty = screeny;
       }
     time(&end);
     printf("\r\n%d vectors in %d seconds, or %d vectors/second\r\n",
     	vecs, end-start, vecs/(end-start));
  }

WriteVector(out,x,y,ipen)
  FILE *out;
  {
    putc((x>>8)&0377, out);
    putc((x&0377), out);
    putc((y>>8)&0377, out);
    putc((y&0377), out);
    putc(ipen, out);
  }
