/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer, Eric Berglund,  5/83
 */


#include <b.out.h>
#include <Vio.h>
#include "Vdb.h"


/* This file, typeout.c, is part of the V debugger.  Routines for
 * displaying memory locations in different modes are included here:
 * SetTypeOutMode, GiveTypeOutMode, TypeOut, and TypeOutLegibly.
 */

extern SymRec *FindSymByValue();
extern dasm(), printnum(), PrintAddress(), GetMemWord(),
	GetMemLong(), ValidAddress();
extern char GetMemByte();


/* Ascertain the correct type-out mode for the current display.
 * If the user has specified a type-out mode (or symbol type) use
 * that, else, if the symbol type is known, use that, otherwise,
 * carry on using the current mode.
 */

SetTypeOutMode( pc )
	char *pc;
  {
    register SymRec *sp;

    sp = FindSymByValue(pc, Symfile);
    SymType = sp? sp->symbol.stype: 0;

    if( TempTypeOutMode )			/* over-riding default mode ? */
	ActualTypeOutMode = TempTypeOutMode;
    else if( TypeOutMode )			/* user-specified type ? */
	ActualTypeOutMode = TypeOutMode;			/* use that */
    else
	ActualTypeOutMode = SymType;

    ActualTypeOutMode &= TYPEFIELDMASK;
  }


/*
 * Convert single character type specification into appropriate type-out
 * mode.
 */

short GiveTypeOutMode(modeType)
	long modeType;		/* The type specification is stored in a long
				   in order to have only one type returned
				   from the input routines.  The value
				   passed is that of a byte character. */
  {
    switch ((char) modeType)
      {
	case 'c':   return( CHARTYPE );
	case 'h':   return( BYTETYPE );
	case 'w':   return( WORDTYPE );
	case 'l':   return( LONGTYPE );
	case 'i':   return( INSTTYPE );
	case 's':   return( STRTYPE );
	default:    return( 0 );
      }
  }

/*
 * DisplayMemLoc:
 * Executes the display command.
 * Returns -2 if the location specified is illegal; otherwise returns
 * the number of bytes displayed.
 */

DisplayMemLoc()
  {
    short nbytes;
    SystemCode error;

    if( !ValidAddress( Dot ) ) return(-2);

    SetTypeOutMode( Dot );
    if ( ActualTypeOutMode == STRTYPE )
      while ( GetMemByte( Dot, &error ) == '\0' )
				/* Skip over leading null's. */
	Dot++;
    nbytes = TypeOut( ActualTypeOutMode, Dot );
    putchar('\n');
    return(nbytes);
  }



/*
 * Here to TypeOut data. 
 * Returns number of data bytes displayed.
 */
int TypeOut( type, adrs )
	char *adrs;
	short type;
  {
    SystemCode error;
    int nbytes, legal;
    int c, len=0;
    char *address;

    address = adrs;

    switch (type)
      {
	case 0:			/* Default TypeOut */
	case LONGTYPE:
	    address = wordadr( address ); 	/* legal word address */
	    if( !ValidAddress( address ) || !ValidAddress( address + 3 ) )
	      return( -2 );
	    PrintAddress( address );
	    printnum( GetMemLong( address, &error ) );
	    return( 4 );			/* always TypeOut 4 bytes */

	case CHARTYPE:
	    if( !ValidAddress( address ) )
	      return( -2 );
	    PrintAddress( address );		/* type out address value */
	    putchar('\'');
	    if ( GetMemByte( address, &error ) == '\'' ) putchar('\\');
	    TypeOutLegibly( GetMemByte( address, &error ) );
	    putchar('\'');
	    return( 1 );

	case BYTETYPE:
	    if( !ValidAddress( address ) )
	      return( -2 );
	    PrintAddress( address );		/* type out address value */
	    printnum( (long) ( GetMemByte( address, &error )) );
	    return( 1 );

	case WORDTYPE:
	    address = wordadr( address );	/* valid word address */
	    if( !ValidAddress( address ) || !ValidAddress( address + 1 ) )
	      return( -2 );
	    PrintAddress(address);		/* print address in hex */
	    printnum( (long) ( GetMemWord( address, &error )) );
						/* print word contents */
	    return( 2 );			/* always TypeOut 2 bytes */

	case INSTTYPE:
	    address = wordadr( address );	/* legal word address */
	    nbytes = dasm( address, Symfile, &legal ) * 2;
	    if( nbytes != -2 )
	      printf("%s %s", HexBuffer.buf, OutputBuffer.buf);
	    return( nbytes );

	case STRTYPE:
	    if( !ValidAddress( address ) )
	      return( -2 );
	    PrintAddress( address );
	    printf("%s", " \"");
	    c = GetMemByte( address++, &error );
	    while( error == OK  &&  c != '\0'  &&  len < StringLength )
	      {
		if (c == '"') putchar('\\');
		TypeOutLegibly(c);
		len++;
		c = GetMemByte( address++, &error );
	      }
	    putchar('"');
	    return(len+1);
      }
  }


/*
 * Print out character in a readable manner.
 */
TypeOutLegibly(c)
char c;
{
	if (' ' <= c && c < 127) putchar(c);
	else switch(c) {
		case '\b': printf("%s", "\\b"); break;
		case '\t': printf("%s", "\\t"); break;
		case '\r': printf("%s", "\\r"); break;
		case '\n': printf("%s", "\\n"); break;
		case '\\': printf("%s", "\\\\"); break;
		case 127:  printf("%s", "^?"); break;
		default:   if (0 <= c && c < ' ') {
				putchar('^');
				putchar(c+64);
			   }
			   else {
				   putchar('\\'); 
				   putchar('0'+((c>>6)&3));
				   putchar('0'+((c>>3)&7));
				   putchar('0'+(c&7)); break;
			   }
		}
}
