#include <Venviron.h>
#include <Vio.h>
#include <Vioprotocol.h>
#include <Vnaming.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <Vdirectory.h>
#include <Vstorage.h>

#define MAX_FILE_NAME_LEN	512

static char *pname;

char Source[MAX_FILE_NAME_LEN], Dest[MAX_FILE_NAME_LEN] ;
int rflag, yflag, vflag ;

main(argc, argv)
    int argc;
    char **argv;
  {
    SystemCode error, copyDir() ;

    /*
     * Process command arguments.
     */
    pname = argv[0] ;
    rflag = yflag = vflag = 0 ;
    argc-- ;
    argv++ ;
    
    while( argc && (**argv == '-') )
      {
        while( *(++(*argv)) )
	  switch( **argv ) {
	    case 'r':
	        rflag = 1 ;
		break ;
	    case 'y':
	        yflag = 1 ;
		break ;
	    case 'v':
	        vflag = 1 ;
		break ;
	    default:
	        fprintf( stderr, "%s: unknown flag -%c\n", pname, **argv);
	  }
	++argv ;
	--argc ;
      }
    if (argc != 2)
      {
	printf( "usage: %s [flags] fromdir todir\n", pname );
	exit( BAD_ARGS );
      }
      
    strcpy( Source, *argv ) ;
    
    if( ! Directory( Source ) )
      {
        fprintf( stderr, "%s:%s not a directory \n", pname, Source ) ;
	exit( 1 ) ;
      }
    argv++ ;
    strcpy( Dest, *argv ) ;
	
    exit( copyDir( ) ) ;

  } /* main */



 /* 
  * CopyDir: copies the directory source to directory Dest, creating
  *          Dest if necessary. The copy is recursive if rflag
  *
  *	     CopyDir uses the global strings Source and Dest and assumes
  *	     that enough space is aveilable therein to expand filenames
  */
SystemCode 
copyDir( )
  {
    SystemCode error, younger();
    int i;
    File *sourcedir, *destdir ;
    ArbitraryDescriptor desc, desc1;
    register char *sourceSuffix = NULL;
    register char *destSuffix = NULL;

    if( vflag )
        printf( "%s: copying directory %s to %s\n",pname, Source,Dest ); 

    sourcedir = Open(Source, FREAD|FDIRECTORY|FBLOCK_MODE, &error);
    if ( sourcedir == NULL || error != OK )
      {
	printf( "%s: %s: %s\n", pname, Source, ErrorString( error ) );
	return( error );
      }
    sourcedir->block = 0 ;
      
    if( ! Directory( Dest ) )/* directory not accessable: try creating one */
      {
        error = CreateDir( Dest ) ;
	if( error )
	  { 
	    printf( "%s creating directory %s: %s\n", pname, Dest, 
	         ErrorString( error ) );
	    return( error ) ;
	  }
      }
    
    sourceSuffix = Source + strlen( Source ) ; /* \0 */
    destSuffix = Dest + strlen( Dest ) ;
    
    /* Read the sourcedir entries one by one and concatenate to DirNames.
       CopyFile or CopyDir is called dependent upon whether the descriptor
       entry specifies a plain file or a directory or both.
     */
    do 
      {
        if ( Read( sourcedir, &desc, sourcedir->blocksize )
	     == sourcedir->blocksize )
	  {
	    switch ( desc.e.descriptortype )
	      {
	        case EMPTY_DESCRIPTOR:
		    break;
		case UNIXFILE_DESCRIPTOR:
		    /* HACK: need to detect ".." and "." directories in UNIX,
		    	     since this will make the program go into an 
			     infinite loop.
		     */
		    if ( desc.u.name[ 0 ] == '.' 
		         && ( desc.u.name[ 1 ] == NULL 
			      || (desc.u.name[ 1 ] ==  '.' 
			      	  && desc.u.name[2] == NULL) ) )
			break;
		    	
		    if ( *sourceSuffix != '/' ) *sourceSuffix = '/';
		    if ( *destSuffix != '/' ) *destSuffix = '/';
		    desc.u.name[ MAX_NAME_LENGTH ] = NULL;
		    strcpy( sourceSuffix+1, desc.u.name );
		    strcpy( destSuffix+1, desc.u.name );
		    if ( (desc.u.st_mode&S_IFMT) == S_IFDIR )
		        if( rflag ) copyDir(  );
			else ;
		    else if( (desc.u.st_mode&S_IFMT) == S_IFREG )
		        if( (! yflag) || younger(Source,Dest) )
		          {
		            if( vflag )
			      printf( "Copying file %s to %s\n",
			           Source, Dest ) ;
		            CopyFile( Source, Dest ) ;
		          }
			else ;
		    else 
		        fprintf(stderr, "%s filemode of %s not supported\n",
			    pname, Source ) ;
		    break;

		case FILE_DESCRIPTOR:
		    if ( *sourceSuffix != '/' ) *sourceSuffix = '/';
		    if ( *destSuffix != '/' ) *destSuffix = '/';
		    desc.u.name[ MAX_NAME_LENGTH ] = NULL;
		    strcpy( sourceSuffix+1, desc.u.name );
		    strcpy( destSuffix+1, desc.u.name );
		    if( rflag && (desc.f.perms & SS_DIR) )
		        copyDir(  );
		    if( (! yflag) || younger(Source,Dest) )
		      {
		        if( vflag )
			  printf( "Copying file %s to %s\n",
			       Source, Dest ) ;
		        CopyFile( Source, Dest ) ;
		      }
		    break;
		    
		default:
		    fprintf( stderr,  "unsupported filetype\n" ) ;
		    return( REQUEST_NOT_SUPPORTED );
		    break;
              }
	    sourcedir->block++;	/* find next entry */
          }
  	else
	    break;	/* an error has occurred while reading from sourcedir */
      }
    while ( sourcedir->lastexception == OK && error == OK );
    
    if ( (error = sourcedir->lastexception) != END_OF_FILE )
      {
        printf( "%s: %s: Error reading directory block #%d: %s\n", pname
		, Source, sourcedir->block, ErrorString( error ) );
      }
    else
    	error = OK;

    Close( sourcedir );

    return( error );

  } /* copyDir */

SystemCode 
younger( f1, f2 )
    char *f1, *f2 ;
  {
    ArbitraryDescriptor *desc ;
    unsigned t1, t2 ;
    SystemCode error ;
    
    error = getNDescriptor( f1, &desc ) ;
    if( error )
        return( error ) ;
    switch( desc->e.descriptortype ) {
      case UNIXFILE_DESCRIPTOR:
        t1 = desc->u.st_mtime ; break ;
      case FILE_DESCRIPTOR:
        t1 = desc->f.timestamp ; break ;
      default:
        return( NOT_FOUND ) ;
    }
	
    error = getNDescriptor( f2, &desc ) ;
    if( error )
        return( error ) ;
    switch( desc->e.descriptortype ) {
      case UNIXFILE_DESCRIPTOR:
        t2 = desc->u.st_mtime ; break ;
      case FILE_DESCRIPTOR:
        t2 = desc->f.timestamp ; break ;
      default:
        return( NOT_FOUND ) ;
    }
 
    if( t1 > t2 )
        return( 1 ) ;
    return( 0 ) ;
  }
	
	
    
