#include <Venviron.h>
#include "checkers.h"

#define min(a,b) ((a>b) ? (b) : (a))
#define max(a,b) ((a>b) ? (a) : (b))

/* The purpose of the array ABARRAY is to store the alpha-beta values,
 * previously passed as an argument to Tree. 
 * 
 * One must be careful with the indices into ABARRAY. If at level LEVEL
 * VALUE should be updated it is actually ABARRAY[LEVEL]. Therefore the
 * value of AB at level LEVEL is actually ABARRAY[LEVEL-1].
 *
 * To further complicate matters (besides myself being unable to explain
 * things) the value of AB should at least partially be inherited from
 * two levels further higher. Therefore at level LEVEL AB which is
 * actually ABARRAY[LEVEL-1] is initiallized as
 *         min/max(ABARRAY[LEVEL-3]. .... ).
 *
 * Further care must be taken, in that in level LEVEL the value
 * of the variable "level" is equal to LEVEL+1, since it is incremented early.
 * However, inorder to confuse anyone who might want to tamper with
 * this software, we pretend that this didn't happen. That is we assume
 * that value==ABARRAY[LEVEL].
 *
 * For all of the above to work, ABARRAY must be an array of [-2..MAXDEPTH].
 *
 * Now for the update procedure:
 * ABARRAY can be influenced from the master at atmost two levels.
 * The values of the two levels are gsmg->value and gmsg->secondvalue.
 * The two levels are gmsg->level and (gmsg->level-1).
 * gmsg->secondvalue always updates ABARRAY[gmsg->level]
 * gmsg->value updates ABARRAY[gmsg->level-1] only if this slave is
 * currently working on gmsg->problemno.
 * Of course, the updated values are properly propagated downwards.
 */
extern int Quit ;
extern int problemno ;
extern FILE *ff ;

update()
  {
    extern ProcessId Group ;
    extern int Depth ;
    ProcessId pid ;
    extern int abarray[] ;
    Message msg ;
    struct gMsg *gmsg = (struct gMsg *) msg ;
    int i ;

    if (Group != 0 ) pid = JoinGroup (Group, GetPid(0,0))  ;
#ifdef DEBUG
    fprintf(ff, "joingroup to groupo %x returns %x\n", Group, pid) ;
#endif
    
    while (1)
      {
 top:
#ifdef DEBUG
	fflush(ff) ;
#endif
        pid = Receive (msg) ;
	/* printf("Receiver received a msg\n") ; */
	if ((pid = Receive (msg)) != 0)
	  {
	    /* We have new update info. Propagate it through the abarray
	     * First check to see if we can stop working on the
	     * current problem. If not we update secondvale and then
	     * check to see if value also gets propagated.
	     */ 
	    if (gmsg->quit)
	      {	
		if (gmsg->problemno == problemno)
		  {	  		/* stop whatever we are doing */
		  			/* this is done by setting ab */
		    Quit = 1 ;		/* window appropriately */
	            if (gmsg->level&1)	/* side = 1 */
		      {
	                for (i=gmsg->level; i<Depth; i=i+2)
		            abarray[i] = -INFINITY ;
	                for (i=gmsg->level+1; i<Depth; i=i+2)
		            abarray[i] = INFINITY ;
		      }	
	            else
		      {
	                for (i=gmsg->level; i<Depth; i=i+2)
		            abarray[i] = INFINITY ;
	                for (i=gmsg->level+1; i<Depth; i=i+2)
		            abarray[i] = -INFINITY ;
		      }
		    goto top ;
		  } 
	      }
	    if (gmsg->problemno == problemno)
	      {
	        if (gmsg->level&1)	/* side = 1 */
	            for (i=gmsg->level; i<Depth; i=i+2)
		        abarray[i] = min(abarray[i], gmsg->value) ;
	        else
	            for (i=gmsg->level; i<Depth; i=i+2)
		        abarray[i] = max(abarray[i], gmsg->value) ;
#ifdef DEBUG
		fprintf(ff,
		    "%s %d value %d secondvalue %d level %d\n", 
		    "secondlevel update pblno", gmsg->problemno, gmsg->value,
		    gmsg->secondvalue,	 gmsg->level) ;
	      }
	    else
	      {
	        fprintf(ff,"updateing pblno: %d value %d level %d\n", 
			gmsg->problemno, gmsg->secondvalue,gmsg->level) ;
#endif
	      }
	    if (gmsg->level&1)	/* side = 1 */
	            for (i=gmsg->level-1; i<Depth; i=i+2)
		        abarray[i] = max(abarray[i], gmsg->secondvalue) ;
	    else
	            for (i=gmsg->level-1; i<Depth; i=i+2)
		        abarray[i] = min(abarray[i], gmsg->secondvalue) ;
	  }
      }
  }
