#include "checkers.h"
extern struct slaves Slaves[] ;
static    struct {
	     int genno ;
	     int problemno ;
	     int level ;
	     struct movestruct *pstruct ;
          } Work[MAXSLAVES] ;
static	  int notreplyed[MAXSLAVES] ;
static int value ;
 
struct movestruct *movep, *movepp, *bestp, *movelist ;

static FILE *ff = 0 ;

/* treetop2 differs from treetop1 in that a finer grain of partitioning is
 * achieved. This is done by partitioning at the second level instead of
 * the top one. At the highest level, each posible move is generated
 * and queued in a list. Then in the second level of recursion each counter-
 * move is generated and sent to a slave to be evaluated there.
 * The movestruct data structure is used for this purpose.
 * This procedure evolved from treetop1 via tree by ugly hacking.
 * It is so ugly that it should be totally rewritten.
 */

int FinePartitioningTreetop( oldb, best, level, ab )
    int *oldb, *best; unsigned level; int ab;
  {
    extern int Po, Pod, Dir, Depth, *Reverse();
    extern unsigned *Ch_cap();
    extern ProcessId Group ;
    unsigned *capt = (unsigned *) calloc(sizeof(unsigned),48) ;
    int  x, pos, pods, dirs, side1, side2, i, *tmpb, poscapt;
    int count = 0 ;
    ProcessId pid ;
    Message msg, msg2  ;
    struct rMsg *rmsg = (struct rMsg *) msg ;
    struct gMsg *gmsg = (struct gMsg *) msg2 ;
    SystemCode error ;
    static int problemno = 0 ;
    int genno = 0 ;

#ifdef VERBOSE
    if (ff == 0) ff = stdout ;
#endif
#ifdef DEBUG
    if ((ff == 0) || (ff == stdout))
         if ((ff = fopen ("debug.d2", "w")) == 0)
	   {
	     printf("Cannot open debug\n") ;
	     exit() ;
	   }
#endif

    /* Make local duplicates of the three (3) following external (static)
    * variables; since these are local they are allocated on the stack and
    * their values will be lost upon returning from the appropriate
    * recursive call.
    */
    pos = Po;
    pods = Pod;
    dirs = Dir;
    /* If the current level is odd set side to one (1); otherwise set
    * it to negative one (-1).
    */
    side1 = (level&1) ? 1 : -1;		/* for first recursion level */
    side2 = (level&1) ? -1 : 1 ;	/* and for second */

    /* initiate gmsg for group updates of ab */
    gmsg->requestcode = GROUPUPDATE ;
    gmsg->segptr = 0 ;
    gmsg->seglength = 0 ;

    /* It is asumed that Depth is always greater than two, since
     * otherwise it would not make sense to use slaves. Should the
     * player set it to one or two: */
    if (Depth<=2) Depth=3 ;
    /* Initialize 'value' so that it can be recognized as not representing
     * any possible board. Note that if no move is possible for black then
     * this will indicate a win for white. "level" is added so that the
     * computer is more likely to make a move which leads to the quickest
     * win.
     */

    value = (-INFINITY + level++) * side1;
    Po = 7;
    Pod = Dir = 0;

    /* Check to see if a capture is posible */
    poscapt = Capture(oldb) ;
    /* As long as further moves are possible (at top level),
     * repeat the loop. (first allocate space for 1 move)
     */
    if ((movep = (struct movestruct *) allocElement(1)) == 0)
      {
        printf("Cannot allocate %d bytes of memory\n",
	   	sizeof(struct movestruct)+64*sizeof(int)) ;
	Quit() ;
      }
    tmpb = (int * ) (movep + 1) ; /* points to end of struct, where there is 
                                      space fo the representation of a board */
    movelist = 0 ;
    while (Generate (oldb, tmpb, CAPT(poscapt) ) )
      {
        Reverse(tmpb) ;
	/* initialize movestruct */
        movep->board = tmpb ;
	movep->cmoves = 0 ;
	movep->canswers = 0 ;
	movep->fptr = movelist ;
	movep->problemno = ++problemno ;
	movelist = movep ;
	
	
        if ((movep = (struct movestruct *)  allocElement(1)) == 0)          {
            printf("Cannot allocate %d bytes of memory\n",
	   	    sizeof(struct movestruct)+64*sizeof(int)) ;
	    Quit() ;
          }
        tmpb = (int * ) (movep + 1) ;
      }
    freeElement ( movep, 1) ;	/* allocated one too many */
    
    /* every posible move has been generated and is in list */
	
    /* We now step down one level of recursion and for each move in the
     * movelist we execute the tree procedure. Special care must be taken
     * when results come in, for the second half of the tree procedure
     * has not been executed for the prvious level.
     */
    level++ ;
    movep = movelist ;
    pid = Receive (msg) ;
    notreplyed[rmsg->slave]++ ;
    while (movep)
      {
        /* initialize values for every move a` la tree.c */
	Po = 7 ;
	Pod = Dir = 0 ;
	movep->value = (-INFINITY + level-1) * side2 ;
	genno = 0 ;
	poscapt = Capture(movep->board) ;
	
        while( Generate( movep->board, 0, CAPT(poscapt) ) )
          {
            /* Switch sides using 'Reverse'; then send to slave for
	     * further processsing */
restart: 
	    rmsg->level = level ;
	    rmsg->value = movep->value ;
	    rmsg->secondvalue = value ;
	    rmsg->depth = Depth ;

	    if (rmsg->problemno != movep->problemno)
	        /* moveto board only if necessary */
	        if ((error = MoveTo (Slaves[rmsg->slave].pid, rmsg->segptr, 
	              movep->board, 64*BYTES_PER_WORD)) != OK)
	          {
	              Silly_Comment(ErrorString(error)) ;
		      printf("slave %d pid %x\n", rmsg->slave, Slaves[rmsg->slave].pid ) ;
		      sleep(1) ;
       		      notreplyed[rmsg->slave]-- ;
		      DestroyProcess(pid) ;
	              Silly_Comment(" ") ;
    		      pid = Receive (msg) ;
       		      notreplyed[rmsg->slave]++ ;
		      goto restart ;
	          }
	    rmsg->requestcode = HERE_S_SOME_WORK ;
	    Work[rmsg->slave].problemno = rmsg->problemno = movep->problemno ;
	    Work[rmsg->slave].genno = rmsg->genno = genno++ ;
	    rmsg->depth = Depth ;
	    Work[rmsg->slave].pstruct = rmsg->problemstruct = movep ;
	    
#ifdef VERBOSE
	    fprintf(ff, "problem %d.%d goes to slave %d\n", movep->problemno, genno, 
	         rmsg->slave) ;
#endif
	    while (Reply (msg,Slaves[rmsg->slave].pid )!=Slaves[rmsg->slave].pid )
	      {
	        Silly_Comment("Reply returns error") ;
		sleep(1) ;
       		notreplyed[rmsg->slave]-- ;
		DestroyProcess(pid) ;
	        Silly_Comment(" ") ;
    		pid = Receive (msg) ;
       		notreplyed[rmsg->slave]++ ;
		      goto restart ;
	      }
	    Slaves[rmsg->slave].computing = 1 ;
    	    notreplyed[rmsg->slave]-- ;
	    count++ ;
	    movep->cmoves++ ;

	    pid = Receive (msg) ;
	    Slaves[rmsg->slave].computing = 0 ;
   	    notreplyed[rmsg->slave]++ ;
	    if (rmsg->requestcode == RESULT_NEEDWORK)
	      {
	        count-- ;
	        x = rmsg->value ;
#ifdef VERBOSE
		fprintf(ff, "slave %d returns %d for problem %d.%d\n",
		   rmsg->slave, x, rmsg->problemno, rmsg->genno) ;
#endif
		movepp = rmsg->problemstruct ;
		movepp->canswers++ ;
            	/* Only the move that gives the best board position ought
            	 * to be remembered. */

            	if( (x * side2) >= (movepp->value * side2) )
            	  {
            	    /* Store the value.  Note that 'Reverse' must be called
            	     * to switch the sides back.
		     */
            	    movepp->value = x;
		    if ((x*side2) >= (value*side2))
		      {
#ifdef GROUPSEND
#ifdef DEBUG
			fprintf(ff, "Sending Quit Msg pblno %d\n", 
			movepp->problemno) ;
#endif
			gmsg->quit = 1 ;
		        gmsg->level = level ;
		        gmsg->problemno = movepp->problemno ;
		        gmsg->secondvalue = value ;
		        gmsg->value = x ;
		        Send (msg2, Group) ;
			if (movep == movepp)
			    break ;
		      }
		    else
		      {
#ifdef DEBUG
			fprintf(ff, 
			"Sending Update value %d secondvalue %d pblno %d\n",
			x, value, movepp->problemno) ;
#endif
			gmsg->quit = 0 ;
		        gmsg->level = level  ;
		        gmsg->problemno = movepp->problemno ;
		        gmsg->secondvalue = value ;
		        gmsg->value = x ;
		        Send (msg2, Group) ;
#else
		          /* pruning may occur */
			if (movep == movepp)
			    break ;
#endif
		      }
		    /* There is no pruning it this (2-nd) level, so that that
		     * part of tree.c is not necessary */
		  }
		/* At this stage we must check if the best countermove
		 * had been found and if so pass it up one level of
		 * recursion. We do this here only if an answer is late.
		 * The best counter move of a move is known, only when
		 *   1) all countermoves hav been generated
		 *   2) all relevant slave replies have come in
		 */
		if (movepp != movep)
		    if (movepp->canswers == movepp->cmoves)
		      {
#ifdef VERBOSE
			    fprintf(ff, "TOPLEVEL %d reurns %d\n",
			        movepp->problemno, movepp->value) ;
#endif
		        /* finish off the second half of the tree proc. */
			if ((movepp->value * side1) > (value * side1))
			  {
			    /* We have a new better move */
			    value = movepp->value ;
			    bestp = movepp ;

		    	    /* we have a new, tighter alpha-beta interval.
		     	     * quickly broadcast it, so that any working
		     	     * slave can tighten its ab screws.
		     	     */
#ifdef GROUPSEND
		    	    gmsg->level = level  ;
			    gmsg->quit = 0 ;
			    gmsg->problemno = -1 ;
		    	    gmsg->secondvalue = value ;
		    	    Send (msg2, Group) ;
#ifdef DEBUG
			fprintf(ff, 
			"Sending Update secondvalue %d pblno %d\n",value, -1) ;
#endif
#endif
		    
		          }
		      }
              } /* if (rmsg->requestcode == RESULT_NEEDWORK) */
          } /* while */
	/* At this stage we must check again if the best countermove
	 * had been found and if so pass it up one level of
	 * recursion. We do this here only if all results have arrived
	 * for movep.
	 */
	if (movep->canswers == movep->cmoves)
	  {
	    /* finish off the second half of the tree proc. */
#ifdef VERBOSE
			    fprintf(ff, "TOPLEVEL %d reurns %d\n",
			        movep->problemno, movep->value) ;
#endif
	    if ((movep->value * side1) > (value * side1))
	      {
		/* We can improve the overall result */
		value = movep->value ;
		bestp = movep ;

		/* we have a new, tighter alpha-beta interval.
		 * quickly broadcast it, so that any working
		 * slave can tighten its ab screws.
		 */
#ifdef GROUPSEND
		gmsg->level = level  ;
		gmsg->quit = 0 ;
		gmsg->problemno = -1 ;
		gmsg->secondvalue = value ;
		Send (msg2, Group) ;
#ifdef DEBUG
		fprintf(ff, 
		"Sending Update secondvalue %d pblno %d\n", value, -1) ;
#endif
#endif    
	      }
  	   }

	movep = movep->fptr ;
      } /* while (movep) */
    /* before continueing, make sure all slaves are done, i.e. count == 0 */
    while (count)
      {
	pid = Receive (msg) ;
	Slaves[rmsg->slave].computing = 0 ;
	notreplyed[rmsg->slave]++ ;
	if (rmsg->requestcode == RESULT_NEEDWORK)
	  {
	    count-- ;
	    x = rmsg->value ;
#ifdef VERBOSE
	    fprintf(ff, "slave %d return2s %d for problem %d\n",
		   rmsg->slave, x, rmsg->problemno) ;
#endif
	    movepp = rmsg->problemstruct ;
	    movepp->canswers++ ;
            /* Only the move that gives the best board position ought
             * to be remembered. */

            if( (x * side2) >= (movepp->value * side2) )
	      {
            	movepp->value = x;
#ifdef GROUPSEND
		if ((x*side2) >= (value*side2))
		    /* pruning should take place */
		    gmsg->quit = 1 ;
		else 
		    gmsg->quit = 0 ;
		gmsg->level = level  ;
		gmsg->problemno = movepp->problemno ;
		gmsg->secondvalue = value ;
		gmsg->value = x ;
		Send (msg2, Group) ;
#ifdef DEBUG
		fprintf(ff, 
		"Sending Update value %d secondvalue %d pblno %d Quit %d\n",
		x, value,  movepp->problemno, gmsg->quit) ;
#endif
#endif
	      }
	    if (movepp->canswers == movepp->cmoves)
	      {
#ifdef VERBOSE
			    fprintf(ff, "TOPLEVEL %d reurns %d\n",
			        movepp->problemno, movepp->value) ;
#endif
		/* all replies for a move have come in, so 
		  * finish off the second half of the tree proc. */
		if ((movepp->value * side1) > (value * side1))
		  {
		    /* We have a new better move */
		    value = movepp->value ;
		    bestp = movepp ;

		    	/* we have a new, tighter alpha-beta interval.
		     	 * quickly broadcast it, so that any working
		     	 * slave can tighten its ab screws.
		     	 */
#ifdef GROUPSEND
		    gmsg->level = level ;
		    gmsg->quit = 0 ;
		    gmsg->problemno = -1 ;
		    gmsg->secondvalue = value ;
		    Send (msg2, Group) ;
#ifdef DEBUG
		    fprintf(ff, 
		    "Sending Update secondvalue %d pblno %d\n",value, -1) ;
#endif
#endif
		  }
	      }
	  } 
      } /* while */

	  
    /* Now let all slaves retransmit their msg so that the os
     * can take care of queueing */
    rmsg->requestcode = TRYAGAIN ;
    for (i=0; i<NoOfHosts; i++) 
	if (notreplyed[i])
	  {
	    notreplyed[i]-- ;
	    if (Reply (msg, Slaves[i].pid) != Slaves[i].pid)
	      {
	        Silly_Comment("Tryagain reply returns an error") ;
		/* sleep(10) ; */
	       }
	  }

    Po = pos;
    Pod = pods;
    Dir = dirs;

   /* Free the space allocated as a stack for moves, and then return  the
    * value for the board that has resulted from this call.
    */
   if (best)
	Copy (best, Reverse (bestp->board),  64*BYTES_PER_WORD) ;

    while (movep=movelist)
      {
        movelist = movep->fptr ;
	freeElement (movep, 1) ;
      }
    free( capt );
#ifdef VERBOSE
    fprintf(ff, "returning %d\n", value) ;
#endif
    return( value );
  }

recreateSubtask( slave, rmsg )
    int slave ;
    struct rMsg *rmsg ;
  {
    /* fill in */
    /* the fillin is generally of the following type 
     * first move to data, which is needed, then setup message then reply:
     *
     *
     * if ((error=MoveTo(Slaves[slave].pid, Rmsg[slave].data, M, 
     *	         count*(sizeof(float)))) != OK)
     * {
     *	printf("MoveTo slave %d failed during restart: %s\n", 
     *	    slave, ErrorString(error)) ;
     * }
     *
     * if(Reply (&Rmsg[slave], Slaves[slave].pid ) !=  Slaves[slave].pid)
     *  {
     *    printf("Reply to slave %d failed during restart\n", slave) ;
     *  }
     */

    
    SystemCode error ;
    ProcessId pid ;
    
    rmsg->level = Work[slave].level ;
    rmsg->value = Work[slave].pstruct->value ;
    rmsg->secondvalue = value ;
    rmsg->depth = Depth ;

    if ((error = MoveTo (pid, rmsg->segptr, 
	              movep->board, 64*BYTES_PER_WORD)) != OK)
          {
              Silly_Comment(ErrorString(error)) ;
	      sleep(10) ;
          }
    rmsg->requestcode = HERE_S_SOME_WORK ;
    rmsg->problemno = Work[slave].problemno ;
    rmsg->genno = Work[slave].genno ;
    rmsg->problemstruct =  Work[slave].pstruct ;
	    
#ifdef VERBOSE
    fprintf(ff, "problem %d.%d goes to slave %d\n", 
	    rmsg->problemno, rmsg->genno, slave) ;
#endif
    if (Reply (rmsg, Slaves[slave].pid)!= Slaves[slave].pid)
      {
        Silly_Comment("Reply returns error") ;
	sleep(10) ; 
      }
    Slaves[slave].computing = 1 ;
  }
