#include <Vio.h>
#include "checkers.h"

Player_move()

    /* This function handles the processing of the human's move. */

  {
   /*
    * 'Depth' is the search depth of the computer's move tree, 'Sqnam' is used
    * to translate the names of the squares, and 'Board' holds the contents
    * of the checker board. */

    extern char *Sqnam[];
    extern int Board[], PrevBoard[], Depth, Value, PrevValue;
                  
    unsigned cf;
    int s, o, d;
    static char depthString[] = "Search depth = x";


check_for_captures:
    /* 'cf' is a capture flag:  it gets reset if a possible
     * capture is found.
     */
    cf = 1;

    /* Check each square of the board for a possible red capture of a black
    * piece.
    */
    for( s=7; s<56; ++s )
        if( Ch_red( Board, s ) )
      {
        if( cf )
          {
	    begin_Forced_Capture();
            cf = 0;
          }

    /* Show the co-ordinates of the squares that contain the red pieces
    * that can take some black ones. */

        Forced_Capture(" "); Forced_Capture(Sqnam[s]);
      }
    if (cf)
	Forced_Capture(0);
    else
	end_Forced_Capture();

    while (1) /* Loop until the human has completed his 'move'. */
	  {
            /* Get the human's response (using the mouse). */
	    switch (s = GetResponse(FALSE))
	      {
		case REDRAW: /* Redraw the screen.
				(Shouldn't really be necessary). */
		    FullDisplay(Board, TRUE);
		    break;

		case PASS:
		    /* Skip your turn. (This is the only way for the human to
		       avoid his capturing obligations (if any)). */
		    Copy(PrevBoard, Board, 64*BYTES_PER_WORD);
		    PrevValue = Value;
		    Forced_Capture(0);
			/* In case we had turned on the prompt. */
		    return;

		case DEPTH: /* Change the depth of the computer's lookahead
			       (in halfmoves - the default is 3). */
		    Depth = GetDepth();		    
		    depthString[15] = '0' + Depth;
		    Silly_Comment(depthString);
		    break;

		case EDIT:
                   /* This part allows the human to change the contents
                    * of the checker board and the positions of the pieces.
		    */
                    Edit();
                    goto check_for_captures; /* I hate gotos, but... */

		case RESIGN:
                    /* This segment allows the human to 'resign' or quit. */
                    Prompt( "   I accept" );
		    Delay(1, 0);
                    Quit();
              
		case BACKUP:
		    /* The board is backed up (ie retracted) one move. */
		    Copy(Board, PrevBoard, 64*BYTES_PER_WORD);
		    Value = PrevValue;
		    FullDisplay(Board, TRUE);
                    goto check_for_captures;

                /* The command is now assumed to be a movement command, and
                 * "s" will be the position (in "Board") of the piece
                 * that the player has selected. We now make sure that it can
                 * be legally moved.
     	         */
		default:
		    /* Make sure that square 's' contains a red piece. */
		    if ( (Board[s]!=RC) && (Board[s]!=RK) )
			break;

		    /* If a capture is required, then make sure that the
		     * selected square can indeed make a capture. */
		    if (!cf && !Ch_red(Board, s))
			break;

		    /* The source piece is correct - highlight it. */
		    UpdateDisplayedSquare(s, TRUE);

		    /* The human should now select the destination square.
		     * If in fact he tries to select a menu entry instead,
		     * then assume that he has made a mistake, and undo his
		     * earlier piece selection (& don't act on the
		     * menu selection). It's also an error if the destination
		     * square is occupied.
		     */
		    if ( ((d = GetResponse(FALSE)) < 7)
		        || (Board[d] != EMPTY))
		      {
			UpdateDisplayedSquare(s, FALSE);
			break;
		      }

                    /* If 'cf' is 'true' (no capture is possible) then
		     * interpret the move as a normal move. If the capture
		     * flag is false, anticipate a 'jump' move (capture).
 		     */
		    if( cf ) /* normal move. */
		      {
	               /* Give a value to 'o,' which is the displacement
	                * between the source and target squares.
	                * Note that a negative displacement is okay for the
	                * human's kings, while a positive displacement is 
	                * required for the human's men. The move is illegal if
	                * the move is not possible ('o' is not equal to either
	                * six (6) or seven (7)).  Note also that a king can 
	                * move backward, since the displacement is always
	                * positive and that a checker can only move forward,
	                * since -6 does not equal +6.
			*/
	                if( Board[s] == RC ) o = s-d;
	                else o = abs( s-d );
	                if( !( (o == 6) || (o == 7) ) )
		          {
			    UpdateDisplayedSquare(s, FALSE);
			    break;
		          }

			/* Now that we're committed to moving, save the Board
			 * in PrevBoard, in case the human later wants to back
			 * up. */
			Copy(PrevBoard, Board, 64*BYTES_PER_WORD);
			PrevValue = Value;

	                /* Do the requested move. */
	                Board[d] = Board[s];
	                Board[s] = EMPTY;
			UpdateDisplayedSquare(s, FALSE);
			UpdateDisplayedSquare(d, FALSE);

	               /* Promote the human's checkers to kings if they reach
	                * the last row (the computer's own first row) of the
	                * checker board.
			*/
	                for( s=7; s<11; ++s )
	                    if( Board[s] == RC )
			      {
				Board[s] = RK;
				UpdateDisplayedSquare(s, FALSE);
			      }
	                return;
		      }
	            else /* a capture must be made. */
	              {
	                    /* Put the distance between source and target
	                    * square into 'o.'
			    */
	                    if( Board[s] == RC ) o = s-d;
	                    else o = abs( s-d );

	                    /* Since a king can move both forward and backward,	
	                    * the distance ('o') can be either positive or
	                    * negative.  Note that the distance is larger than
	                    * that used for simple movement, since a jump involves
	                    * an intervening square.  A checker can only move
	                    * forward, so only check for positive distances.
			    */
	                    if( !( (o == 12) || (o == 14) ) )
		              {
			        UpdateDisplayedSquare(s, FALSE);
			        break;
		              }

	                    /* Check to see whether or not there is a piece being
	                    * jumped, and if it is the computer's or not.  The
	                    * given jump will be legal only if a piece that
	                    * belongs to the computer is captured.  The square
	                    * that is occupied by the computer's piece is given
	                    * by '(s + d)/2'.
			    */
                  	    if( !((Board[ (s + d)/2]==BC) || (Board[(s+d)/2] == BK) ) )
		              {
			        UpdateDisplayedSquare(s, FALSE);
			        break;
		              }

			Copy(PrevBoard, Board, 64*BYTES_PER_WORD);
			PrevValue = Value;

	                /* The following loop can handle multiple jumps. */
			while(1)
        	          {
	                    /* Do the capture as given. */
	                    Board[d] = Board[s];
	                    Board[ (s + d)/2 ] = Board[s] = EMPTY;
			    UpdateDisplayedSquare(s, FALSE);
			    UpdateDisplayedSquare(d, FALSE);
			    UpdateDisplayedSquare((s + d)/2, FALSE);
	                    s = d;

                            /* Promote the human checkers
                            * to kings if they are on the computer's back row.
			    */
                            for( o=7; o<11; ++o )
                                if( Board[o] == RC )
			          {
				    Board[o] = RK;
				    UpdateDisplayedSquare(o, FALSE);
			          }

			    /* If no further captures are possible, return. */
			    if (!Ch_red(Board, s))
				return;

			    /* Otherwise, highlight the new source, & get the
			     * new destination from the human.
			     */
			    UpdateDisplayedSquare(s, TRUE);
			    while (1) /* loop until a correct dest is given */
				/* Note that we perform the same checks on
				 * the destination square as before, except
				 * that now we're more persistent.
				 */
			      {
			        if ( ((d = GetResponse(FALSE)) < 7)
			            || (Board[d] != EMPTY))
			           continue;
	                        if( Board[s] == RC ) o = s-d;
	                        else o = abs( s-d );
	                        if( !( (o == 12) || (o == 14) ) )
				    continue;
                  	        if( !((Board[ (s + d)/2]==BC) || (Board[(s+d)/2] == BK) ) )
				    continue;
				break;
			      } /* end if the innermost loop */
			  } /* end of the "if" */
		      } /* end of the middle loop */
	      } /* end of the switch */
	  } /* end of the outer loop */
  } /* end of Player_move() */

