#include <Venviron.h>
#include <Vteams.h>
#include <Vgroupids.h>
#include <Vdirectory.h>
#include <Vquerykernel.h>
#include "hoststatuslib.h"


/* getHostDescriptors will send the requestdescriptor to the group of
 * teamservers on the network, and will receive up to max replies.
 * Each reply message  is stored in the descriptor array. This array 
 * must be large enough for max descriptors, with each descriptor
 * having the size of a message. The number of actual replies recieved
 * is returned. NextReply will timeout after one second.
 */


getHostDescriptors (max, descriptorArrayPtr, requestDescriptorPtr)
    int max ;
    struct hostStatMsg descriptorArrayPtr[], *requestDescriptorPtr ;
  {
    int count = 0 ;
    ProcessId pidd ;

    (*requestDescriptorPtr).requestcode = HOST_STATUS ;
    pidd = Send(requestDescriptorPtr, VTEAM_SERVER_GROUP) ;
    if ((pidd != 0) && ((*requestDescriptorPtr).requestcode == OK))
      {
        /* we have to copy the contents of the reply in the requestDescriptor
         * into the first record of the descriptorarray */
        descriptorArrayPtr[0].maxIdleTime = pidd ;	/* take out later */
	descriptorArrayPtr[0].pid = pidd ;
        descriptorArrayPtr[0].avail = (*requestDescriptorPtr).avail ;
        descriptorArrayPtr[0].freeTeams = (*requestDescriptorPtr).freeTeams ;
        descriptorArrayPtr[0].freeProcs = (*requestDescriptorPtr).freeProcs ;
        descriptorArrayPtr[0].minFreeMem = 
			(*requestDescriptorPtr).minFreeMem ;
        descriptorArrayPtr[0].maxFreeMem = 0 ;
        descriptorArrayPtr[0].minIdleTime=
			(*requestDescriptorPtr).minIdleTime;
        descriptorArrayPtr[0].procMachType = 
			(*requestDescriptorPtr).procMachType  ;
        ++count ;
      }
    while ((pidd != 0) && (count < max))
      {
        pidd =  GetReply(&descriptorArrayPtr[count], 100) ;
	if ((pidd != 0) && (descriptorArrayPtr[count].requestcode == OK))
	  {
	    descriptorArrayPtr[count].maxIdleTime = pidd ; /* take out later */
	    descriptorArrayPtr[count].pid = pidd ;
	    count++ ;
	  }
      }
    return (count) ;
  }


/* getReadyHostDescriptors sends a HOST_STATUS request to the group of
 * teamservers on the network, and will receive up to max replies.
 * Only available hosts with at least 1 free team, 3 free processes,
 * 100000 bytes of memory and having a processor of type procFamily
 * will be sollicited.
 * Each reply message  is stored in the descriptor array. This array 
 * must be large enough for max descriptors, with each descriptor
 * having the size of a message. The number of actual replies recieved
 * is returned. NextReply will timeout after one second.
 */


getReadyHostDescriptors (max, procFamily, descriptorArrayPtr )
    int max, procFamily ;
    struct hostStatMsg descriptorArrayPtr[] ;
  {
    int count = 0 ;
    struct hostStatMsg descriptor  ;

    descriptor.requestcode = HOST_STATUS ;
    descriptor.avail = AVAIL_RELEVANT | AVAILABLE ;
    descriptor.freeTeams = 1 ;
    descriptor.freeProcs = 3 ;
    descriptor.minFreeMem = 0 ;
    descriptor.maxFreeMem = 0 ;
    descriptor.minIdleTime = 0 ;
    descriptor.maxIdleTime = 0 ;
    descriptor.procMachType =  ((MACH_TYPE_IRRELEVANT << MACH_TYPE_SHIFT)
			| (PROC_TYPE_IRRELEVANT << PROC_TYPE_SHIFT)
			| (procFamily)) ;

    return (getHostDescriptors( max, descriptorArrayPtr, &descriptor )) ;
  }


/* get ReadyHosts tries to locate at most max remote hosts with processors
 * of the family procFamily to start remote teams on.
 * The function returns the number of hosts it could locate, with
 * the pids of the teamservers on those hosts in teamPIDs[].
 * That array had better be large enough to accomodate max Pids.
 * The Pids are sorted according to the formula described below.
 */

getReadyHosts ( max, arrayOfPIDs, procFamily)
    int max ;
    ProcessId arrayOfPIDs[] ;
    int procFamily  ;
  {
  
    int  count = 0 ;
    struct hostStatMsg *hostDescriptorArray, descriptor,tmpDescriptor ;
    int high, tmphigh, highindex, i, j, total ;


    if ((hostDescriptorArray = (struct hostStatMsg *) 
    		malloc (max * sizeof(struct hostStatMsg))) == 0)
      {
        fprintf (stderr, "getHosts could not allocate enough memory\n") ;
	return (0) ;
      }

    descriptor.requestcode = HOST_STATUS ;
    descriptor.avail = AVAIL_RELEVANT | AVAILABLE ;
    descriptor.freeTeams = 2 ;
    descriptor.freeProcs = 3 ;
    descriptor.minFreeMem = 100000 ;
    descriptor.maxFreeMem = 0 ;
    descriptor.minIdleTime = 60 ;
    descriptor.maxIdleTime = 0 ;
    descriptor.procMachType =  ((MACH_TYPE_IRRELEVANT << MACH_TYPE_SHIFT)
			| (PROC_TYPE_IRRELEVANT << PROC_TYPE_SHIFT)
			| (procFamily)) ;


    if ((hostDescriptorArray = (struct hostStatMsg *) 
    		malloc (MAXHOSTS * sizeof(struct hostStatMsg))) == 0)
      {
        fprintf (stderr, "getHosts could not allocate enough memory\n") ;
	return (0) ;
      }
    total = getHostDescriptors (MAXHOSTS, hostDescriptorArray, &descriptor ) ;
  
    /* now the hostDescriptors should be sorted
     * This will be done according to the following formula
     *         freeTeams * 10 + minIdleTime
     */

    for (i=0; i<total-1; i++)
      {
        high = 0 ;
        for (j=i; j<total; j++)
	    if ((tmphigh = hostDescriptorArray[j].freeTeams * 10 +
	         hostDescriptorArray[j].minIdleTime) > high)
	      {
	        high = tmphigh ;
		highindex = j ;
	      }
	tmpDescriptor = hostDescriptorArray[i] ;
	hostDescriptorArray[i] = hostDescriptorArray[highindex] ;
        hostDescriptorArray[highindex] = tmpDescriptor ;
      }
      
 /*     for (i=0; i<total; i++)
  *      {
  *	    printf("Host nr %d:    %d\n", 
  *	    	i, hostDescriptorArray[i].maxIdleTime) ;
  *	    printf("    avail: %d\n", hostDescriptorArray[i].avail) ;
  * 	    printf("    freeTeams %d\n", hostDescriptorArray[i].freeTeams ) ;
  *	    printf("    freeProcs %d\n",hostDescriptorArray[i].freeProcs ) ;
  *	    printf("    freeMem %d\n", hostDescriptorArray[i].minFreeMem ) ;
  *	    printf("    Idletime %d\n", hostDescriptorArray[i].minIdleTime ) ;
  *    	    printf("\n") ;
  *        }
  */
    max = (max>total)? total : max ;
    for (i=0; i<max; i++)
        arrayOfPIDs[i] = hostDescriptorArray[i].maxIdleTime ;
    free (hostDescriptorArray) ;
    return (max) ;
	    
  }


/* getHostPIDs tries to locate at most max remote hosts with processors
 * of the family procFamily to start remote teams on.
 * The function returns the number of hosts it could locate, with
 * the pids of the teamservers on those hosts in teamPIDs[].
 * That array had better be large enough to accomodate max Pids.
 * The Pids are sorted according to the formula described below.
 */

getHostPIDs ( max, arrayOfPIDs, procFamily)
    int max ;
    ProcessId arrayOfPIDs[] ;
    int procFamily  ;
  {
  
    int  count = 0 ;
    struct hostStatMsg *hostDescriptorArray, descriptor,tmpDescriptor ;
    int high, tmphigh, highindex, i, j, total ;


    if ((hostDescriptorArray = (struct hostStatMsg *) 
    		malloc (max * sizeof(struct hostStatMsg))) == 0)
      {
        fprintf (stderr, "getHosts could not allocate enough memory\n") ;
	return (0) ;
      }

    descriptor.requestcode = HOST_STATUS ;
    descriptor.avail = 0 ;
    descriptor.freeTeams = 2 ;
    descriptor.freeProcs = 3 ;
    descriptor.minFreeMem = 100000 ;
    descriptor.maxFreeMem = 0 ;
    descriptor.minIdleTime = 60 ;
    descriptor.maxIdleTime = 0 ;
    descriptor.procMachType =  ((MACH_TYPE_IRRELEVANT << MACH_TYPE_SHIFT)
			| (PROC_TYPE_IRRELEVANT << PROC_TYPE_SHIFT)
			| (procFamily)) ;


    if ((hostDescriptorArray = (struct hostStatMsg *) 
    		malloc (MAXHOSTS * sizeof(struct hostStatMsg))) == 0)
      {
        fprintf (stderr, "getHosts could not allocate enough memory\n") ;
	return (0) ;
      }
    total = getHostDescriptors (MAXHOSTS, hostDescriptorArray, &descriptor ) ;
  
    /* now the hostDescriptors should be sorted
     * This will be done according to the following formula
     *         freeTeams * 10 + minIdleTime
     */

    for (i=0; i<total-1; i++)
      {
        high = 0 ;
        for (j=i; j<total; j++)
	    if ((tmphigh = hostDescriptorArray[j].freeTeams * 10 +
	         hostDescriptorArray[j].minIdleTime) > high)
	      {
	        high = tmphigh ;
		highindex = j ;
	      }
	tmpDescriptor = hostDescriptorArray[i] ;
	hostDescriptorArray[i] = hostDescriptorArray[highindex] ;
        hostDescriptorArray[highindex] = tmpDescriptor ;
      }
      
/*     for (i=0; i<total; i++)
 *       {
 *  	    printf("Host nr %d:    %x\n", 
 *  	    	i, hostDescriptorArray[i].maxIdleTime) ;
 *  	    printf("    avail: %d\n", hostDescriptorArray[i].avail) ;
 *   	    printf("    freeTeams %d\n", hostDescriptorArray[i].freeTeams ) ;
 *  	    printf("    freeProcs %d\n",hostDescriptorArray[i].freeProcs ) ;
 *  	    printf("    freeMem %d\n", hostDescriptorArray[i].minFreeMem ) ;
 *  	    printf("    Idletime %d\n", hostDescriptorArray[i].minIdleTime ) ;
 *      	    printf("\n") ;
 *       }
 */
    max = (max>total) ? total : max ;
    for (i=0; i<max; i++)
        arrayOfPIDs[i] = hostDescriptorArray[i].maxIdleTime ;
    free (hostDescriptorArray) ;
    return (max) ;
	    
  }



/*
 *
 *
 * ProcessId startup (priority, process, stacksize)
 *    int (*process)() ;
 *    int priority ;
 *    int stacksize ;
 *
 * startup will start up a local process appropriately and return its pid.
 * process will run with priority priority and have a stacksize of stacksize.
 * program will return 0 if this fails.
 *
 *
 */

ProcessId
startup (priority, process, stacksize)
    int priority ;
    int (*process)() ;
    int stacksize ;
  {
    ProcessId pid ;

    if ((pid = Create (priority, process, stacksize)) == 0) 
      {
        fprintf (stderr, "Could not create a process\n") ;
	Flush(stderr) ;
	sleep (1) ;
	return (0) ;
      }
    if (Ready (pid,0) != pid)
      {
        fprintf (stderr, "Could not Ready a process\n") ;
	Flush(stderr) ;
	sleep (1) ;
	return(0) ;
      }
    return (pid) ;
  }

/*
 *
 * ProcessId  getAHost( restart )
 *
 * getAHost gets a list of "available"
 * hosts on the network.
 * Each call to findAHost will return 1 hosts.
 *
 * restart defines if the list of hosts is to be recreated
 *
 * If an error condition is met, an error message is printed and exit is called.
 *
 * Returns the pid of next available host on network, 0 if no more
 * are available.
 *
 */

static ProcessId arrayOfPIDs[50] ;

ProcessId
getAHost ( restart )
    int restart ;
  {
    static int firsttime = 1 ;
    static int noOfHosts, host = 0 ;

    if( firsttime || restart ) {
          noOfHosts = getReadyHosts (50, arrayOfPIDs, 0) ;
	  firsttime = 0 ;
    }
    if (host < noOfHosts)
      return (arrayOfPIDs[host++]) ;
    else
      return (0) ;
  }

/*
 *
 *
 * ProcessId createNewTeam (teamServerId, args)
 *    ProcessId teamServerId ;
 *    char *args[] ;
 *
 *  CreateNewTeam will create a new team with the teamserver teamServerId.
 *  *args[] is the argv array with the arguments to newly created process.
 *  The last element in array must be a NULL pointer.
 *  The new team is started withthe concurrent bit set to on.
 *  stdin/out/err will be the same as in calling process.
 *
 *  pid of new team is returned. If error condition is encountered,
 *  an error msg is printed and 0 returned.
 *
 */

ProcessId
createNewTeam(teamServerId, args)
    ProcessId teamServerId ;
    char *args[] ;
  {
    ProcessId pid ;
    SelectionRec hostSpec;
    SystemCode error;
	    
    DefaultSelectionRec(&hostSpec);
    if (teamServerId == 0)
	teamServerId = GetPid(TEAM_SERVER, LOCAL_PID);
    hostSpec.teamServerPid = teamServerId;
    pid = ExecProgram(args, &hostSpec, NULL, NULL, NULL, &error) ;
    if (error != OK) 
      {
        printf ("ExecProgram at %x returns: %s\n",
	        teamServerId, ErrorString(error));
	return (0) ;
      }
    /* printf("started up new team %x\n", pid) ; */
    return (pid) ;
  }

/*
 *
 * masterwatch (master)
 *
 *    ProcessId master ;
 *
 * masterwatch does a ReceiveSpecific from process master. As soon as
 * the receive completes, it Destoys its creator.
 *
 */
 
masterwatch(master)
    ProcessId master ;
  {
    Message msg ;

    while (1)
      {
        Delay(10,0) ;
	if (! ValidPid(master))
	  {
#ifdef DEBUG
	    printf("Masterwatch %x in action\n", Creator(0)) ;
	    fflush( stdout ) ;
	    Delay( 0,10 ) ;
#endif
	    Destroy(Creator(0)) ;
	    break ;
	  }
      }
    
      printf("Masterwatch in process: %x : %x\n", 
        ReceiveSpecific(msg, master), master) ;
      Destroy(Creator(0)) ;
  }

#define WATCHTIME 5

slavewatch( slaves, noOfSlaves )
    struct slaves *slaves ;
    int noOfSlaves ;
  {
    int i ;
    ProcessId pid ;
    Message msg ;

    while (1)			/* forever */
      {
        Delay( WATCHTIME , 0 ) ;
	for (i=0; i<noOfSlaves; i++)
	    if( ! ValidPid( slaves[i].pid ) )
	      {
	        fprintf( stderr, "\nSlave %d disappeared. . .", i ) ;
	        if( ! slaves[i].argv )
		  {
		    if( slaves[i].computing )
		        (*slaves[i].recreateSubtask)( i, 0 ) ;
		  }
		else    /* a new slave is to be recreated */
		  {
slavewatchrestart:
		    if ((pid = getAHost( 0 )) ==0) /* No more hosts available */
	     	        getAHost( 1 ) ;		   /* so remake list of hosts */

		    if ((slaves[i].pid = createNewTeam( pid, slaves[i].argv )) == 0 )
		      {
			fprintf(stderr, "createteam at %x returns 0\n", pid) ;
			if( pid == 0 )		   /* cannot create local     */
			  {
			    fprintf(stderr, "Cannot recover: no more teams\n") ;
			    exit( 1 ) ;
			  }
			goto slavewatchrestart ;
		      }
		    if ( slaves[i].initMsg )
		      { 	/* we want to send an init message */
		    	(*slaves[i].initMsg)(msg, i, Creator(0) ) ;
		    	if (Send(msg, slaves[i].pid) != slaves[i].pid)
		      	  {
			    fprintf (stderr, 
				"startuphosts cannot send initMsg\n") ;
			    Destroy(slaves[i].pid) ;
			    goto slavewatchrestart ;
			  }
		      }
		    fprintf( stderr, "restarting as %x. . .", slaves[i].pid ) ;
		    /* JoinGroup( gid, Proc[i] ) ; */
		    if ( slaves[i].computing )
		      {
		    	ReceiveSpecific( msg, slaves[i].pid ) ;
		    	(*slaves[i].recreateSubtask)( i, msg ) ;
		    	fprintf(stderr, "recreated subtask" ) ;
		      }
		  } 		/* else */
		fprintf(stderr, "\n" ) ;
	      } 	    /* if( ! ValidPid ) */
      } 		/* while */

  }


startupSlaves ( slaves, noOfSlaves, argv, initMsg )
    struct slaves *slaves ;
    int noOfSlaves ;
    char *argv[] ;
    int (*initMsg)() ;
  {
    Message msg ;
    MsgStruct *msgstruct = (MsgStruct *) msg ;
    int noOfHosts, i ;
    ProcessId pid, gid ;

    noOfHosts = 0 ;
    for (i=0; i < noOfSlaves; i++)		/* for each host: 	*/
      { 
startupSlavesRestart:
	if( (pid = getAHost( 0 )) == 0 )
	     break ;				/* No more hosts available */
        if( (slaves[i].pid = createNewTeam( pid, argv)) == 0 )
	  {
	    fprintf(stderr, "createteam at %x returns 0\n", pid) ;
	    goto startupSlavesRestart ;
	  }
	(*initMsg)(msg, i, GetPid(0,0) ) ;
	if (Send(msg, slaves[i].pid) != slaves[i].pid)
	     {
	       fprintf (stderr, "startuphosts cannot send initMsg\n") ;
	       Destroy(slaves[i].pid) ;
	       goto startupSlavesRestart ;
	     }
	if( msgstruct->sysCode != OK )
	  {
	       Destroy(slaves[i].pid) ;
	       goto startupSlavesRestart ;
          }
	slaves[i].computing = 0 ;
	slaves[i].initMsg = initMsg ;		/* everything except */
	slaves[i].argv = argv ;			/*    recreateSubtask is */
						/*    initialized */
/*	if (i==0)
	   {
	     gid = CreateGroup( slave.pid[0], 0 ) ;
	     printf("Group = %x\n", gid) ;
	   }
	 else JoinGroup( gid, slave[i].pid) ;
*/       noOfHosts++ ;
      }
    if( noOfHosts == 0 )
      {
        if( (slaves[0].pid = createNewTeam( 0, argv)) == 0 )
	  {
	    fprintf(stderr, "createteam at %x returns 0\n", pid) ;
	    return( 0 ) ;
	  }
	(*initMsg)(msg, 0, GetPid(0,0) ) ;
	if (Send(msg, slaves[0].pid) != slaves[0].pid)
	     {
	       fprintf (stderr, "startuphosts cannot send initMsg\n") ;
	       Destroy(slaves[0].pid) ;
	       return( 0 ) ;
	     }
	slaves[0].computing = 0 ;
	slaves[0].initMsg = initMsg ;		/* everything except */
	slaves[0].argv = argv ;			/*    recreateSubtask is */
						/*    initialized */
	noOfHosts++ ;
      }
#ifdef DEBUG
    printf("returning from startuphosts with %d slaves\n", noOfHosts) ;
#endif
    return( noOfHosts ) ;
  }
