#include "checkers.h"
/* Blame DRC for this code being so hairy. */

Generate( board, nboard, capt )
    int *board, *nboard; int capt[];

    /* This function will determine and execute the computer's next move. */

  {
    extern int Po, Pod, Dir, Pdisp[], Pdispd[];
    register int  i, j;

/* Only the four (4) diagonal directions are legal. */
if (Dir >= 4) return(0);

    /* If a 'capture stack' has been allocated, then determine the
    * appropriate jump for multiple jump.  Otherwise, create a normal
    * (ie. non-jumping) move.
    */
    if( capt )
      {

       /* There are only 32 (normal) + 14 (border -- out of bounds) squares
        * that can be considered.
	*/
        while( Po < 56 )
          {

            /* This segment handles captures by the computer's men. */

            if( Ch_man( board, Po ) ) while(1)
              {

		/* Make sure that the direction is legal. */
		if (Dir >= board[Po]) goto no_direction_left;

               /* This gives 'i' the contents of the square which
                * the computer's piece will jump -- the type of
                * piece that will be captured by the computer.
		*/
                i = board[ Po + Pdisp[ Dir ] ];

               /* Attempt the jump only if the piece being captured is
                * an 'enemy,' and only if the square where the computer's
                * piece will land is empty.
		*/
                if( ( (i==RC) || (i==RK) ) && 
                    board[ Po+Pdispd[Dir] ] == 0 )
                  {

                   /* The capture stack can overflow if there are too many
                    * possible captures.  If this occurs, stop the program.
		    */
                    if( Pod == 48 )
                      {
                        puts( "\nOverflow in capture stack\n" );
			return (0) ;
                        /* Quit(); */
                      }

                   /* Set up a new entry (stackframe) in the capture stack.
                    * The stackframe consists of:
                    *                           1) the current location of
                    *                              the jumping piece,
                    *                           2) the direction of the jump,
                    *                           3) the location of the piece
                    *                              being jumped,
                    *                           4) the type of piece (man or
                    *                              king) being jumped.
		    */
                    capt[Pod] = Po;
                    capt[Pod+1] = Dir;
                    capt[Pod+2] = j = Po+Pdisp[Dir];
                    capt[Pod+3] = i;

                   /* Do the actual move:  empty the square containing
                    * the enemy's piece, put the jumping piece in its
                    * target square, and empty the source square for the
                    * jumping piece.
		    */
                    board[j] = EMPTY;
                    j = Po + Pdispd[Dir];
                    board[j] = board[Po];
                    board[Po] = EMPTY;

                   /* Set the current position for the piece under scrutiny,
                    * and then reset its movement direction (it is on a new
                    * square, and therefore in a new tactical situation).
                    * Finally, increment the capture stack pointer ('Pod').
		    */
                    Po = j;
                    Dir = 0;
                    Pod += 4;
                    break;
                  }
                else
                  {

                   /* Since a capture is possible, but not with the currently
                    * indicated direction, try another direction.  If none of
                    * the directions possible for the computer's piece lead
                    * to a capture, try another piece.
		    */
                    ++Dir;
                    if( Dir < board[Po] ) continue;

                   /* If the capture stack is empty, check another piece for
                    * a possible capture.
		    */
                    no_direction_left:  if( Pod == 0 )
                      {

                       /* Increment the board position pointer ('Po') in
                        * an attempt to find the next piece that belongs
                        * to the computer.  Also, reset the movement
                        * direction for the next piece.
			*/
                        ++Po;
                        Dir = 0;
                        break;
                      }

                   /* If the jump cannot be pursued, restore the board
                    * situation using the capture stack.  Decrement the
                    * stack pointer ('Pod') to get the previous stackframe,
                    * determine a new movement direction, put the captured
                    * piece back on the board, move the computer's piece
                    * back to its old source square, and reset the pointer
                    * to the computer piece's source square ('Po').
		    */
                    Pod -= 4;
                    Dir = capt[Pod+1] + 1;
                    board[ capt[Pod+2] ] = capt[Pod+3];
                    board[ capt[Pod] ] = board[Po];
                    board[Po] = EMPTY;
                    Po = capt[Pod];

/* If all of the possible directions for the current piece and position
 * have been used, go back further on the capture stack.
 */
if (Dir < board[Po])
    break;
goto no_direction_left;
                  }
              }

           /* If no capture is possible, try a normal, non-jumping move. */

            else if( Pod == 0 )
              {

               /* Try the next piece if the capture stack is empty...
                * that is, if nothing was moved to get the computer into
                * this (ie. the current) situation.
		*/
                ++Po;
                Dir = 0;
                continue;
              }
            else

           /* If the capture stack isn't empty, then all of the possible
            * captures have been considered; copy the 'working copy' of the
            * board into 'nboard' and check to see if any of the computer's
            * checkers can be promoted to kings.  Also, release the current
            * stackframe and restore the old board contents and positions
            * from it.
	    */
              {
                Copy( nboard, board, 64*BYTES_PER_WORD );
                for( j=52; j<56; ++j )
                    if( nboard[j] == BC ) nboard[j] = BK;
while(1){
                Pod -= 4;
                Dir = capt[Pod+1] + 1;
                board[ capt[Pod+2] ] = capt[Pod+3];
                board[ capt[Pod] ] = board[Po];
                board[Po] = EMPTY;
                Po = capt[Pod];
		if (Pod==0)
                    return( 1 );
}
              }
          }
        return( 0 );
      }
    else

   /* If no capture stack was allocated, then no capture is possible; in
    * this case, just try for a normal, non-jumping move.
    */
      {

       /* Make a working copy of the current board; then, for each of the
        * possible squares on the board, analyse the contents of the square
        * and the possible consequences of it.
	*/
        Copy( nboard, board, 64*BYTES_PER_WORD);
        while( Po < 56 ) switch( board[Po] )
          {

           /* Squares that are out-of-bounds, or that are empty, or that
            * contain the human's pieces are ignored:  they are skipped and
            * the next square is checked.  Note that 'Pod' is not used to
            * point to the capture stack here, but is used to point into
            * the displacement array ('Pdisp'), rather like 'Dir.'
	    */
            case OB :
            case EMPTY :
            case RC :
            case RK :
              {
                ++Po;
                Pod = 0;
		break;
              }

           /* Take action for the computer's kings. */

            case BK :
              {
                if( Pod > 3 )
                  {

                   /* Skip the current piece (a king) if all of the possible
                    * movement directions for it have been considered.  Reset
                    * the direction indicator for the next piece.
		    */
                    ++Po;
                    Pod = 0;
                  }
                else
                  {

                   /* Increment the direction indicator and determine what
                    * is in the next square along that direction.  If the
                    * target square is empty, move the computer's king into
                    * it.
		    */
                    ++Pod;
                    j = Po + Pdisp[Pod-1];
                    if( nboard[j] == 0 )
                      {
                        nboard[j] = nboard[Po];
                        nboard[Po] = EMPTY;

                       /* This segment does not belong:  if a king is being
                        * moved, the computer should not have to check to see
                        * if the piece ought to be promoted to a king (such as
                        * is the case with checkers that are moved).
			*/
                        for( j=52; j<56; ++j )
                            if( nboard[j] == BC ) nboard[j] = BK;
                        return( 1 );
                      }
                  }
		break;
              }

            /* Handle the computer's checkers (or men). */

            case BC :
              {
                if( Pod > 1 )
                  {

                   /* Skip the current man if all of the possible movement
                    * directions (forward only) for it have been considered.
                    * Reset the direcion indicator for the next piece.
		    */
                    ++Po;
                    Pod = 0;
                  }
                else
                  {

                   /* Increment the direction indicator to determine a
                    * possible move.  Let 'j' represent the contents of
                    * the target square.  If the target square is empty,
                    * move the computer's checker into it.  Also, check
                    * to promote the computer's checkers to kings if
                    * they are on the human's back row.
		    */
                    ++Pod;
                    j = Po + Pdisp[Pod-1];
                    if( nboard[j] == 0 )
                      {
                        nboard[j] = nboard[Po];
                        nboard[Po] = EMPTY;
                        for( j=52; j<56; ++j )
                            if( nboard[j] == BC ) nboard[j] = BK;
                        return( 1 );
                      }
                  }
		break;
              }
default: abort("Internal checker error");
          }
        return( 0 );
      }
  }
