/*
*  Checkers: a simple checker playing program.
*  Copyright 1981 (c) All Rights reserved David R. Cheriton
*  Transliterated from Zed and Verex, July 1983.
*
*   A program which attempts to play checkers
*
* MANIFEST definitions:  'INFINITY' represents the state of utter
*                                   defeat or absolute victory,
*                        'OB'       means 'out of bounds' on the
*                                   checker board,
*                        'EMPTY'    is for an empty board square,
*                        'RC'       means red checker or man,
*                        'BC'       is a black man or checker,
*                        'RK'       represents a red king, and
*                        'BK'       is for a black king.
*
*/
#include <Venviron.h>
#include <Vio.h>

#define INFINITY 	  4000
#define OB 	  -1
#define EMPTY 	  0
#define RC 	  1
#define BC 	  2
#define RK 	  3
#define BK 	  4

	/*
	 * The VGTS item number for the board, which should be greater than
	 * that of any of the 'pieces' (OB to BK above).
	 */
#define BOARD 5


	/* Misc. constants. */
#define FALSE 0
#define TRUE 1


#define SQUARE_SIZE 64

/* Constants used in the main menu. */
#define REDRAW 1
#define PASS 2
#define DEPTH 3
#define EDIT 4
#define RESIGN 5
#define BACKUP 6

/* The position of the Edit mode menu. */
#define EDIT_MENU_X 17*SQUARE_SIZE/2
#define EDIT_MENU_Y SQUARE_SIZE


/* The following added on for the distributed version */

#define REMFILE "remcheckers"
#define REMPRIORITY 50
#define MAXSLAVES 20
#define MAXDEPTH 10
/* #define min(a,b) ((a<b) ? a : b) */
/* #define max(a,b) ((a>b) ? a : b) */

#define INIT 0x1
#define RESULT_NEEDWORK (SEGMENT_PRESENT | WRITE_BIT | 0x2)
#define NEEDWORK (SEGMENT_PRESENT | WRITE_BIT | 0x3)
#define TRYAGAIN  0x4
#define GROUPUPDATE (DATAGRAM_SEND_BIT | 0x5 )
#define HERE_S_SOME_WORK  0x6

extern ProcessId Proc[] ;
extern int NoOfTeams, NoOfHosts ;

struct movestruct {
	struct movestruct *fptr ;
	int 	*board ;	/* pointer to the generated board */
	int	cmoves ;	/* the number of counter moves generated */
	int	canswers ;	/* the number of replies received */
	int	value ;		/* the best value found so far */
	int     problemno ;	/* the number of the move generated */
	int	gendone ;	/* true if all countermoves generated */
	struct  secondlevelstruct *bestson ;
}  ;

struct secondlevelstruct {
	struct secondlevelstruct *fptr ;
	int value ;
	struct movestruct *father ;
	int genno ;
	int best ;
} ;

struct rMsg {
  SystemCode requestcode ;
  short      slave ;
  short      level ;
  short      depth ;
  short      problemno ;
  short      genno ;
  ProcessId  group ;
  struct movestruct *problemstruct ; 
  short      value ;
  short      secondvalue ;
  char       *segptr ;		/* this will point to textbuf */
  unsigned   seglength ;	/* must be big enough for text and filename */
} ;

struct gMsg {
  SystemCode requestcode ;
  short      slave ;
  short      level ;
  short      depth ;
  short      problemno ;
  short      quit ;
  ProcessId  group ;
  int        returnvalue ;
  short      value ;
  short      secondvalue ;
  char       *segptr ;		/* this will point to textbuf */
  unsigned   seglength ;	/* must be big enough for text and filename */
} ;

#define CAPT(b) (b ? capt : 0)

#define ComputeTime(s1, t1, s2, t2)		\
		s2 = GetTime (&t2) - s1 ;	\
		t2 -= t1 ;			\
		if (t2 < 0) { 			\
		    t2 += CLICKS_PER_SEC ;	\
		    --s2 ;			\
		}

#define PrintBoard(ff,b)			\
		{				\
		  int i, *board ;			\
		  board = b ;			\
		  for (i=0; i<64; i++)		\
		     fprintf(ff, "%7d", board[i]);	\
		  fprintf(ff,"\n") ;		\
		}


struct slaves {
    ProcessId 	pid ;			/* pid of slave */
    int 	computing ;		/* if !=0 then subtask is recreated */
    int		(*recreateSubtask)() ;	/* by calling this function */
    int		(*initMsg)() ;		/* if !=0 this function creates
    					 * init message to be sent to slave */
    char	**argv ;		/* slave to be recreated */
    					/* 0 if nothing is to be recreated */
}  ;

struct initMsg {
    SystemCode requestcode ;
    short slave ;
    int recreating ;
    ProcessId master ;
    int memsize ;
    int filler[2] ;
    char *segptr ;
    int segsize ;
  }  ;
