static	char sccsid[] = "@(#)cc.c 4.7 7/1/83";
/*
 * cc - front end for C compiler
 *
 * Modifications at Stanford
 *
 * Hartwell Tue Nov  8 14:18:08 1983 
 * Modified from Stanford 4.1 local version
 *   -- Added -v flag which prints out the passes of compilation (like the
 *	-v flag of /bin/sh) showing argv[1..n].
 *   -- Added -L flag which disables at runtime both of the next two
 *	mods from taking effect.
 * #ifdef STANFORDINCLUDE
 *   -- Added /usr/stanford/include to the path of include directories for
 *	cpp to search for.  Disabled by the -L flag.
 * #endif STANFORDINCLUDE
 * #ifdef STANFORDLIB
 *   -- Added /usr/stanford/lib/libStanford.a to the loader command just
 *	before the -lc (libc.a) library.  It is inserted BEFORE libc.a so
 *	Stanford modules with the same name will be loaded from libStanford.a
 *	in /usr/stanford/lib rather than /lib/libc.a.  The full pathname
 *	is specified since we don't want it searching around in /lib or
 *	/usr/lib for this library.  Disabled by the -L flag.
 * #endif STANFORDLIB
 */


#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#ifdef  Vsystem
/* On Unix, the following is #define'd in #include <sys/dir.h> */
#define MAXNAMLEN  255

/* On Unix, the following is #define'd in #include <stdio.h> */
#define	BUFSIZ	1024
#endif

/* # define STANFORDINCLUDE      "-I/usr/stanford/include" 	/* Hartwell */
/* # define STANFORDLIB	      "/usr/stanford/lib/libStanford.a"	/* Hartwell */

#ifdef  unix
char	*cpp = "/lib/cpp";
char	*ccom = "/lib/ccom";
char	*c2 = "/lib/c2";
char	*as = "/bin/as";
char	*ld = "/bin/ld";
#endif

#ifdef  Vsystem
/*
 * Note: the "vax" at the end of these files means that these are programs
 * to generate code for the Vax, not that these programs themselves run
 * on the Vax.  At some point in the future there may be a version of these
 * that runs on the 68000.
 *
 * The C preprocessor (cpp) should be the same for all machines (I think).
 */

#ifdef TESTVERSION
char    *cpp = "[storage/pescadero]/usr/xV/run/cc/cpptest";
char    *ccom = "[storage/pescadero]/usr/xV/run/cc/ccomvaxtest";
char    *c2 = "[storage/pescadero]/usr/xV/run/cc/c2vaxtest";
char    *as = "[storage/pescadero]/usr/xV/bin/asvaxtest";
char    *ld = "[storage/pescadero]/usr/xV/bin/ldvaxtest";
#else
char    *cpp = "[sys]run/cc/cpp";  /* This should be the same for vax & sun */
char    *ccom = "[sys]run/cc/ccomvax";
char    *c2 = "[sys]run/cc/c2vax";
char    *as = "[bin]asvax";
char    *ld = "[bin]ldvax";
#endif

#endif

char	*crt0 = "/lib/crt0.o";

char	tmp0[30];		/* big enough for /tmp/ctm%05.5d */
char	*tmp1, *tmp2, *tmp3, *tmp4, *tmp5;
char	*outfile;
char	*savestr(), *strspl(), *setsuf();
int	idexit();
char	**av, **clist, **llist, **plist;
int	cflag, eflag, oflag, pflag, sflag, wflag, Rflag, exflag, proflag;
int	gflag, Gflag;
int	vflag;		/* Hartwell */
# if defined(STANFORDINCLUDE) || defined(STANFORDLIB)
int	Lflag;		/* Hartwell */
# endif
char	*dflag;
int	exfail;
char	*chpass;
char	*npassname;
/* following are new variables needed to implement -V, Schuster */
int	Vflag=0;	/* 1 => compile for V world, 2 => compile for xV */
			/* This is a (x)V team if version = 0, or a      */
			/*   standalone program otherwise.		 */
char	version = 0;	/* Which version to compile for:	*/
			/*   's' = normal V standalone program, */
			/*   'd' = V standalone with debugger   */
int	floatflag = 0;	/* use G floating point? */

/* Various library routines for V */
char    libV[] = "/usr/V/lib/vax/libV.a"; /* V library */
char    Vcrt0[] = ""; /* Startup code -- now taken from library */
char    Vlibdir[] = "/usr/V/lib/vax/";    /* Directory for libraries */
char    Vstandalonecrt0[]  = "/usr/V/lib/vax/crt0.o"; /* Standalone startup */
char    libVstandalone[]  = "/usr/V/lib/vax/libVsa10.a"; /* Standalone lib */
char    Vdebugcrt0[]  = "/usr/V/lib/vax/xdeltacrt0.o"; /* Debug startup */

/* Same, but for xV instead of V */
char    libxV[] = "/usr/xV/lib/vax/libV.a"; /* xV library */
char xVcrt0[] = "";	/* Find _start in libV.a - Lance Berc */
#ifdef undef
char    xVcrt0[] = "/usr/xV/lib/vax/_start.o"; /* xV startup */
#endif
char    xVlibdir[] = "/usr/xV/lib/vax/";  /* Directory for libraries */
char    xVstandalonecrt0[] = "/usr/xV/lib/vax/crt0.o"; /* Standalone startup */
char    libxVstandalone[] = "/usr/xV/lib/vax/libVsa10.a"; /* Standalone lib */
char    xVdebugcrt0[] = "/usr/xV/lib/vax/xdeltacrt0.o"; /* Debug startup */

/* Standalone debugger - only sort-of part of V (or xV) */
char	Vdebugger[]  = "/usr/local/lib/xdelta.o";
char	xVdebugger[] = "/usr/local/lib/xdelta.o"; /* Probably always identical */

int	nc, nl, np, nxo, na;

#define	cunlink(s)	if (s) unlink(s)

main(argc, argv)
	char **argv;
{
	char *t;
	char *assource;
	int i, j, c;

	/* ld currently adds upto 5 args; 10 is room to spare */
	av = (char **)calloc(argc+10, sizeof (char **));
	clist = (char **)calloc(argc, sizeof (char **));
	llist = (char **)calloc(argc, sizeof (char **));
	/* -V currently adds upto 5 args; 10 is room to spare */
	plist = (char **)calloc(argc+10, sizeof (char **));
	for (i = 1; i < argc; i++) {
		if (*argv[i] == '-') switch (argv[i][1]) {

		case 'S':
			sflag++;
			cflag++;
			continue;
		case 'o':
			if (++i < argc) {
				outfile = argv[i];
				switch (getsuf(outfile)) {

				case 'c':
				/* case 'o': Schuster, for needed versatility */
					error("-o would overwrite %s",
					    outfile);
					exit(8);
				}
			}
			continue;
		case 'R':
			Rflag++;
			continue;
		case 'O':
			oflag++;
			continue;
		case 'p':
			proflag++;
			crt0 = "/lib/mcrt0.o";
			if (argv[i][2] == 'g')
				crt0 = "/usr/lib/gcrt0.o";
			continue;
		case 'g':
			if (argv[i][2] == 'o') {
			    Gflag++;	/* old format for -go */
			} else {
			    gflag++;	/* new format for -g */
			}
			continue;
		case 'w':
			wflag++;
			continue;
		case 'E':
			exflag++;
		case 'P':
			pflag++;
			if (argv[i][1]=='P')
				fprintf(stderr,
	"cc: warning: -P option obsolete; you should use -E instead\n");
			plist[np++] = argv[i];
		case 'c':
			cflag++;
			continue;
		case 'D':
		case 'I':
		case 'U':
		case 'C':
			plist[np++] = argv[i];
			continue;
		case 't':
			if (chpass)
				error("-t overwrites earlier option", 0);
			chpass = argv[i]+2;
			if (chpass[0]==0)
				chpass = "012p";
			continue;
		case 'B':
			if (npassname)
				error("-B overwrites earlier option", 0);
			npassname = argv[i]+2;
			if (npassname[0]==0)
				npassname = "/usr/c/o";
			continue;
		case 'd':
			dflag = argv[i];
			continue;
		case 'v':		/* Hartwell */ /* Schuster */
			/* what version, or verbose if no version specified */
			if (argv[i][2] == 0)   /* Plain -v */
			{
				++vflag;
				continue;
			}
			/* set Vflag to 1 for -vV, 2 for -vx or -vxV */
			if (!strcmp("V", &argv[i][2])) Vflag = 1;
			if (!strcmp("xV", &argv[i][2])) Vflag = 2;
			if (!strcmp("x", &argv[i][2])&&Vflag) Vflag = 2;
			if (Vflag != 0) {
				llist[nl++] = "-e";
				llist[nl++] = "__start";
			}
			continue;
# if defined(STANFORDINCLUDE) || defined(STANFORDLIB)
		case 'L':		/* Hartwell */
			++Lflag;
			continue;
# endif
		case 'V':		/* Schuster */
			/* compile for V OS; synonym (redundant?) for -vV */
			if (Vflag == 0)
				/* If we've already specified xV, don't */
				/*   clobber it				*/
				Vflag = 1;
			continue;
 		case 'i':		/* Schuster */
			/* file instead of crt0.o */
 			if (proflag)
 				error("-i overwrites earlier option", 0);
 			proflag = 0;
 			crt0 = argv[i]+2;
 			continue;
 		case 'G':		/* Schuster */
			/* pass -XF to ccom, use G floating point */
			if (argv[i][2] == '\0')
				floatflag++;
			else
				floatflag = -1; /* HACK */
 			continue;
		case 'l':               /* Intercept loader's -l flag */
		/* If this is V, change -lfoo to /usr/sun/V/lib/libfoo.a */
			if (!Vflag)
				break;  /* Only for V */
			{
				char fn[BUFSIZ];  /* Temp file name */

				strcpy(fn, Vflag == 2   ? xVlibdir
							  : Vlibdir);
				strcat(fn, "lib");
				strcat(fn, &argv[i][2]);
				llist[nl++] = strspl(fn, ".a");
			}
 			continue;
		}
		t = argv[i];
		c = getsuf(t);
		if (c=='c' || c=='s' || exflag) {
			clist[nc++] = t;
			t = setsuf(t, 'o');
		}
		if (nodup(llist, t)) {
			llist[nl++] = t;
			if (getsuf(t)=='o')
				nxo++;
		}
	}
	if (Vflag == 0)
		Vflag = 1;	/* -V is the default */
	if (Vflag) {
		floatflag++;
/***		npassname = "/usr/local/lib/VAX"; ***/
/***		chpass = "0"; ***/
		gflag = Gflag = proflag = 0;
		crt0 = Vcrt0;
		plist[np++] = "-DLITTLE_ENDIAN";
		plist[np++] = "-DVAX";
		plist[np++] = "-DVsystem";
	/*      plist[np++] = "-DxV";  Tim says take this out */
		if (Vflag == 2)
		{
		    plist[np++] = "-I/usr/xV/include/vax";
		    plist[np++] = "-I/usr/xV/include/mi";
		} else
		{
		    plist[np++] = "-I/usr/V/include/vax";
		    plist[np++] = "-I/usr/V/include/mi";
		}
		if (version == 's') {
			if (Vflag == 2)
				crt0 = xVstandalonecrt0;
			else
				crt0 = Vstandalonecrt0;
		} else if (version == 'd') {
			if (Vflag == 2)
				crt0 = xVdebugger;
			else
				crt0 = Vdebugger;
		} else {
			if (Vflag == 2)
				crt0 = xVcrt0;
			/* For no good reason, we do the normal case above */
		}
	}
	if (gflag || Gflag) {
		if (oflag)
			fprintf(stderr, "cc: warning: -g disables -O\n");
		oflag = 0;
	}
	if (npassname && chpass ==0)
		chpass = "012p";
	if (chpass && npassname==0)
		npassname = "/usr/new";
	if (chpass)
	for (t=chpass; *t; t++) {
		switch (*t) {

		case '0':
			ccom = strspl(npassname, "ccom");
			continue;
		case '2':
			c2 = strspl(npassname, "c2");
			continue;
		case 'p':
			cpp = strspl(npassname, "cpp");
			continue;
		}
	}
	if (nc==0)
		goto nocom;
	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, idexit);
	if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
		signal(SIGTERM, idexit);
	if (pflag==0)
#ifdef  unix
		sprintf(tmp0, "/tmp/ctm%05.5d", getpid());
#endif
#ifdef  Vsystem
		sprintf(tmp0, "/tmp/Vctm%08.8x",
			GetPid(ACTIVE_PROCESS, LOCAL_PID));
#endif
	tmp1 = strspl(tmp0, "1");
	tmp2 = strspl(tmp0, "2");
	tmp3 = strspl(tmp0, "3");
	if (pflag==0)
		tmp4 = strspl(tmp0, "4");
	if (oflag)
		tmp5 = strspl(tmp0, "5");
	for (i=0; i<nc; i++) {
		if (nc > 1) {
			printf("%s:\n", clist[i]);
			fflush(stdout);
		}
 		if (getsuf(clist[i]) == 's'&& !exflag /* Schuster */) {
			assource = clist[i];
			goto assemble;
		} else
			assource = tmp3;
		if (pflag)
			tmp4 = setsuf(clist[i], 'i');
		av[0] = "cpp"; av[1] = clist[i]; av[2] = exflag ? "-" : tmp4;
		na = 3;
		for (j = 0; j < np; j++)
			av[na++] = plist[j];
# ifdef STANFORDINCLUDE
		if (!Lflag) av[na++] = STANFORDINCLUDE;		/* Hartwell */
# endif STANFORDINCLUDE
		av[na++] = 0;
		if (callsys(cpp, av)) {
			exfail++;
			eflag++;
		}
		if (pflag || exfail) {
			cflag++;
			continue;
		}
		if (sflag)
			assource = tmp3 = setsuf(clist[i], 's');
		av[0] = "ccom"; av[1] = tmp4; av[2] = oflag?tmp5:tmp3; na = 3;
		if (proflag)
			av[na++] = "-XP";
		if (gflag) {
			av[na++] = "-Xg";
		} else if (Gflag) {
			av[na++] = "-XG";
		}
		if (floatflag) /* Schuster */
			av[na++] = "-XF";
		if (wflag)
			av[na++] = "-w";
		av[na] = 0;
		if (callsys(ccom, av)) {
			cflag++;
			eflag++;
			continue;
		}
		if (oflag) {
			av[0] = "c2"; av[1] = tmp5; av[2] = tmp3; av[3] = 0;
			if (callsys(c2, av)) {
				unlink(tmp3);
				tmp3 = assource = tmp5;
			} else
				unlink(tmp5);
		}
		if (sflag)
			continue;
	assemble:
		cunlink(tmp1); cunlink(tmp2); cunlink(tmp4);
 		av[0] = "as"; av[1] = "-o";
		/* next line allows -o with -c, Schuster */
		av[2] = (cflag && outfile) ? outfile : setsuf(clist[i], 'o');
		na = 3;
		if (Rflag)
			av[na++] = "-R";
		if (dflag)
			av[na++] = dflag;
		av[na++] = assource;
		av[na] = 0;
		if (callsys(as, av) > 1) {
			cflag++;
			eflag++;
			continue;
		}
	}
nocom:
	if (cflag==0 && nl!=0) {
		i = 0;
		av[0] = "ld"; av[1] = "-X"; na = 2;
		if (crt0 && *crt0) av[na++] = crt0;
		if (outfile) {
			av[na++] = "-o";
			av[na++] = outfile;
		}
		while (i < nl)
			av[na++] = llist[i++];
# ifdef STANFORDLIB
		if (!Lflag) av[na++] = STANFORDLIB;	/* Hartwell */
# endif STANFORDLIB
		if (gflag || Gflag)
			av[na++] = "-lg";
		if (proflag)
			av[na++] = "-lc_p";
		else if (Vflag) {
			if (version == 's' || version == 'd')
				if (Vflag == 2)
					av[na++] = libxVstandalone;
				else
					av[na++] = libVstandalone;
/* This will automatically include the normal libV even with standalone
 *   programs.  Is this really what we want? */
			av[na++] = Vflag == 2 ? libxV: libV;
		}
		else
			av[na++] = "-lc";
		av[na++] = 0;
		eflag |= callsys(ld, av);
		if (nc==1 && nxo==1 && eflag==0)
			unlink(setsuf(clist[0], 'o'));
	}
	dexit();
}

idexit()
{

	eflag = 100;
	dexit();
}

dexit()
{

	if (!pflag) {
		cunlink(tmp1);
		cunlink(tmp2);
		if (sflag==0)
			cunlink(tmp3);
		cunlink(tmp4);
		cunlink(tmp5);
	}
	exit(eflag);
}

error(s, x)
	char *s, *x;
{
	FILE *diag = exflag ? stderr : stdout;

	fprintf(diag, "cc: ");
	fprintf(diag, s, x);
	putc('\n', diag);
	exfail++;
	cflag++;
	eflag++;
}

getsuf(as)
char as[];
{
	register int c;
	register char *s;
	register int t;

	s = as;
	c = 0;
	while (t = *s++)
		if (t=='/')
			c = 0;
		else
			c++;
	s -= 3;
	if (c <= MAXNAMLEN && c > 2 && *s++ == '.')
		return (*s);
	return (0);
}

char *
setsuf(as, ch)
	char *as;
{
	register char *s, *s1;

	s = s1 = savestr(as);
	while (*s)
		if (*s++ == '/')
			s1 = s;
	s[-1] = ch;
	return (s1);
}

#ifdef  unix
callsys(f, v)
	char *f, **v;
{
	int t, status;

	if (vflag) {			/* Hartwell: print out argv[1..n] */
	    register char **tv;
	    tv = v;
	    fputc('+', stderr);
	    while (*tv != NULL) fprintf(stderr, " %s", *tv++);
	    fputc('\n', stderr);
	}
	t = vfork();
	if (t == -1) {
		printf("No more processes\n");
		return (100);
	}
	if (t == 0) {
		execv(f, v);
		printf("Can't find %s\n", f);
		fflush(stdout);
		_exit(100);
	}
	while (t != wait(&status))
		;
	if ((t=(status&0377)) != 0 && t!=14) {
		if (t!=2) {
			printf("Fatal error in %s\n", f);
			eflag = 8;
		}
		dexit();
	}
	return ((status>>8) & 0377);
}
#endif

#ifdef  Vsystem
#include <Vteams.h>
callsys(f, v)
	char *f, **v;
{
	extern RootMessage *RootMsg;
	int status;
	SystemCode error;
	char path[100];
	char *pathptr, *p;
	char *rindex();

	/*
	 * f contains the full file name, but Vsystem wants the search
	 * path as a separate argument, and looks in all the search path
	 * directories for a file by the name contained in argv[0].
	 * Here we copy everything up to and including the last '/' or ']'
	 * into the path variable, and then change v[0] to be the
	 * remainder of the name (that's normally would it would be
	 * anyway).
	 */

	if ((p = rindex(f, '/')) != 0 ||  /* See if file name has a directory */
	    (p = rindex(f, ']')) != 0)    /* See if file name has a context */
	{
	    p++;	/* Point to first character after context */
	    path[0] = '\0'; /* Initialize to null string */
	    strncat(path, f, p - f); /* Copy context into path */
	    v[0] = p;   /* Make sure v[0] is the last part of the file name */
	    pathptr = path;
	}
	else
	    pathptr = NULL;  /* If none, let system use the default path */


	
	if (vflag) {			/* Hartwell: print out argv[1..n] */
	    register char **tv;
	    tv = v;
	    fputc('+', stderr);
	    while (*tv != NULL) fprintf(stderr, " %s", *tv++);
	    fputc('\n', stderr);
	    Flush(stderr);
	}
	ExecProgram(v, NULL, RootMsg, pathptr, &status, &error);	
	if (error != OK)
	{
		PrintError(error, f);
		printf("Fatal error in %s\n", f);
		eflag = 8;
		dexit();
	}
	return (status);
}
#endif

nodup(l, os)
	char **l, *os;
{
	register char *t, *s;
	register int c;

	s = os;
	if (getsuf(s) != 'o')
		return (1);
	while (t = *l++) {
		while (c = *s++)
			if (c != *t++)
				break;
		if (*t==0 && c==0)
			return (0);
		s = os;
	}
	return (1);
}

#define	NSAVETAB	1024
char	*savetab;
int	saveleft;

char *
savestr(cp)
	register char *cp;
{
	register int len;

	len = strlen(cp) + 1;
	if (len > saveleft) {
		saveleft = NSAVETAB;
		if (len > saveleft)
			saveleft = len;
		savetab = (char *)malloc(saveleft);
		if (savetab == 0) {
			fprintf(stderr, "ran out of memory (savestr)\n");
			exit(1);
		}
	}
	strncpy(savetab, cp, len);
	cp = savetab;
	savetab += len;
	saveleft -= len;
	return (cp);
}

char *
strspl(left, right)
	char *left, *right;
{
	char buf[BUFSIZ];

	strcpy(buf, left);
	strcat(buf, right);
	return (savestr(buf));
}
