/* Extrememly rudimentary support for .stabx pseudo-ops.
 * Per Bothner, Sept 1984
 */
#include "mical.h"
#ifdef SymDesc
#include <procdesc.h>
int paramCount = -1;
#define BufSize 300
#define ParamMax 20
static short paramPos[ParamMax];
static char paramBuffer[BufSize], *bufPtr;
static nameStart, typeStart; /* position in Line where name and type start */
#endif SymDesc

/* Recognize .stabs pseudo-op */
Stabs()
  {
#ifdef SymDesc
	register int C;			/* the current character */
	Non_Blank();			/* first non-blank is delimiter */
	Position++;			/* move up to first char */
	nameStart = Position;
	while (C = Line[Position++], C != ':') {}
	typeStart = Position;
	C = Line[Position];
	BC = 0;
	if (C == 'F' || C == 'f') New_function();
	else if (C == 'p') New_param();
	else return;
	if (Pass == 1) Print_Line(P_NONE);
#endif SymDesc
  }
#ifdef SymDesc
extern struct sym_bkt *Lookup(S);
static New_function()
  { char *delim = Line + typeStart - 1;
    int saveCh = *delim;
    struct sym_bkt *sbp;
    *delim = '\0'; /* to make C string */
    sbp = Lookup(Line+nameStart);
    *delim = saveCh;
    sbp->attr_s |= S_FDESC;
    paramCount = 0;
    bufPtr = paramBuffer;
  }
static New_param()
  { int len = typeStart - nameStart - 1;
    if (bufPtr + len + 2 > paramBuffer + BufSize)
      { Prog_Error(E_NOSPACE); return; }
    strncpy(bufPtr, Line + nameStart, len);
    if (paramCount >= ParamMax)
      { Prog_Error(E_NOSPACE); return; }
    paramPos[paramCount++] = bufPtr - paramBuffer;
    bufPtr += len;
    *bufPtr++ = '\0';
    if ((long)bufPtr & 1) *bufPtr++ = '\0';
  }
ReleaseFuncStab()
  { int i, descBC;
    extern struct sym_bkt *Dot_bkt;
    int diff = Dot;
    Operand.sym_o = Dot_bkt;
    BC = bufPtr - paramBuffer;
    Put_Text(paramBuffer, BC);

    descBC = BC;
    i = 0;
    Put_Words(&i, sizeof(short));		/* bits */ 
    Put_Words(&paramCount, sizeof(short));
    Put_Long(0);
    Put_Long(0);
    BC += 12;
    for (i = 0; i < paramCount; i++)
      {
	Put_Rel(&Operand, L, Dot+BC);
	Put_Long(diff+paramPos[i]);	/* name */
	Put_Long(0);			/* type */
	Put_Long(ArgNoDefaults);	/* defaultVal */
	Put_Long(0);
	BC += 16;
      }
    Put_Rel(&Operand, L, Dot+BC);
    Put_Long(diff+descBC);
    BC += 4;
    Operand.sym_o = Lookup("PostfixProc");
    Put_Rel(&Operand, L, Dot+BC); 
    Put_Long(0);
    BC += 4;
    paramCount = -1;
  }

Put_Long(x) long x;
  { int w[2];
    w[0] = x >> 16; w[1] = x;
    Put_Words(w, sizeof(long));
  }
#endif SymDesc
