#include "cal.h"

CalendarServer()
  {
    Message msg;
    CalendarRequest *request = (CalendarRequest *) msg;
    CalendarReply *reply = (CalendarReply *) msg;

    ProcessId id;
    NameTable Table;

    Initialize(Table);


    while (TRUE)
      {
        id = Receive(msg);
	
	switch( request->requestcode )
	  {
	    case CREATE_CALENDAR | FORCE:
	    case CREATE_CALENDAR: OpenCalendar( Table, msg, id );
	                          break;
				  
	    case CLOSE_CALENDAR: CloseCalendar( Table, msg, id );
	                         break;
				 
	    case READ_RECORD: ReadRecord( Table, msg, id );
	                      break;
			      
	    case UPDATE_RECORD: WriteRecord( Table, msg, id );
	                        break;
				
	    case LIST_REGISTERED: ReturnList( Table, msg, id );
	                          break;
				  
	    default: reply->replycode = INVALID_REQUEST;
	             break;
	  }
	Reply( msg, id );
      }
  }
  