#include "fep.h"

SystemCode
WriteRecord( globalinfo, Week )
Globals *globalinfo;
WeekRecord *Week;
  {
    Message msg;
    CalendarIoRequest *request = (CalendarIoRequest *) msg;
    CalendarIoReply *reply = (CalendarIoReply *) msg;

    request->requestcode = UPDATE_RECORD;
    request->name = globalinfo->who;
    request->fileid = globalinfo->fileid;
    request->weekptr = Week;
    request->date = Week->date;
    request->length = sizeof(WeekRecord);

    Send(msg,globalinfo->calpid);
    
    if (reply->replycode != OK)
        switch(reply->replycode)
	  {
            case NO_PERMISSION:
	        printf("Access denied, no permission\n");
	        break;
	    
	    case BAD_ARGS:
	        printf("Arguments to Calendar Server are invalid\n");
	        abort();
	        break;
	    
	    default:
	         printf("record not found\n");
	         break;
	  }
    return(reply->replycode);
  }