#include "fep.h"

View(globalinfo, name, date, calpid )
Globals *globalinfo;
char *name;
int date;
ProcessId calpid;
  {
    char chr;
    int when;
    int whattime, fileid, choice, i, j;
    SystemCode reply, ReadRecord();
    
    WeekRecord Week;
    
    Week.date = 0;
    Week.modified = 0;
    for(i=0; i<7; i++)
        for(j=0; j<96; j++) Week.days[i].time[j] = UNAVAILABLE;
	
    globalinfo->who = name;
    if ((reply = RequestView( globalinfo, calpid, &fileid )) != OK)
        if (reply == NEW_CALENDAR)
	  {
	    SetUpTemplate( globalinfo, &Week, NEW_CALENDAR );
            RequestClose(globalinfo);
	    return;
	  }
	else
	  {
	    switch(reply)
	      {
	        case NOT_FOUND:
		    printf("Name not found\n");
	            break;
			    
 	        case BAD_ARGS:
	            printf("Arguments to Calendar Server are invalid\n");
	            abort();
	            break;
		    
		case FILE_FULL:
		    printf("Names file is full.\n");
		    break;
			   
	        default:
	            printf("Illegal Request\n");
	            break;
	      }
	    return;
	  }

    when = -1;
    
    GetSelection (  VIEW, &choice);

    while (when < date && when != 0)	
        when = GetDate(stdin, "Enter date (0 for template) :");
    
    if (ReadRecord( globalinfo, &Week, when ) == OK)
    if (choice == UPDATE_CALENDAR)
        UpdateCalendar( globalinfo, &Week, when, date );
    else
        ViewCalendar( globalinfo, &Week, when, date );
	
    RequestClose( globalinfo );

    return;
  }
