#include "fep.h"

SetUpTemplate( globalinfo, Week, new )
Globals *globalinfo;
WeekRecord *Week;
int new;
  {
    int i, j, dayofweek,
        startTime, size;
    
    ClearScreen;
    if (new)
      {
        ReadRecord(globalinfo, Week, 0);
        printf("You may now enter a template to be used to create new weeks\n");
	printf("in your calendar.  If you have regular times that you accept\n");
	printf("appointments, enter those times and days here, and they \n");
	printf("will automatically become available for appointments each\n");
	printf("time a new week is created.  All other times will be marked\n");
	printf("as unavailable, though that can be changed \(through the Update\n");
	printf("option\), as can this template.  Currently, all times are\n");
	printf("set to unavailable.\n");
      }

    printf("Change a time by specifying the time, and length \n");
    printf("of the block to be set aside.  This toggles the current \n");
    printf("setting, so if you have a block of time available, it will\n");
    printf("be set to unavailable, and vice-versa.\n");
    if (!new)
      {
        printf("The current setting for each day will be printed, then you will be\n");
	printf("asked what changes you wish to make.  Absence of a time indicates\n");
	printf("that that time is unavailable.\n");
      }

    for(dayofweek = 0; dayofweek < 7; dayofweek++)
      {
        printf("%s :\n",PrintDay( dayofweek ));
    
        for (i=0; i<96; i++)
            if (Week->days[dayofweek].time[i] >= AVAILABLE)
	      {
	        PrintAppointment(i, Week->days[dayofweek].time[i]);
              }
        
	startTime = GetTime("What time would you like to change \(hh:mm, use 24-hr clock\)? ");
	while (startTime)
	  {
            size = GetTime("Length of block, in hours:minutes? ");
	    for (j=0; j< size; j++)
	        if (Week->days[dayofweek].time[startTime+j] == AVAILABLE)
		    Week->days[dayofweek].time[startTime+j] = UNAVAILABLE;
		else
		    Week->days[dayofweek].time[startTime+j] = AVAILABLE;

	    startTime = GetTime("What time would you like to change \(0 to end\)? ");
	  }
      }
      
    WriteRecord (globalinfo, Week );
    
    return;
  }
