#include "fep.h"

SetAppointment( globalinfo, Week, date, today )
Globals *globalinfo;
WeekRecord *Week;
int date, today;
  {
    int factor1, factor2, 
        dayofweek,
	daysahead,
	earliestTime,
        latestTime,
	appointmentLength;
    int i, j, chr;
    int when;

    factor1 = CalcFact(today);
    factor2 = CalcFact(date);
    if ( (daysahead = factor2 - factor1) < 2)
      {
        printf("Sorry, we're not accepting appointments this late.\n");
	printf("Would you like to try another date? ");
	if ((chr = getc(stdin)) != 'y' && chr != 'Y')
	    return;
	
	when = GetDate(stdin, "Enter new date : ");
	if ((dayofweek = (factor2 = CalcFact(when)) - CalcFact(Week->date)) > 6
	    || (daysahead = factor2 - factor1) < 2)
	    return;
	SetAppointment ( globalinfo, Week, when, today );
	return;
      }
    
    dayofweek = factor2 - CalcFact(Week->date);

    printf("Enter times as hh:mm, where mm can be 0, 15, 30 or 45. \n");
    printf("Please use the 24 hour clock : \n");    
    earliestTime = GetTime("What is the earliest appointment you can accept? ");
    latestTime = GetTime("What is the latest appointment you can accept? ");
    appointmentLength = GetTime("How long do you need? ");
    
    for (i=earliestTime; i<=latestTime; i++)
      {
        for (j=0; j<appointmentLength; j++)
	    if (Week->days[dayofweek].time[i+j] != AVAILABLE)
	        break;
        if (j >= appointmentLength)
	    break;
      }
    if (i>latestTime)
      {
        printf("Sorry, no appointments are available in that time period.\n");
	return;
      }

    for (j=0; j<appointmentLength; j++)
        Week->days[dayofweek].time[i+j] = globalinfo->userid;
	
    PutTime(i, "You have an appointment at ");
    printf("\n");

    WriteRecord ( globalinfo, Week );
    return;
  }


    
    