#include "fep.h"

CancelAppointment( globalinfo, Week, date, today )
Globals *globalinfo;
WeekRecord *Week;
int date, today;
  {
    int factor1, factor2, 
        dayofweek,
	daysahead,
	appointmentTime;
    int i,j;
    int when;

    factor1 = CalcFact(today);
    factor2 = CalcFact(date);
    if ( (daysahead = factor2 - factor1) < 2)
      {
        printf("Sorry, we can't cancel appointments this late.\n");
	return;
      }
    
    dayofweek = factor2 - CalcFact(Week->date);

    printf("Enter times as hh:mm, where mm can be 0, 15, 30 or 45. \n");
    printf("Please use the 24 hour clock : \n");    
    appointmentTime = GetTime("What time is the appointment? ");
    
    if (Week->days[dayofweek].time[appointmentTime] != globalinfo->userid)
      {
        printf("Sorry, that appointment is not yours to cancel. \n");
	return;
      }
    
    j = globalinfo->userid;
    i = appointmentTime;
    while(Week->days[dayofweek].time[i] == j) 
        Week->days[dayofweek].time[i++] = AVAILABLE;

    PutTime(appointmentTime, "Your appointment at ");
    printf(" has been cancelled.\n");
    
    WriteRecord ( globalinfo, Week );
    
    return;
  }


    
    