static	char *sccsid = "@(#)doname.c	4.2 (Berkeley) 83/02/03";
#include "defs"

/*  BASIC PROCEDURE.  RECURSIVE.  */

/*
p->done = 0   don't know what to do yet
p->done = 1   file in process of being updated
p->done = 2   file already exists in current state
p->done = 3   file make failed
*/

/*
 * Try to make the file given by the nameblock p.
 * Returns 0 on success.
 * If p exists, but nothing to do p->done is set to 2, but 1 is returned.
 * If reclevel is odd, don't complain if file can't be made; just return error.
 */

doname(p, reclevel, tval)
register struct nameblock *p;
int reclevel;
TIMETYPE *tval;
{
int errstat;
int okdel1;
int didwork;
TIMETYPE td, td1, tdep, ptime, ptime1, prestime();
register struct depblock *q;
struct depblock *qtemp, *srchdir(), *suffp, *suffp1;
struct nameblock *p1, *p2, tempblock;
struct shblock *implcom, *explcom;
register struct lineblock *lp;
struct lineblock *lp1, *lp2;
static char starbuf[100];
char *pnamep, *p1namep, *replacestar();
char *pfxfile;
char *rindex();
struct chain *qchain, *achain, *appendq();

if(p == 0)
	{
	*tval = 0;
	return(0);
	}

if(dbgflag)
	{
	printf("doname(%s,%d)\n",p->namep,reclevel);
	fflush(stdout);
	}

if(p->done > 0)
	{
	*tval = p->modtime;
	return(p->done == 3);
	}

errstat = 0;
tdep = 0;	/* tdep is latest time over the dependencies */
implcom = 0;
explcom = 0;
ptime = exists(p);
ptime1 = 0;
didwork = NO;
p->done = 1;	/* avoid infinite loops */

qchain = NULL;
achain = NULL;	/* also cleared for every new lineblock */

/* make sure all dependents are up to date */

for (p1 = p; p1; p1 = p2)
  {
    if (p1 == p)
	p2 = firstpattern;
    else
     {
	p2 = p2->nxtnameblock;
	if (starmatch(p->namep, p1->namep, starbuf))
	    setvar("*", starbuf);
	else
	    continue;
      }
    for(lp = p1->linep ; lp ; lp = lp->nxtlineblock)
	{
	/* Expand any names that have embedded metacharaters */
	for(q = lp->depp ; q ; q=qtemp )
		{
		qtemp = q->nxtdepblock;
		expand(q);
		}

	td = 0;
	achain = NULL; /* for consistency with Feldman's make */
	for(q = lp->depp ; q ; q = q->nxtdepblock)
		{ struct nameblock *qdep = q->depname;
		static char tmpnam[100];
		if (qdep == NULL) continue;

		if ((pnamep = replacestar(qdep->namep, tmpnam)) != qdep->namep)
			if( (qdep=srchname(tmpnam)) ==0)
				qdep = makename(tmpnam);

		errstat +=
		    doname(qdep, (reclevel|1)+(p1==p ? 1 : 2), &td1);
		if(dbgflag)
		    printf("TIME(%s)=%ld\n", qdep->namep, td1);
		if (errstat)
		   {
			td = 0;
			if (!keepgoing)
				break;
		   }
		if(td1 > td) td = td1;
		if(ptime < td1)
			qchain = appendq(qchain, qdep->namep);
		achain = appendq(achain, qdep->namep);
		}
	if(p->septype == SOMEDEPS)
		{
		if(lp->shp!=0 && errstat == 0)
		     if( ptime<td || (ptime==0 && td==0) || lp->depp==0)
			{
			okdel1 = okdel;
			okdel = NO;
			setvar("@", p->namep);
			setvarfromlist("?", qchain);
			setvarfromlist("<", achain);
			qchain = NULL;
			if( !questflag )
				errstat += docom(lp->shp);
			setvar("@", (char *) NULL);
			okdel = okdel1;
			ptime1 = prestime();
			didwork = YES;
			}
		}

	else	{
		if(td > tdep) tdep = td;
		if(lp->shp != 0)
			{
			if (p1 != p)
				{ 
				if (errstat == 0)
				    if (implcom = lp->shp)
					goto endloop;
				}
			else if (explcom)
				fprintf(stderr, "Too many command lines for `%s'\n",
					p->namep);
			else	explcom = lp->shp;
			}

		}
	if (p!=p1 && errstat==1) errstat = 0;
	}
  }


endloop:

if(errstat==0 && (ptime<tdep || (ptime==0 && tdep==0) ) )
	{
	ptime = (tdep>0 ? tdep : prestime() );
	setvar("@", p->namep);
	setvarfromlist("<", achain);
	setvarfromlist("?", qchain);
	if(explcom)
		errstat += docom(explcom);
	else if(implcom)
		errstat += docom(implcom);
	else if(reclevel & 1)
		++errstat;
	else if(p->septype == 0)
		if(p1=srchname(".DEFAULT"))
			{
 			if (p->alias) setvar("<", p->alias);
 			else setvar("<", p->namep);
			for(lp2 = p1->linep ; lp2 ; lp2 = lp2->nxtlineblock)
				if(implcom = lp2->shp)
					{
					errstat += docom(implcom);
					break;
					}
			}
		else if(keepgoing)
			{
			printf("Don't know how to make %s\n", p->namep);
			++errstat;
			}
		else
			fatal1(" Don't know how to make %s", p->namep);

	setvar("@", (char *) NULL);
	if (p->alias != NULL) /* redundant, except for the noexflag case */
	  { free(p->alias); p->alias = NULL; }
	if(noexflag || (ptime = exists(p)) == 0)
		if (!errstat)
			ptime = prestime();
	}

else if(errstat!=0 && reclevel==0)
	printf("`%s' not remade because of errors\n", p->namep);

else if(!questflag && reclevel==0  &&  didwork==NO)
    if (!p->alias)
	printf("`%s' is up to date.\n", p->namep);
    else
	printf("`%s' (alias `%s') is up to date.\n", p->namep, p->alias);

if(questflag && reclevel==0)
	exit(ndocoms>0 ? -1 : 0);

p->done = (errstat ? 3 : 2);
if(ptime1 > ptime) ptime = ptime1;
p->modtime = ptime;
*tval = ptime;
return(errstat);
}

/* Convert old-style dependencies (.c.o) to new format (*.o: $*.c) */
FixSuffixes()
{
struct lineblock *lp, *lp1;
char temp[30], *nam, *nam1;
struct depblock *suffp, *suffp1;
register struct nameblock *p, *p1;
for(lp = sufflist ; lp ; lp = lp->nxtlineblock)
    for(suffp = lp->depp ; suffp ; suffp = suffp->nxtdepblock)
	{
	if (suffp->depname == NULL) continue;
	nam = suffp->depname->namep;
	for(lp1 = sufflist ; lp1 ; lp1 = lp1->nxtlineblock)
	    for(suffp1=lp1->depp ; suffp1 ; suffp1 = suffp1->nxtdepblock)
		{ register struct lineblock *lblk, *plin;
		if (suffp1->depname == NULL) continue;
		nam1 = suffp1->depname->namep;
		p1=srchname(concat(nam1, nam ,temp));
		if (p1 == NULL || (plin = p1->linep) ==  NULL) continue;
		concat("*", nam, temp);
/* 		if (!(p = srchname(temp)))*/
			p = makename(temp);
		lblk = ALLOC(lineblock);
		if ((plin = p->linep) == NULL)
			p->linep = lblk;
		else
		{
			while (plin->nxtlineblock) plin = plin->nxtlineblock;
			plin->nxtlineblock = lblk;
		}
		plin = p1->linep;
/*	p1->linep = NULL; /* to avoid infinite loops */
		lblk->nxtlineblock = NULL;
		lblk->shp = plin->shp;
		lblk->depp = ALLOC(depblock);
		lblk->depp->nxtdepblock = plin->depp;
		concat(STAR, nam1, temp);
		lblk->depp->depname = makename(temp);
		}
	}
}

/* substitute macros and file names with true files names */
substfixname(src, dst)
    char *src, *dst;
  { register char *temp = (char *) malloc(OUTMAX);

    subst(src, temp);

    /* copy temp to dst, changing file names to file aliases */
    src = temp;
    while (*src) {
	if (isspace(*src)) *dst++ = *src++;
	else {
	    register char *r, *q;
	    struct nameblock *pn;
	    char name[100];
		r = name;
		while (*src) {
			if (isspace(*src)) break; 
			*r++ = *src++;
			}
		*r = '\0';
		
		if ((pn = srchname(name)) != 0 && pn->alias && pn->done == 2)
			q = pn->alias;
		else q = name;

		while (*q) *dst++ = *q++;
		}
	}
    *dst = '\0';
    free(temp);
  }


docom(q)	/* rewturn 2 on failure; 0 (NO) on success */
struct shblock *q;
{
char *s;
struct varblock *varptr();
int ign, nopr;
register char *string;

++ndocoms;
if(questflag)
	return(NO);

string = (char *) malloc(OUTMAX);

if(touchflag)
	{
	s = varptr("@")->varval;
	if(!silflag)
		printf("touch(%s)\n", s);
	if(!noexflag)
		touch(YES, s);
	}

else for( ; q ; q = q->nxtshblock )
	{
	substfixname(q->shbp, string);

	ign = ignerr;
	nopr = NO;
	for(s = string ; *s=='-' || *s=='@' ; ++s)
		if(*s == '-')  ign = YES;
		else nopr = YES;

	if( docom1(s, ign, nopr) && !ign)
		{
		free(string);
		if(keepgoing)
			return 2;
		else	fatal( (char *) NULL);
		}
	}
free(string);
return(NO);
}



docom1(comstring, nohalt, noprint)
register char *comstring;
int nohalt, noprint;
{
register int status;

if(comstring[0] == '\0') return(0);

if(!silflag && (!noprint || noexflag) )
	{
	printf("%s%s\n", (noexflag ? "" : prompt), comstring);
	fflush(stdout);
	}

if(noexflag) return(0);

if( status = dosys(comstring, nohalt) )
	{
	if( status>>8 )
		printf("*** Error code %d", status>>8 );
	else	printf("*** Termination code %d", status );

	if(nohalt) printf(" (ignored)\n");
	else	printf("\n");
	fflush(stdout);
	}

return(status);
}


/*
   If there are any Shell meta characters in the name,
   expand into a list, after searching directory
*/

expand(q)
register struct depblock *q;
{
register char *s;
char *s1;
struct depblock *p, *srchdir();

s1 = q->depname->namep;
for(s=s1 ; ;) switch(*s++)
	{
	case '\0':
		return;

	case '*':
	case '?':
	case '[':
		if( p = srchdir(s1 , YES, q->nxtdepblock) )
			{
			q->nxtdepblock = p;
			q->depname = 0;
			}
		return;
	}
}

starmatch(s, p, x)
    register char *s;	/* input string - no asterisks allowed */
    register char *p;	/* pattern - a string with at most \one/ '*' in it */
    char *x;	/* if s matches p, set x to the string which matches the '*' */
  { int starLen;
    for (; *s == *p; p++, s++)
	if (!*s) { *x = '\0'; return 1; }
    if (*p != '*') return 0;
    p++;
    starLen = strlen(s) - strlen(p);
    if (starLen < 0 || unequal(p, s + starLen)) return 0;
    while ( --starLen >= 0 ) *x++ = *s++;
    *x = '\0';
    return 1;
  }

char *
replacestar(src, dst)
 /* replace ocurrences of STAR with the value of variable $* */
    char *src, *dst;
{
register char *s = src, *s1 = dst;
char *prefix = NULL;
while (*s)
    if (*s != STAR[0]) *s1++ = *s++;
    else
      { prefix = varptr("*")->varval;
	strcpy(s1, prefix);
	s++; s1 += strlen(prefix);
      }
*s1 = '\0';
return prefix ? dst : src;
}

#if 0
char *
starinsert(p, x, s)	/* inverse of starmatch */
    register char *p; 	/* pattern - a string with at most \one/ '*' in it */
    register char *x;	/* string which should replace the '*' in p */
    register char *s;	/* resulting string */
  {
    while (*p && *p != '*') *s++ = *p++;
    if (*p++ == '*')
      {
	while (*x) *s++ = *x++;
	while (*p) *s++ = *p++;
      }
    *s = '\0';
    return s;
  }
#endif
