#include <Vio.h>
#include "bitptr.h"
struct BitPtr BitPtr;

SetBitPtr(p, r, x, y)
    register struct BitPtr *p;
    register MemRaster *r;
  { register bit = x + r->bitOffset;
    p->x = x;
    p->y = y;
    p->r = r;
    p->mask = 0xFFFF >> (bit & 15);
    p->ptr = r->start + y;
    if (bit >>= 4)
	p->ptr += bit * r->stride;
  }

/* SearchBit(bitPtr, color)
 * Increment bitPtr until a pixel of the right color is found.
 * return:
 *	1 if found
 *	0 if end-of-line and color has SearchEdge mode.
 *	-1 if end-of-raster.
 */
SearchBit(bitPtr, color)
    register struct BitPtr *bitPtr;
    u_short color;
  { u_short word;
    int bit;
    register u_short *ptr;
    register MemRaster *r = bitPtr->r;
    int totalWidth = r->bitOffset + r->width;
    u_short rightMask = 0xFFFF << ((16 - totalWidth) & 15);
    int col, lastCol = (totalWidth - 1) >> 4;
    int stride = r->stride;
    u_short skipValue = (color&SearchBlack) ? 0 : (u_short)(-1);

    col = (r->bitOffset + bitPtr->x) >> 4;
    for (; ; col = 0)
      { /* scan along one row */
	ptr = bitPtr->ptr;

	if (col >= lastCol)
	  {
	    if (word = ((*ptr ^ skipValue) & rightMask & bitPtr->mask))
		goto found;
	  }
	else
	  {
	    if (word = ((*ptr ^ skipValue) & bitPtr->mask))
		goto found;
	    for (; ptr += stride, ++col < lastCol;)
		if ((word = *ptr ^ skipValue) != 0)
		    goto found;
	    if (word = ((*ptr ^ skipValue) & rightMask))
		goto found;
	  }

	if ((color & (SearchUp|SearchDown)) == 0) goto notfound;
	if (color & SearchUp)
	  { if (--bitPtr->y < 0) return -1; }
	else /* if (color & SearchDown) */
	  { if (++bitPtr->y >= r->height) return -1; }
	/* SetBitPtr(bitPtr, r, 0, bitPtr->y); */
	bitPtr->x = 0;
	bitPtr->mask = 0xFFFF >> r->bitOffset;
	bitPtr->ptr = r->start + bitPtr->y;
      }

  notfound:
    bit = totalWidth & 15;
    if (bit==0) bit=16;
    skipValue = 0;
    goto exit;
  found:
    /* word == *ptr */
    for (bit = 0; (word & 0x8000) == 0; bit++) { word <<= 1; }
    skipValue = 1;
  exit:
    bitPtr->x = bit + 16*col - r->bitOffset;
    bitPtr->ptr = ptr;
    bitPtr->mask = 0xFFFF >> (bit & 15);
    if (skipValue==0 && bit==16) bitPtr->mask=0;
    return skipValue;
  }

BoundingBox(r, dx, dy, h, w)
    register MemRaster *r;
    int *dx, *dy, *h, *w;
  { struct BitPtr bitPtr;
    u_short lword, rword;
    register u_short *ptr;
    int totalWidth = r->bitOffset + r->width;
    int firstCol, lastCol = (totalWidth - 1) >> 4;
    short lcol, rcol, colSkip;
    register i;
    u_short *leftPtr, lmask;
    register u_short mask;

    if (r->height <= 0 || r->width <= 0) return 0;

    /* look for top edge */
    SetBitPtr(&bitPtr, r, 0, 0);
    if (SearchBit(&bitPtr, SearchBlack|SearchDown) < 0) return 0;
    *dy = bitPtr.y;
    leftPtr = r->start + *dy;

    /* look for bottom edge */
    SetBitPtr(&bitPtr, r, 0, r->height-1);
    SearchBit(&bitPtr, SearchBlack|SearchUp);
    *h = bitPtr.y - *dy + 1;
    colSkip = r->stride - *h;

    /* get left edge */
    mask = 0xFFFF >> r->bitOffset;
    lmask = mask;
    ptr = leftPtr;
    for (lword = 0, firstCol = 0; firstCol < lastCol; firstCol++)
      {
	for (i = *h; --i >= 0; ) lword |= *ptr++;
	lword &= mask; mask = (u_short)(-1);
	ptr += colSkip;
	if (lword!=0) break;
      }
      
    /* get right edge */
    mask = 0xFFFF << ((16 - totalWidth) & 15);
    ptr = leftPtr + lastCol * r->stride;
    rword = 0;
    for (;;)
      {
	for (i = *h; --i >= 0; ) rword |= *ptr++;
	rword &= mask;
	if (rword != 0) break;
	mask = (u_short)(-1);
	ptr -= (*h + r->stride); lastCol--;
      }
      /* abort(); */
    if (lword == 0) lword = rword & lmask;
    for (i = 0; (lword & 0x8000) == 0; i++) { lword <<= 1; }
    *dx = firstCol * 16 + i - r->bitOffset;
    for (i = 16; (rword & 1) == 0; i--) { rword >>= 1; }
    *w = lastCol * 16 + i - r->bitOffset - *dx;
    return 1;
  }
