/* Part of the 'bits' raster/font editor
 * Handle MetaFont-generated 'gf' (generic font format) fonts.
 * Copyright (c) Per Bothner. April 1984.
 */
#include "bits.h"
#include "bitptr.h"
#include "gfont.h"

int     GfVersion = 0;

#undef NEW_GF
#define NEW_GF (GfVersion == new_gf_magic)

LoadGfFont (fp)
FILE * fp;
  {
    int     c,
            i,
            gfLen;
    int     gBack,
            gCheckSum,
            minX,
            maxX,
            minY,
            maxY;

    if (GetUnsigned1 (fp) != pre)
	goto error;
    GfVersion = GetUnsigned1 (fp);
    if (GfVersion != old_gf_magic && GfVersion != new_gf_magic)
	goto error;
    c = GetUnsigned1 (fp);
    printf ("\n[");
    while (--c >= 0)
	fputc (fgetc (fp), stdout);
    fputc (']', stdout);
    fflush (stdout);
    fseek (fp, 0, 2);		/* to EOF */
    gfLen = ftell (fp);
    do
	fseek (fp, --gfLen, 0);
    while ((c = GetUnsigned1 (fp)) == postfill);
    if (c != GfVersion)
	goto error;
    fseek (fp, -5, 1);
    gfLen = GetSigned4 (fp);	/* address of post command */
    fseek (fp, gfLen, 0);
    if (GetUnsigned1 (fp) != post)
	goto error;
    gBack = GetSigned4 (fp);
    DesignSize = GetSigned4 (fp) / 1048576.0 /* 2<<20 */ ;
    gCheckSum = GetSigned4 (fp);
    Resolution[X] = GetSigned4 (fp);
    Resolution[Y] = GetSigned4 (fp);
    minX = GetSigned4 (fp);
    maxX = GetSigned4 (fp);
    minY = GetSigned4 (fp);
    maxY = GetSigned4 (fp);
 /* Height = maxY-minY+1; Descent = -minY; -- not needed */
    minChar = 255;
    maxChar = 0;
    while ((i = GetUnsigned1 (fp)), (i == char_loc || i == char_loc0))
      {
	register struct CharData   *tabP;
	if (c < minChar)
	    minChar = c;
	if (c > maxChar)
	    maxChar = c;
	c = GetUnsigned1 (fp);
	tabP = &FontTab[c];
	if (NEW_GF && i == char_loc0)
	    tabP->width[X] = (unsigned char)fgetc(fp) << 16;
	else
	    tabP->width[X] = GetSigned4 (fp);
	if (i == char_loc)
	    tabP->width[Y] = -GetSigned4 (fp);
	else tabP->width[Y] = 0;
	tabP->TFMwidth = GetSigned4 (fp);
	tabP->wordInFile = GetSigned4 (fp);
	tabP->status = NotReadChar;
      }
    return 1;
  error: 
    printf ("Not a valid gf file!\n");
    fflush (stdout);
    return 0;
  }


MemRaster *
LoadGfChar (ch)
  {
    register struct CharData   *tabP = &FontTab[ch];
#define bufLen 256
    MemRaster * r;
    char    buf[bufLen + 1];
    int     i,
            color = 0,
            minX,
            maxX,
            minY,
            maxY,
            x,
            y,
            coord = 99,
            saveX;
    if (tabP->status != NotReadChar)
	return (tabP->raster);
    buf[bufLen] = 0;
    fseek (inFont, tabP->wordInFile, 0);
    for (; i = GetUnsigned1 (inFont);)
	switch (i) {
	    case xxx1: 
		i = GetUnsigned1 (inFont);
		goto xxxLab;
	    case xxx2: 
		i = GetUnsigned2 (inFont);/* goto xxxLab; */
	xxxLab: 
		if (i <= bufLen)
		  {
		    fread (buf, i, 1, inFont);
		    buf[i] = 0;
		  }
		else
		  {
		    fread (buf, bufLen, 1, inFont);
		    fseek (inFont, i - bufLen, 1);
		  }
		if (*buf != ' ')
		  {
		    coord = 99;
		    continue;
		  }
		coord = 0;
		continue;
	    case yyy: 
		i = GetSigned4 (inFont);
		i >>= 16;	/* MF scale factor */
		if (coord == 1)
		  {
		    if (tabP->proofItem < 0)
		      {
			tabP->proofItem = ProofItemBase + ch;
			DefineSymbol (sdf, tabP->proofItem, NULL);
		      }
		    AddItem (sdf, 0, saveX, saveX, i, i, 0, SDF_SIMPLE_TEXT, buf + 2);
		  }
		coord++;
		saveX = i;
		continue;
	    case boc1:
		if (GetUnsigned1(inFont) == ch)
		    goto bocFound;
		goto err;
	    case boc: 
		if (GetSigned4 (inFont) == ch)
		    goto bocFound;
	    /* else fall through ... */
	    default:
	    err:
		printf (stderr,
		"Error in gf file (position %d) trying to read char '\%o'!\n",
		ftell(inFont), ch);
		fflush (stdout);
		return 0;
	}
bocFound:
    if (i == boc1 && NEW_GF)
      {
	i = GetUnsigned1(inFont);
	maxX = GetUnsigned1(inFont);
	minX = maxX - i;
	i = GetUnsigned1(inFont);
	maxY = GetUnsigned1(inFont);
	minY = maxY - i;
      }
    else
      {
	if (GetSigned4 (inFont) != -1)
	  {
	    printf ("Cannot handle huge gf fonts!\n");
	    fflush (stdout);
	    return 0;
          }
        minX = GetSigned4 (inFont);
        maxX = GetSigned4 (inFont);
        minY = GetSigned4 (inFont);
        maxY = GetSigned4 (inFont);
      }
    maxX--; x = minX; y = maxY;
    tabP->origin[X] = -x;
    tabP->origin[Y] = maxY + 1;
    tabP->bBox[Y] = maxY - minY + 1;
    tabP->bBox[X] = maxX - minX + 1;
    if (tabP->bBox[X] == 0)
	tabP->bBox[Y] = 0;	/* Knuth!! kluge */
    r = AllocRaster (0, tabP->bBox[Y], tabP->bBox[X]);
    x = 0;
    while ((ch = GetUnsigned1 (inFont)) != eoc)
      {
	register int    n;
	if (ch >= paint_1 && ch <= paint_63)
	  {
	    n = ch - (paint_1 - 1);
	    goto paint;
	  }
	if (ch >= new_row_0 && ch <= (new_row_0 + max_new_row))
	  {
	    n = ch - new_row_0;
	    goto new_row;
	  }
	/* temporary hacks so we can read both new and old formats */
	if (ch == skip0) { n = 0; goto skip;}
	if (ch == skip1) { n = GetUnsigned1(inFont); goto skip;}
	if (ch == skip2) { n = GetUnsigned2(inFont); goto skip;}
	switch (ch)
	  {
	    case paint_0: 
		n = 0;
		goto paint;
	    case paint1: 
		n = GetUnsigned1 (inFont);
		goto paint;
	    case paint2: 
		n = GetUnsigned2 (inFont);
		goto paint;
#if 0
	    case skip0: 
		n = 0;
		goto skip;
	    case skip1: 
		n = GetUnsigned1 (inFont);
		goto skip;
	    case skip2: 
		n = GetUnsigned2 (inFont);
		goto skip;
#endif
	    /* 	    case newrow: n = GetSigned4(inFont); goto new_row; */
	    case no_op: 
		continue;
	    case xxx1: 
		n = GetUnsigned1 (inFont);
		goto xxx;
	    case xxx2: 
		n = GetUnsigned2 (inFont);
		goto xxx;
	    case xxx3: 
		n = GetUnsigned3 (inFont);
		goto xxx;
	    case yyy: 
		n = GetSigned4 (inFont);
		goto xxx;
	    default: 
		printf ("unknown mf op: %d at 0x%x!\n", ch, ftell (inFont) - 1);
	    /* abort(); */
		continue;
	  }
xxx: 
	fseek (inFont, n, 1);
	continue;
skip: 
	y -= n + 1;
	x = 0;
	color = 0;
	continue;
new_row: 
	y--;
	x = n;
	color = 1;
	continue;
paint: 
	if (color == 0)
	    x += n;
	else
	    while (--n >= 0)
		ChangeBit (r, x++, maxY - y, 1);
	color = 1 - color;
      }
    if (tabP->proofItem >= 0)
	EndSymbol (sdf, tabP->proofItem, 0);
    tabP->status = InCoreChar;
    return tabP->raster = r;
  }

#undef NEW_GF
#define NEW_GF 1

static  gf_paint (d, f)	
 /* generate appropriately-size gf paint command */
    FILE * f;
  {
    if (d < 0)
      {
	fprintf (stderr, "Huh? gf_paint d=%d\n", d);
	fflush (stderr);
	d = 0;
      }
    if (d < 64)
	putc (paint_0 + d, f);
    else if (d < 256)
      {
	putc (paint1, f);
	putc (d, f);
      }
    else
      {
	putc (paint2, f);
	PutUnsigned2 (d, f);
      }
  }

WriteGfFont (f)
    FILE * f;
  {
    int     i, ch;
    char   *p;
    register struct CharData   *tabP;
#define INF 0x7FFF
    int     minX = INF,
            maxX = -INF,
            minY = INF,
            maxY = -INF;
    long    post_addr;		/* address of post-amble */
    int     outPos[256];

 /* write out preamble */
    fputc (pre, f);
    fputc (gf_magic, f);
    for (p = curFontName; *p != '\0' && *p != '.'; p++) { }
    i = p - curFontName;
    if (i > 127)
	i = 127;
    fputc (i, f);
    fwrite (curFontName, i, 1, f);

 /* write out each character in the font */
    for (ch = 0, tabP = FontTab; ch <= 255; ch++, tabP++)
	if (tabP->status == NullChar)
	    outPos[ch] = -1;
	else
	  {
	    int     dx,
	            dy,
	            h,
	            w;

	    outPos[ch] = ftell (f);
	    if (tabP->status == NotReadChar)
	      {
		(*LoadChar) (ch);
		tabP->status = NotReadChar;
	      }

	    if (BoundingBox (tabP->raster, &dx, &dy, &h, &w))
	      {
		struct BitPtr   bitPtr;
		int     color;
		int
		        c_minX = dx - tabP->origin[X],
		        c_maxX = w + c_minX,
		        c_maxY = tabP->origin[Y] - dy - 1,
		        c_minY = c_maxY - h + 1;
		if ((unsigned)c_maxX < 256 && (unsigned)c_maxY < 256
		  && (unsigned)(c_maxX - c_minX) < 256
		  && (unsigned)(c_maxY - c_minY) < 256)
		  {
		    fputc(boc1, f);
		    fputc(ch, f);
		    fputc(c_maxX - c_minX, f);
		    fputc(c_maxX, f);
		    fputc(c_maxY - c_minY, f);
		    fputc(c_maxY, f);
		  }
		else
		  {
		    putc(boc, f);
		    PutSigned4((unsigned char) ch, f);
		    PutSigned4(-1, f);	/* no backpointer */
		    PutSigned4(c_minX, f);
		    PutSigned4(c_maxX, f);
		    PutSigned4(c_minY, f);
		    PutSigned4(c_maxY, f);
		  }
		if (c_minX < minX)
		    minX = c_minX;
		if (c_maxX > maxX)
		    maxX = c_maxX;
		if (c_minY < minY)
		    minY = c_minY;
		if (c_maxY > maxY)
		    maxY = c_maxY;

		SetBitPtr (&bitPtr, tabP->raster, dx, dy);
		for (color = SearchWhite;;)
		  {
		    int     x0 = bitPtr.x,
		            y0 = bitPtr.y,
		            delta_y,
		            delta_x;
		    color = !color;/* next color */
		    if (SearchBit (&bitPtr, color | SearchEdge) == 1)
			gf_paint (bitPtr.x - x0, f);
		    else
		      {
			if (color == SearchWhite)
			    gf_paint (bitPtr.x - x0, f);
			if (SearchBit (&bitPtr, SearchBlack|SearchDown) != 1)
			    break;
			delta_x = bitPtr.x - tabP->origin[X] - c_minX;
			delta_y = bitPtr.y - y0 - 1;
			if (delta_x < 0 || delta_x > max_new_row)
			  {
			    fprintf (stderr, "Huh? delta_x=%d\n", delta_x);
			    fflush (stderr);
			  }
			if (delta_y == 0 && delta_x <= max_new_row)
			    putc (new_row_0 + delta_x, f);
			else 
			  {
			    if (delta_y >= 256)
			      { fputc (skip2, f); PutUnsigned2 (delta_y, f); }
			    else if (delta_y > 0)
			      { fputc (skip1, f); fputc (delta_y, f); }
			    else
				fputc (skip0, f);
			    gf_paint (delta_x, f);
			  }
			color = SearchBlack;
		      }
		  }
	      }
	    else
	      {		/* empty character */
		putc (boc1, f);
		putc ((unsigned char) ch, f);
		for (i = 4; --i >= 0;)
		    putc (0, f);
	      }

	    putc (eoc, f);
	    if (tabP->status == NotReadChar)
	      {
		FreeMemRaster (tabP->raster);
		tabP->raster = NULL;
	      }
	}

 /* write out postamble */
    post_addr = ftell (f);
    fputc (post, f);
    PutSigned4 (post_addr, f);
    PutSigned4 ((long) (DesignSize * (double) (1 << 20) + 0.5), f);
    PutSigned4 (0, f);		/* checksum */
    PutSigned4 (Resolution[X], f);
    PutSigned4 (Resolution[Y], f);
    PutSigned4 (minX, f);
    PutSigned4 (maxX, f);
    PutSigned4 (minY, f);
    PutSigned4 (maxY, f);
    for (ch = 0, tabP = FontTab; ch <= 255; ch++, tabP++)
	if (tabP->status != NullChar)
	  { int wide;
	    wide = tabP->width[Y] != 0 || (tabP->width[X] & 0xFF00FFFF) != 0;
	    putc (wide ? char_loc : char_loc0, f);
	    putc (ch, f);
	    if (wide)
	      {
		PutSigned4 (tabP->width[X], f);
		PutSigned4 (-tabP->width[Y], f);
	      }
	    else
		fputc(tabP->width[X] >> 16, f);
	    PutSigned4 (FakeTFMwidth (tabP), f);
	    PutSigned4 (outPos[ch], f);
	  }
    fputc (postpost, f);
    PutSigned4 (post_addr, f);
    fputc (gf_magic, f);
    for (i = 7 - ((ftell (f) + 3) & 3); --i >= 0;)
	putc (postfill, f);
  }
