/* utility subroutines helpful for parsing .b, .r and .a files */
#include <b.out.h>
#include <stdio.h>
/* -- file has been written so that it can be linked in with Vkernel library */
#include <ar.h>
#include <sys/types.h>
#include <ranlib.h>

static struct ar_hdr arhdr;
GetSymbol(fp, name, pos)
  FILE *fp; char *name; int *pos;
  /* 'fp' is a file opened for reading, either an archive file or a .b file
   in either case it is positioned just before the struct bhdr.
   Returns symbol type if found.
   Returns 0 if not found; -1 if read problems
   Afterwards, position undefined; use ftell beforehand.
   */
  {
    struct bhdr filhdr; struct sym cursym; char symBuf[128];
    int moreSymb; /* bytes remaining in a symbol section of binary file */
    fread(&filhdr, sizeof(filhdr), 1, fp);
    if (filhdr.fmagic == RMAGIC) reverselongs(1 + (long *)&filhdr, 7);
    fseek(fp, SYMPOS - sizeof(filhdr), 1);
    moreSymb = filhdr.ssize;
    while (moreSymb > 0)
      {
        fread(&cursym, sizeof(cursym), 1, fp);
	moreSymb -= sizeof(cursym);
	if (filhdr.fmagic == RMAGIC)
	  { /* if .b file, compensate for Vax alignment and byte-order */
	    fseek(fp, -2, 1); moreSymb -= 2;
	    if (!fread(&cursym.svalue, sizeof(cursym.svalue), 1, fp))
	        return(-1);
	    reverselongs(&cursym.svalue, 1);
	  }
	fread(symBuf, cursym.slength, 1, fp);
	if (EqString(symBuf, name, cursym.slength)
	  && (cursym.stype == EXTERN + DATA || cursym.stype == EXTERN + TEXT))
	    { if (pos) *pos = cursym.svalue; return cursym.stype;}
	if (cursym.slength & 1) { fgetc(fp); moreSymb--; }
	moreSymb -= cursym.slength;
      }
    return 0;
  }
  
RanlibOffset(fp, name, ignoreCase)
    FILE *fp; char *name;
 /* fp is a Unix random archive, positioned just before the __.SYMDEF file,
  * just after the arhdr. Position at return is undefined.
  * name is a identifier which is defined in some .b or .o component in fp.
  * It returns the offset in the file of the component (or rather the arhdr
  * just before it).
  * If it fails, it returns 0.
  * if ignoreCase, case is ignored when comparing identifiers.
  */
  { int i, strTabLen, symNo = 0;
    fread(&i, 4, 1, fp); reverselongs(&i, 1);
    fseek(fp, i, 1);
    fread(&strTabLen, 4, 1, fp); reverselongs(&strTabLen, 1);
    for (; strTabLen > 0; symNo++)
      { char *cp = name;
	for (; ;)
	  { register char cn = *cp++, cf = fgetc(fp);	            
	    strTabLen--;
	    if (ignoreCase)
	      {
		if (cn >= 'A' && cn <= 'Z') cn += 'a' - 'A';
		if (cf >= 'A' && cf <= 'Z') cf += 'a' - 'A';
	      }
	    if (cf != cn)
	      {
	        while (cf) {cf = fgetc(fp); strTabLen--;}
		break;
	      }
	    if (!cf)
	      {
		fseek(fp, SARMAG + sizeof(arhdr) + (symNo<<3) + 8, 0);
		fread(&i, 4, 1, fp);
		reverselongs(&i, 1);
		return i;
	      }
	  }
     }
    return 0;
  }
/*
GetComponent(fp, name, segStart, segOffset, segLength)
    FILE *fp; char *name; int *segStart, *segOffset, *segLength;
 * fp is a archive file (.a format) opened for reading, positioned ??
    Output: byte offset for .b file, or non-positive error code
  *
  { long i, curfilestart;
	fread(&arhdr,sizeof(arhdr), 1, fp);
	if (strncmp(arhdr.ar_name, "__.SYMDEF       ", 12) == 0)
	  i = RanlibOffset(fp, name);
	  if (i>0) i += sizeof(arhdr)
	fread(&filhdr, sizeof(filhdr), 1, fp);
      }
  }
  nextComp:
    if (curfilestart)
      {
	curfilestart += ((atoi(arhdr.ar_size) + 1) >> 1) << 1;
      endComp:
	fseek(fp, curfilestart, 0);
	if (!fread(&arhdr,sizeof(arhdr), 1, fp))
	    return((FontEntry *)FontNotInFile);
	curfilestart += sizeof(arhdr);
	i = GetSymbol(fp, name, 0);
	if (
	fread(&filhdr, sizeof(filhdr), 1, fp);
	goto nextComp;
      }
    return((FontEntry *)FontNotInFile);
  }
*/
EqString(s1, s2, n)
    register char *s1, *s2; register n;
/* return 1 if s1=s2, ignoring case. n is maximum length
 * s1 must be != 0. s2 can be 0, in which case 0 is returned.
 */
  {
    if (!s2) return 0;
    for ( ; -- n >= 0; )
      { register char c1  = *s1++, c2 = *s2++;
	if (c1 >= 'A' && c1 <= 'Z') c1 += 'a' - 'A';
	if (c2 >= 'A' && c2 <= 'Z') c2 += 'a' - 'A';
	if (c1 != c2) return 0;
	if (!c1) return 1;
      }
    return 1;
  }

reverselongs(p,n)
  /* byte reverse n longs: *p..p[n-1] */
  long *p; int n;
  {
    union
      {
	long l;
	char c[4];
      } ul;
    char ch;

    while (--n >= 0)
      {
	ul.l = *p;
	ch = ul.c[2]; ul.c[2] = ul.c[1]; ul.c[1] = ch;
	ch = ul.c[3]; ul.c[3] = ul.c[0]; ul.c[0] = ch;
	*p++ = ul.l;
      }
  }
