/* part of the 'bits' bitmap/font editor. (c) Per Bothner Nov 1983.
 * Routines for dealing with fonts, especially i/o.
 */
#include "bits.h"
#include <ar.h>
#include <b.out.h>
#include <sfont.h>
File *inFont = 0;
long offsetInFile = 0;
short underLineTop = 3, underLineWidth = 1,
    maxWidth = 8, indexable = 0,
    minChar = 0, maxChar = 127,
    Height = 0, CharAlign = 1;
short Descent = 0;	/* maximum descent below baseline */
Scaled Resolution[2] = {-1, -1};
char ResolutnStr[22] = "?";
float DesignSize = 10.0;
#define InitTFMscaling 2.6391983296e-5
float TFMscaling = InitTFMscaling;
enum FontFormats FontFormat;
struct CharData FontTab[257];
extern char name[], unknownStr[];
extern MemRaster *LoadSFChar(), *LoadPxlChar(), *LoadGfChar();
MemRaster *(*LoadChar)() = 0;

char *FontFileSuffix[] = {".sf", ".a", "pxl", ".gf"};
static FormatScaled(str, x)
    char *str; Scaled x;
  {
    if (x == -1) sprintf(str, "? ");
    else sprintf(str, "%g ", (double)x / 65536.0);
  }
static UpdateResolution()
  {
    FormatScaled(ResolutnStr, Resolution[Y]);
    if (Resolution[X] != Resolution[Y])
      {
	strcat(ResolutnStr, "* ");
	FormatScaled(ResolutnStr+strlen(ResolutnStr), Resolution[Y]);
      }
 }

LoadFont(field)
    Field *field;
  { enum FontFormats format = (enum FontFormats)field->value;
    MemRaster *r; char *s; int ch;
    printf("Load font: "); Flush(stdout);
    if (!GetString()) return(0);
    if (inFont > 0) fclose(inFont);
    inFont = 0;
    /* quick hack to guess at design size for non-Pxl fonts */
    s = name + strlen(name);
    while (((ch = *--s) < '0' || ch > '9') && s > name) {}
    if (s <= name) DesignSize = 10.0;
    else
      { int i = 5;
	while (--i >= 0 && (ch = *--s) >= '0' && ch <= '9') {}
	i = atoi(s+1);
	DesignSize = i;
      }    
    strncpy(curFontName,name,25);
    if (format==SfArchive)
      {
	printf("Font file (default is /usr/sun/lib/libsfonts.a): ");
	Flush(stdout);
	if (!GetString()) goto error;
	if (!*name) strcpy(name, "/usr/sun/lib/libsfonts.a");
      }
    inFont = fopen(name,"r");
    if (inFont <= 0)
        inFont = fopen(strcat(name, FontFileSuffix[(int)format]), "r");
    if (inFont <= 0)
      {printf("Font file not found!\n"); goto error;}
    ClearFont(1);
    FontFormat = format;
    switch (format)
      {
	case SfFile:
		offsetInFile = 0;
		LoadSFont(inFont); LoadChar = LoadSFChar;
		break;
	case SfArchive:
		fseek(inFont, SARMAG + sizeof(struct ar_hdr), 0);
		offsetInFile = RanlibOffset(inFont, curFontName, 1);
		if (offsetInFile <= 0)
		  {printf("Font not found in file!\n"); goto error;}
		offsetInFile += sizeof(struct ar_hdr) + sizeof(struct bhdr);
		LoadSFont(inFont); LoadChar = LoadSFChar;
		break;
	case PxlFile:
		LoadPxlFont(inFont); LoadChar = LoadPxlChar; break;
	case GfFile:
		LoadGfFont(inFont); LoadChar = LoadGfChar; break;
      }
 /* bits used to only load characters on demand. We now always load */
    for (ch = 255; --ch >= 0; )
	LoadChar(ch);
    CalculateTFMscaling();
    CalculateDescentAndHeight();
    UpdateResolution();
    DoRedraw();
    return 1;
  error:
    inFont = 0; LoadChar = 0;
    Flush(stdout);
    return 0;
  }

WriteFont(field)
    Field *field;
  { enum FontFormats format = (enum FontFormats)field->value;
    File *fp;
    printf("Write font: "); Flush(stdout);
    if (!GetString()) return(0);
    fp = fopen(name,"r");
    if (fp != NULL)
      { char ch;
	fprintf(stderr,
	    "WARNING: There already exists a file with that name!\n");	
	fprintf(stderr,"Are you sure you want to overwrite it?");
	ch = GETCHAR();
	if (ch != 'y' && ch != 'Y') {fclose(fp); return 0;}
      }
    fp = fopen(name,"w");
    if (fp <= 0) {printf("Couldn't create file!\n"); Flush(stdout); return 0;}
    switch (format)
      {
	case GfFile: WriteGfFont(fp); break;
	case SfFile: WriteSFont(fp); break;
	case PxlFile: WritePxlFont(fp); break;
      }
    fclose(fp);
    printf("Done!\n"); fflush(stdout);
  }

LoadPxlFont(fp)
    FILE *fp;
  { long i, dirP, magnification; double scaling;
    minChar = 0; maxChar = 127;
    Height = 0; Descent = 0;
    i = GetSigned4(fp);
    if (i != 1001)
      {printf("Bad PXL ID in pxl font file: %d!\n", i); fflush(stdout);}
    fseek(fp, -16, 2);
    magnification = GetSigned4(fp);
    Resolution[X] = Resolution[Y] = (magnification << 16) / 5;
    DesignSize = GetSigned4(fp) / 1048576.0; /* divide by 2^24 */
    scaling = DesignSize * (double)magnification / 5781.6;
    /* Note: 5781.6 = 72.27 * (1000/200) * (2**20/2**16) */
    dirP = GetSigned4(fp);
    i = GetSigned4(fp);
    if (i != 1001)

      {printf("pxl font file truncated? Bad PXL ID: %d!\n", i); fflush(stdout);}
    fseek(fp, dirP<<2, 0);
    for (i = minChar; i <= maxChar; i++)
      { register struct CharData *tabP = &FontTab[i];
	tabP->bBox[X] = GetSigned2(fp);
	tabP->bBox[Y] = GetSigned2(fp);
	tabP->origin[X] = GetSigned2(fp);
	tabP->origin[Y] = GetSigned2(fp);
	tabP->wordInFile = GetSigned4(fp);
	tabP->TFMwidth = GetSigned4(fp);
	tabP->width[X] = (Scaled)(tabP->TFMwidth * scaling + 0.5);
	tabP->status = tabP->wordInFile ? NotReadChar : NullChar;
      }
  }

WritePxlFont(fp)
    FILE *fp;
  { long i, ch, wMax = 0, hMax = 0, h, w, dirP; char mustLoad, *strike;
    int outPos[128];
    register struct CharData *tabP;
    i = 1001; fwrite(&i, 4, 1, fp);
    for (ch = 0, tabP = FontTab; ch <= 127; ch ++, tabP++)
      {
	if ((i = tabP->bBox[Y]) > hMax) hMax = i;
	if ((i = tabP->bBox[X]) > wMax) wMax = i;
      }
    /* write out the bitmaps */
    strike = (char *)(malloc(hMax * (((wMax+31)>>5)<<2)));
    for (ch = 0, tabP = FontTab; ch <= 127; ch ++, tabP++)
      { MemRaster *r; short *wp;
	int rowWidth; /* width of strike in bytes per row */
	mustLoad = tabP->status == NotReadChar;
	if (mustLoad) (*LoadChar)(ch);
	r = tabP->raster; h = r->height;
	w = r->width; rowWidth = ((w+31)>>5)<<2;
	/* clear rightmost column */
/*	for (i = h, wp = (short*)strike - 1; --i >= 0; )
	  { wp = (short*)((char*)wp + rowWidth); *wp = 0;}
*/
	ColToRowRaster(strike, r->start, h, (w+15)>>4, rowWidth);
	outPos[ch] = tabP->status == NullChar ? 0 : ftell(fp) >> 2;
	fwrite(strike, rowWidth, h, fp);
	if (mustLoad)
	  {
	    FreeMemRaster(r); tabP->raster = NULL;
	    tabP->status = NotReadChar;
	  }
      }
    free(strike);
    /* write out the directory */
    dirP = ftell(fp) >> 2;
    for (ch = 0, tabP = FontTab; ch <= 127; ch ++, tabP++)
      {
	PutSigned2(tabP->bBox[X], fp);
	PutSigned2(tabP->bBox[Y], fp);
	PutSigned2(tabP->origin[X], fp);
	PutSigned2(tabP->origin[Y], fp);
	PutSigned4(outPos[ch], fp);
	PutSigned4(FakeTFMwidth(tabP), fp);
      }
    i = 0; fwrite(&i, 4, 1, fp); /* checksum */
    if (Resolution[X] != Resolution[Y])
	fprintf(stderr, "Warning - differing vert.&hor. resolution!\n");
#define Magnification ((5*Resolution[X])>>16)
    PutSigned4(Magnification, fp);
    i = DesignSize * 1048576.0; fwrite(&i, 4, 1, fp);
    i = dirP; fwrite(&i, 4, 1, fp);
    i = 1001; fwrite(&i, 4, 1, fp);
  }

LoadSFont(fp)
    File *fp;
  { int ch; CharInfo cInfo;
    register struct CharData *tabP;
    fseek(fp, offsetInFile, 0);
    GetUnsigned2(fp);
    Height = GetUnsigned2(fp);
    maxWidth = GetUnsigned2(fp);
    Descent = GetUnsigned2(fp);
    minChar = getc(fp); maxChar = getc(fp);
    ch = 0xFF & getc(fp);
    underLineTop = ch >> 3;
    underLineWidth = ch & 7;
    ch = 0xFF & getc(fp);
    CharAlign = ch & 0x40 ? 16 : ch & 0x20 ? 8 : 1;
    fseek(fp, 4, 1);
    for (ch = minChar, tabP = FontTab+minChar; ch <= maxChar; ch ++, tabP++)
      { tabP = &FontTab[ch]; 
	fread(&cInfo, 4, 1, fp); /* won't work for little-endian machines! */
	tabP->status = NotReadChar;
	tabP->bBox[X] = cInfo.width;
	tabP->width[X] = tabP->bBox[X] << 16;
	if (tabP->bBox[X] == 0)
	    tabP->status = NullChar;
	tabP->bit = cInfo.bit;
	tabP->origin[X] = 0; tabP->origin[Y] = Height - Descent; tabP->bBox[Y] = Height;
	tabP->wordInFile = cInfo.word;
      }
  }

MemRaster *
LoadSFChar(ch)
    register unsigned char ch;
  {
    register struct CharData *tabP = &FontTab[ch];
    register offset = tabP->bit, width;
    register MemRaster *raster;
    if (tabP->status != NotReadChar) return (tabP->raster);
    fseek(inFont, tabP->wordInFile + offsetInFile, 0);
    width = offset + tabP->bBox[X];
    raster = AllocRaster(0, tabP->bBox[Y], width);
    fread(raster->start, (tabP->bBox[Y]*(width+15)>>4) << 2, 1, inFont);
    tabP->raster = UniqueCopy(
        SubRaster(0, raster, offset, 0, tabP->bBox[Y], width - offset));
    FreeMemRaster(raster);
    tabP->status = InCoreChar;
    return(tabP->raster);
  }

MemRaster *
LoadPxlChar(ch)
    register unsigned char ch;
  { short w, h, bytes; char *strike; MemRaster *r;
    if (FontTab[ch].status != NotReadChar) return (FontTab[ch].raster);
    w = FontTab[ch].bBox[X]; h = FontTab[ch].bBox[Y];
    bytes = (((w+31)>>5)<<2)*h;
    strike = (char *)(malloc(bytes));
    fseek(inFont, FontTab[ch].wordInFile << 2, 0);
    fread(strike, bytes, 1, inFont);
    r = AllocRaster(0, h, w);
    RowToColRaster(r->start, strike, h, (w+15)>>4, ((w+31)>>5)<<2);
    free(strike);
    FontTab[ch].status = InCoreChar;
    return(FontTab[ch].raster = r);
  }

WriteSFont(fp)
    File *fp;
  { int ch, w,i; MemRaster workRaster, leftWork, charWork;
    int xBit[257], curBit = 0;
    register struct CharData *tabP;
    maxWidth = 0;
 /* minChar = MINCHAR; maxChar = MAXCHAR;*/
    for (ch = 0, tabP = FontTab; ch <= 255; ch ++, tabP++)
      {
	/* Height and Descent are increased, if need be */
	if (tabP->bBox[Y] - tabP->origin[Y] > Descent)
	    Descent = tabP->bBox[Y] - tabP->origin[Y];
	if (tabP->bBox[Y] > Height) Height = tabP->bBox[Y];
	switch(tabP->status)
	  {
	    case NullChar: tabP->bBox[X] = 0; break;
	    case InCoreChar:
	        tabP->bBox[X] = tabP->raster->width; break;
	  }
	w = Width(ch);
	if (tabP->bBox[X] > w) w = tabP->bBox[X];
	curBit = ((curBit + CharAlign - 1) / CharAlign) * CharAlign;
	if (w)
	  {
/*	    if (ch < minChar) minChar = ch;
	    if (ch > maxChar) maxChar = ch;
*/
	    if (((~curBit) & 15) < (w+15) & 15)
		curBit = (curBit + 15) & 0xFFFFF0;
          }
	xBit[ch] = curBit;
	curBit += w;
        if (w > maxWidth) maxWidth = w;
      }
    xBit[256] = curBit;
    w = 2*SfontHeaderLen + 4*(maxChar-minChar+1) + 2*Height*((curBit+15)>>4);
    if (w >= 65536) {printf("Font too big to be described!\n"); return 0;}
    PutUnsigned2(w, fp);
    PutUnsigned2(Height, fp);
    PutUnsigned2(maxWidth, fp);
    PutUnsigned2(Descent, fp);
    putc(minChar, fp);
    putc(maxChar, fp);
    putc((underLineTop << 3) + underLineWidth, fp);
    putc(/* 0x80 * fixed + */ 0x40*(!(CharAlign&15)) + 0x20 * (!(CharAlign&7)) 
	+ 0x10 * (indexable > 0), fp);
    PutSigned4(0, fp); /* no kerning */
    /* write the CharInfo structures */
    i = 2 * (SfontHeaderLen + 2*(maxChar-minChar+1));
    for (ch = minChar, tabP = FontTab+minChar; ch <= maxChar; ch ++, tabP++)
      {
	PutSigned2(i + 2*(xBit[ch]>>4)*Height, fp);
	putc(xBit[ch] & 0xF, fp);
	w = Width(ch);
	if (tabP->bBox[X] > w) w = tabP->bBox[X];
	putc(w, fp);
      }
    /* write the actual bitmaps */
    AllocRaster(&workRaster, Height, (maxWidth+31)&0xFFF0);
    SubRaster(&leftWork, &workRaster, 0, 0, Height, 16);
    curBit = 0;
    for (ch = minChar, tabP = FontTab+minChar; ch <= maxChar; ch++, tabP++)
      { char mustLoad;
	if (curBit > (xBit[ch] & 0xF))
	  { /* write out old stuff */
	    if ((curBit&15) > (xBit[ch]&15)) curBit = (curBit + 15) & 0xFFF0;
	    fwrite(workRaster.start, curBit>>4, Height<<1, fp);
	    SubRaster(&charWork, &workRaster, curBit & 0xFFF0, 0, Height, 16);
	    RasterOp(&leftWork, &charWork, GXcopy);
	    curBit &= 15;
	  }
	curBit = (curBit & 0xFFF0) + (xBit[ch] & 0xF);
	w = Width(ch);
	if (tabP->bBox[X] > w)
	    w = tabP->bBox[X];
	else if (tabP->origin[X] < 0)
	    {curBit -= tabP->origin[X]; w += tabP->origin[X];}
	if (w == 0)
	    continue;
	SubRaster(&charWork, &workRaster, curBit, 0, Height, 16 - curBit & 15);
	RasterOp(&charWork, 0, GXclear);
	mustLoad = tabP->status == NotReadChar;
	if (mustLoad) (*LoadChar)(ch);
	SubRaster(&charWork, &workRaster,
	    curBit, Height - Descent - FontTab[ch].origin[Y],
	    tabP->raster->height, tabP->bBox[X]);
	RasterOp(&charWork, tabP->raster, GXcopy);
	curBit += w;
	if (mustLoad)
	  {FreeMemRaster(tabP->raster); tabP->status= NotReadChar;}
      }
    fwrite(workRaster.start, (curBit+15)>>4, Height<<1, fp);
    free(workRaster.start); /* Can't use FreeRaster since links are bad */
  }

ClearFont(init)
  { register ch; register struct CharData *tabP;
    for (ch = 0, tabP = FontTab; ch <= 255; ch++, tabP++)
      {
	if (!init)
	  {
	    if (tabP->status == InCoreChar) FreeMemRaster(tabP->raster);
	    if (tabP->proofItem >= 0) DeleteSymbol(sdf, tabP->proofItem);
	  } 
	tabP->status = NullChar;
	tabP->bBox[X] = 0;
	tabP->raster = &EmpRaster;
	tabP->inSample = 0;
	tabP->proofItem = -1;
	tabP->width[X] = 0; tabP->width[Y] = 0;
	tabP->TFMwidth = 0;
      }
  }
CalculateDescentAndHeight()
  { register struct CharData *tabP;
    Descent = 0; Height = 0;
    for (tabP = FontTab + 255; --tabP >= FontTab; )
      { register int curDescent = tabP->bBox[Y] - tabP->origin[Y];
	if (curDescent > Descent) Descent = curDescent;
	if (tabP->bBox[Y] > Height) Height = tabP->bBox[Y];
      }
  }
SetDescent(field)
  { short oldDescent = Descent; short delta;
    register struct CharData *tabP;
    if (ReadStdFld(field) < 1) return;
    delta = oldDescent - Descent;
    for (tabP = FontTab + 255; --tabP >= FontTab; )
      {
	tabP->origin[Y] = tabP->origin[Y] + delta;
      }
    DoRedraw();
  }
static ScaleAllTFMs(ratio)
    float ratio;
  { register struct CharData *tabP;
    for (tabP = FontTab + 255; --tabP >= FontTab; )
      {
	tabP->TFMwidth = tabP->TFMwidth * ratio + 0.5;
      }
  }
CalculateTFMscaling()
  { Scaled resolution;
    if (Resolution[X] != -1) resolution = Resolution[X];
    else if (Resolution[Y] != -1) resolution = Resolution[Y];
    else resolution = 200 * (1<<16);
    TFMscaling = (DesignSize  / 75780587.52) * (resolution>>16);
    if (TFMscaling == 0.0) TFMscaling = InitTFMscaling;
    /* the magic number is 72.27 (points/inch) * (2^20) (fixword) */
  }
SetTFMfield(field) /* Magnification or DesignSize */
    Field *field;
  {
    float oldTFMscaling = TFMscaling;
    if (ReadStdFld(field) < 1) return;
    if ((char*)field->value == (char*)ResolutnStr)
      { register char *s = ResolutnStr; int coord = 0;
	Resolution[X] = 0; Resolution[Y] = 0;
	while (*s == ' ' || *s == '\t') s++;

	if (Resolution[X] == -1) Resolution[X] = Resolution[Y];
	else if (Resolution[Y] == -1) Resolution[Y] = Resolution[X];
	UpdateResolution();
      }
    CalculateTFMscaling();
    ScaleAllTFMs(oldTFMscaling / TFMscaling);
    DoRedraw();
  }

#if 0
 not implemented
ListArchive(fp)
  { long i;
    /* seeks, tests */
    fread(&i, 4, 1, fp); reverselongs(&i, 1);
    fseek(fp, i, 1);
    fread(&i, 4, 1, fp); reverselongs(&i, 1);
  }
#endif
